/*
 *      Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 *      Licensed under the Flora License, Version 1.1 (the "License");
 *      you may not use this file except in compliance with the License.
 *      You may obtain a copy of the License at
 *
 *              http://floralicense.org/license/
 *
 *      Unless required by applicable law or agreed to in writing, software
 *      distributed under the License is distributed on an "AS IS" BASIS,
 *      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *      See the License for the specific language governing permissions and
 *      limitations under the License.
 */

/*global WEEKDAY: true, MONTH: true, pageHistory: true, util: true*/

var pageDetail = (function() {
    var page = document.getElementById('page-detail');

    /**
     * Shows the detail page.
     * @public
     */
    function show() {
        page.style.display = 'block';
    }

    /**
     * Hides the detail page.
     * @public
     */
    function hide() {
        page.style.display = 'none';
    }

    /**
     * Activates the detail page
     * @public
     * @param {string} key The value of special date
     * @param {string} id The id of event
     */
    function activate (key, id) {
        var page = document.getElementById('page-detail'),
            events = util.getEvents(),
            date, len, data,dateElement, nameContainerElement, nameIcon, nameElement, timeElement, contentElement, i;

        pageHistory.push(pageDetail);
        show();

        while (page.hasChildNodes()) {
            page.removeChild(page.firstChild);
        }

        date = new Date(key);
        events = events[key];
        len = events.length;
        for (i = 0; i < len; i++) {
            data = events[i];
            if (data.id === id) {
                dateElement = document.createElement('div');
                dateElement.classList.add('detail-date');
                dateElement.textContent = WEEKDAY[date.getDay()] + ', ' + MONTH[date.getMonth() + 1] + ' ' + date.getDate();
                page.appendChild(dateElement);

                nameContainerElement = document.createElement('div');
                nameContainerElement.classList.add('detail-event-name');
                nameIcon = document.createElement('span');
                nameIcon.classList.add('detail-name-icon');
                nameIcon.style.backgroundColor = data.color;
                nameElement = document.createElement('span');
                nameElement.classList.add('detail-name-text');
                nameElement.textContent = data.name;
                nameElement.appendChild(nameIcon);
                nameContainerElement.appendChild(nameElement);
                page.appendChild(nameContainerElement);

                timeElement = document.createElement('div');
                timeElement.classList.add('detail-time');
                if (data.allDay) {
                    timeElement.textContent = 'All day';
                } else {
                    timeElement.textContent = util.convertTimeFormat(data.startHours, data.startMinutes, data.endHours, data.endMinutes);
                }
                page.appendChild(timeElement);

                contentElement = document.createElement('div');
                contentElement.classList.add('detail-content');
                if (data.declined) {
                    nameElement.classList.add('event-declined');
                    contentElement.classList.add('event-declined');
                }
                contentElement.textContent = data.detail;
                page.appendChild(contentElement);
                break;
            }
        }
    }
    return {
        show: show,
        hide: hide,
        activate: activate
    };
})();
