/*
 *      Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 *      Licensed under the Flora License, Version 1.1 (the "License");
 *      you may not use this file except in compliance with the License.
 *      You may obtain a copy of the License at
 *
 *              http://floralicense.org/license/
 *
 *      Unless required by applicable law or agreed to in writing, software
 *      distributed under the License is distributed on an "AS IS" BASIS,
 *      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *      See the License for the specific language governing permissions and
 *      limitations under the License.
 */

/*exported pageHistory*/

var pageHistory = (function() {
    var history = [];

    /**
     * Pushes a page to the history.
     * @public
     * @param {Object} page The page to be pushed.
     */
    function push(page) {
        history.push(page);
    }

    /**
     * Pops a page from the history.
     * @public
     * @return {Object} page The page to be poped.
     */
    function pop() {
        return history.pop();
    }

    /**
     * Gets a current page from the history.
     * @public
     * @return {Object} page The page to be got.
     */
    function getCurrentPage() {
        return history[history.length - 1];
    }

    return {
        push: push,
        pop: pop,
        getCurrentPage: getCurrentPage
    };
})();
