/*
 *      Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 *      Licensed under the Flora License, Version 1.1 (the "License");
 *      you may not use this file except in compliance with the License.
 *      You may obtain a copy of the License at
 *
 *              http://floralicense.org/license/
 *
 *      Unless required by applicable law or agreed to in writing, software
 *      distributed under the License is distributed on an "AS IS" BASIS,
 *      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *      See the License for the specific language governing permissions and
 *      limitations under the License.
 */

/*global EVENT_DATA: true */
/*exported util*/

var util = (function() {
    /**
     * Gets the event data.
     * @public
     */
    function getEvents() {
        return EVENT_DATA;
    }

    /**
     * Convertes time format to string.
     * @public
     * @param {number} startHours The start hours to be converted.
     * @param {number} startMinutes The start minutes to be converted.
     * @param {number} endHours The end hours to be converted.
     * @param {number} endMinutes The end minutes to be converted.
     * @return {string} The converted time.
     */
    function convertTimeFormat(startHours, startMinutes, endHours, endMinutes) {
        var startTime = '',
            endTime = '',
            startAmPm = 'AM',
            endAmPm = 'AM';

        if (startHours) {
            if (startHours > 12) {
                startHours = startHours % 12;
                startAmPm = 'PM';
            }
            if (startMinutes < 10) {
                startMinutes = '0' + startMinutes;
            }
            startTime = startHours + ':' + startMinutes + startAmPm;
        }

        if (endHours) {
            if (endHours > 12) {
                endHours = endHours % 12;
                endAmPm = 'PM';
            }
            if (endMinutes < 10) {
                endMinutes = '0' + endMinutes;
            }
            endTime = endHours + ':' + endMinutes + endAmPm;
        }

        return startTime + ' - ' + endTime;
    }

    return {
        getEvents: getEvents,
        convertTimeFormat: convertTimeFormat
    };
})();
