/*
 *      Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 *      Licensed under the Flora License, Version 1.1 (the "License");
 *      you may not use this file except in compliance with the License.
 *      You may obtain a copy of the License at
 *
 *              http://floralicense.org/license/
 *
 *      Unless required by applicable law or agreed to in writing, software
 *      distributed under the License is distributed on an "AS IS" BASIS,
 *      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *      See the License for the specific language governing permissions and
 *      limitations under the License.
 */


/*
 * We must declare global variables to let the validator know the
 * global variables we use.
 * To declare global variables, write global variables along with
 * default values inside a comment on top of each source code.
 * The comment should start with the keyword, global.
 */

/* global MONTH: true*/

(function() {

    /**
     * Sets the calendar.
     * @private
     */
    function setCalendar() {
        var today = new Date(),
            events = getEvents(),
            calendar = document.getElementById('calendar'),
            year, month, date, day, eventList, firstDay, lastDate, key, el, img, count, i;

        // Gets today's year, month and date
        year = today.getFullYear();
        month = today.getMonth() + 1;
        date = today.getDate();

        document.getElementById('month').textContent = MONTH[month];

        today.setMonth(month);
        today.setDate(0);
        lastDate = today.getDate();
        today.setDate(1);
        firstDay = today.getDay();

        for (i = 0; i < firstDay; i++) {
            el = document.createElement('div');
            el.classList.add('days');
            if (i === 0) {
                el.classList.add('sunday');
            }
            calendar.appendChild(el);
        }

        for (i = 1; i <= lastDate; i++) {
            day = i + firstDay;
            el = document.createElement('div');
            el.classList.add('days');
            if (day % 7 === 1) {
                el.classList.add('sunday');
            } else if (day % 7 === 0) {
                el.classList.add('saturday');
            }
            el.textContent = i;
            calendar.appendChild(el);

            if (i === date) {
                el.classList.add('today');
            }

            // Generates key to get event data
            key = '' + year;
            key += month > 9 ? '-' + month : '-0' + month;
            key += i > 9 ? '-' + i : '-0' + i;

            // Gets the event list using the key value
            eventList = events[key];
            if (eventList) {
                img = document.createElement('img');
                img.classList.add('event-icon');
                img.src = i === date ? 'image/month_view_widget_schedule_today_event.png' : 'image/month_view_widget_schedule_event.png';
                el.appendChild(img);
            }
        }

        count = (42 - (firstDay + lastDate)) % 7;
        for (i = 1; i <= count; i++) {
            el = document.createElement('div');
            el.classList.add('days');
            if (i === count) {
                el.classList.add('saturday');
            }
            calendar.appendChild(el);
        }

        if (count + firstDay +lastDate === 35) {
            document.getElementById('calendar').style.paddingTop = '19px';
        } else if (count + firstDay + lastDate === 42) {
            document.getElementById('calendar').style.paddingTop = '3px';
        } else if (count + firstDay + lastDate === 28) {
            document.getElementById('calendar').style.paddingTop = '36px';
        }
    }

    /**
     * Gets the event data from schedule application using preference.
     * @private
     */
    function getEvents() {
        return JSON.parse(tizen.preference.getValue('events'));
    }

    /**
     * Launches the schedule application.
     * @private
     * @param {string} operation The action to be performed by an application control.
     */
    function launchApp(operation) {
        var app = window.tizen.application.getCurrentApplication();
        var appId = app.appInfo.id.substring(0, (app.appInfo.id.lastIndexOf('.')) );
        var appControl = new tizen.ApplicationControl(operation, null, null, null, null, null);
        window.tizen.application.launchAppControl(appControl, appId,
            function() {
                console.log("launch application control succeed");
            },
            function(e) {
                console.log("launch application control failed. reason: " + e.message);
            },
            null);
    }

    /**
     * Handles the back key event
     * @private
     * @param {Object} event The event object.
     */
    function keyEventHandler(event) {
        if (event.keyName === "back") {
            try {
                tizen.application.getCurrentApplication().exit();
            } catch (ignore) {}
        }
    }

    /**
     * Initializes the application
     * @private
     */
    function init() {
        setCalendar();

        // Launches the schedule application when the calendar is clicked
        document.getElementById('calendar').addEventListener('click', launchApp.bind(this, 'schedule/daily'));
        // Launches the schedule application when the calendar button is clicked
        document.getElementById('calendar-button').addEventListener('click', launchApp.bind(this, 'schedule/monthly'));
        // Adds eventListener for tizenhwkey
        window.addEventListener('tizenhwkey', keyEventHandler);
    }

    window.onload = init();
}());
