/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.device;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.json.simple.JSONObject;
import org.tizen.ecp.resources.FontResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.JsonUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.views.VMView;

public class DeviceTreeDisplay
extends ECPSubView
implements ILsn {
    private static Logger logger = LogUtil.getECPLogger(DeviceTreeDisplay.class).getLogger();
    private final String CMD_QTREE = "info qtree";
    private Font font = FontResources.FONT_9.getFont();
    private Tree tree = null;
    private Table table = null;
    private HashMap<String, ArrayList<String[]>> listMap = new HashMap();
    private SelectionAdapter tableSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            DeviceTreeDisplay.this.table.removeAll();
            TreeItem item = (TreeItem)e.item;
            ArrayList tableList = (ArrayList)DeviceTreeDisplay.this.listMap.get(item.getText());
            if (tableList != null) {
                for (String[] column : tableList) {
                    TableItem tablelist = new TableItem(DeviceTreeDisplay.this.table, 0);
                    tablelist.setText(column);
                }
            }
        }
    };
    private final String SPACE = " ";
    private final String COMMA = ",";
    private final String SPACE_EQUAL_SPACE = " = ";
    private final String DBL_SPACE = "  ";
    private final String LINE_INDICATOR = "\r\n";
    private final String CLASS_INDICATOR = "class ";
    private final String BAR_INDICATOR = "bar ";
    private final String ISA_INDICATOR = "isa ";
    private final String DEV_INDICATOR = "dev: ";
    private final String BUS_INDICATOR = "bus: ";

    public DeviceTreeDisplay() {
        this.title = "Device Tree";
        this.pageHeight = 510;
    }

    @Override
    public void createView(Composite composite) {
        Composite comp = new Composite(composite, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginBottom = 5;
        gl.verticalSpacing = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(1808));
        this.tree = new Tree(comp, 2308);
        GridData gd = new GridData(1040);
        gd.widthHint = 200;
        this.tree.setLayoutData((Object)gd);
        this.tree.setFont(this.font);
        this.tree.addSelectionListener((SelectionListener)this.tableSelection);
        this.table = new Table(comp, 2048);
        this.table.setFont(this.font);
        this.table.setHeaderVisible(true);
        gd = new GridData(4, 1, true, true);
        gd.minimumWidth = 278;
        gd.minimumHeight = 200;
        this.table.setLayoutData((Object)gd);
        TableColumn column = new TableColumn(this.table, 16384);
        column.setWidth(100);
        column.setText("  Attribute");
        TableColumn column2 = new TableColumn(this.table, 16384);
        column2.setWidth(100);
        column2.setText("  Value");
        this.table.setHeaderVisible(true);
    }

    @Override
    protected void initializeWidget() {
    }

    public void displayContents(VMView instance) {
        super.showComposite();
    }

    @Override
    public void OnEventProc(String eventname, JSONObject jsParam) {
        String message = (String)jsParam.get((Object)"return");
        this.tree.removeAll();
        this.parsingRoot(message);
    }

    private void parsingRoot(String msg) {
        int startIndex = 0;
        int lastIndex = 0;
        String[] lineSplit = msg.split("\r\n");
        String itemText = lineSplit[0].substring(5, lineSplit[0].length());
        TreeItem item = new TreeItem(this.tree, 0);
        item.setText(itemText);
        item.setExpanded(true);
        startIndex = lineSplit[0].length() + 2;
        lastIndex = msg.length();
        String subString = new String(msg.substring(startIndex, lastIndex));
        this.parsing(item, 1, subString);
    }

    private void parsing(TreeItem item, int depth, String msg) {
        boolean startBit = false;
        int startIndex = 0;
        int lastIndex = 0;
        int fromIndex = 0;
        String[] lineSplit = msg.split("\r\n");
        TreeItem newItem = null;
        ArrayList<String[]> text = new ArrayList<String[]>();
        for (String line : lineSplit) {
            int tabCount = 0;
            while (line.startsWith("  ")) {
                ++tabCount;
                line = line.substring("  ".length(), line.length());
            }
            if (tabCount == depth) {
                if (line.startsWith("dev: ") || line.startsWith("bus: ")) {
                    String itemText = null;
                    itemText = line.startsWith("dev: ") ? line.substring("dev: ".length(), line.indexOf(",")) : line.substring("bus: ".length(), line.length());
                    if (startBit) {
                        lastIndex = msg.indexOf(line, fromIndex) - depth * "  ".length();
                        if (lastIndex >= startIndex) {
                            String subString = msg.substring(startIndex, lastIndex);
                            this.parsing(newItem, depth + 1, new String(subString));
                        } else {
                            logger.warning("last index is smaller than start index.");
                        }
                        newItem = new TreeItem(item, 0);
                        if (depth <= 2) {
                            newItem.setExpanded(true);
                        }
                        newItem.setText(itemText);
                        startIndex = msg.indexOf(line, fromIndex) + line.length() + 2;
                    } else {
                        newItem = new TreeItem(item, 0);
                        if (depth <= 2) {
                            newItem.setExpanded(true);
                        }
                        newItem.setText(itemText);
                        startIndex = msg.indexOf(line, fromIndex) + line.length() + 2;
                        startBit = true;
                    }
                } else {
                    String[] msgSplit = null;
                    msgSplit = line.contains(" = ") ? line.split(" = ") : line.split(" ");
                    if (msgSplit.length == 2) {
                        text.add(msgSplit);
                    } else {
                        msgSplit = new String[2];
                        if (line.startsWith("class ")) {
                            msgSplit[0] = "class";
                            msgSplit[1] = new String(line.substring("class ".length(), line.length()));
                            text.add(msgSplit);
                        } else if (line.startsWith("bar ")) {
                            msgSplit[0] = new String(line.substring(0, "bar ".length() + 1));
                            msgSplit[1] = new String(line.substring("bar ".length() + 3, line.length()));
                            text.add(msgSplit);
                        } else if (line.startsWith("isa ")) {
                            msgSplit[0] = new String(line.substring(0, "isa ".length() - 1));
                            msgSplit[1] = new String(line.substring("isa ".length(), line.length()));
                            text.add(msgSplit);
                        } else {
                            logger.warning("attribute is not fit into the list: " + line);
                        }
                    }
                }
            }
            if (startBit && msg.indexOf(line, fromIndex) + line.length() + 2 == msg.length() && newItem != null) {
                lastIndex = msg.indexOf(line, fromIndex) + line.length() + 2;
                if (lastIndex >= startIndex) {
                    String subString = msg.substring(startIndex, lastIndex);
                    this.parsing(newItem, depth + 1, new String(subString));
                } else {
                    logger.warning("end index: last index is smaller than start index.");
                }
                startBit = false;
            }
            fromIndex += line.length() + "  ".length() * tabCount;
        }
        if (item != null && !item.getText().isEmpty() && text.size() > 0) {
            String inputText = item.getText();
            while (this.listMap.containsKey(inputText)) {
                inputText = inputText + " ";
            }
            item.setText(inputText);
            this.listMap.put(inputText, text);
        }
    }

    @Override
    public void OnEventProcPB(String eventname, GeneratedMessage param) {
    }

    private String createMsg() {
        String msg = JsonUtil.encodeMonitorString("execute", "human-monitor-command", "arguments", JsonUtil.encodeObject("command-line", "info qtree"), "Device Tree");
        return msg;
    }

    private void send() {
        MessageSender.getInstance().sendMonitorReq(this.createMsg());
    }

    @Override
    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsn("Device Tree", this);
        this.send();
        return true;
    }

    @Override
    public void OnActivate() {
        this.tree.removeAll();
        this.table.removeAll();
        this.send();
    }
}

