/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli.monitor.hds;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Logger;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.LogUtil;

public class HDSStatusCLI
extends AbstractEmulatorCLI {
    private static Logger logger = LogUtil.getECPLogger(HDSStatusCLI.class).getLogger();

    public HDSStatusCLI() {
        this.messageType = "hds";
    }

    @Override
    public int execute() {
        MessageSender.getInstance().sendDeviceReq("hds", 15, 99);
        this.startRunning();
        return 0;
    }

    @Override
    public void OnStatusEventProcPB(GeneratedMessage param) {
        Ecs.DeviceNtf ntf;
        if (param instanceof Ecs.DeviceNtf && 99 == (ntf = (Ecs.DeviceNtf)param).getAction()) {
            String data = ntf.getData().toStringUtf8();
            logger.info("HDS status is " + data);
            if (data == null || data.isEmpty()) {
                return;
            }
            String[] received = data.split(", ");
            if (received[0].equals("0")) {
                OutputUtil.println("Status: unmounted");
            } else if (received[0].equals("1") && received[1] != null && !received[1].isEmpty()) {
                OutputUtil.println("Status: mounted");
                OutputUtil.println("\tPath: " + received[1]);
            } else {
                this.returnValue = 128;
                OutputUtil.printFail();
                logger.info("unknown HDS status : " + data);
            }
            this.stopRunning();
        }
    }
}

