/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views;

import com.google.protobuf.GeneratedMessage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.json.simple.JSONObject;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.FontResources;
import org.tizen.ecp.resources.ImageResources;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.timer.MessageTimer;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.views.BaseView;
import org.tizen.ecp.views.VMView;

public abstract class ECPSubView
extends BaseView
implements ILsn {
    protected String title;
    protected int pageHeight = 300;
    protected int UPDATING_TIME = 200;
    protected boolean useTimer = false;
    protected VMView m_vmView = VMView.getInstance();

    protected abstract void initializeWidget();

    public String getTitle() {
        return this.title;
    }

    public void createPage() {
        GridLayout gL = new GridLayout(1, true);
        gL.marginHeight = 0;
        gL.marginWidth = 0;
        gL.horizontalSpacing = 0;
        gL.verticalSpacing = 0;
        this.m_compositeBase = new Composite(this.m_vmView.getComposite(), 0);
        this.m_compositeBase.setLayout((Layout)gL);
        this.m_compositeBase.setBackgroundMode(1);
        ScrolledComposite sc = new ScrolledComposite(this.m_compositeBase, 768);
        sc.setLayout((Layout)gL);
        sc.setLayoutData((Object)new GridData(1808));
        Composite comp = new Composite((Composite)sc, 0);
        comp.setSize(500, this.pageHeight);
        comp.setLayout((Layout)gL);
        comp.setLayoutData((Object)new GridData(1808));
        comp.setBackground(ColorResources.CONTENTS_BG.getColor());
        comp.setBackgroundMode(1);
        sc.setMinHeight(this.pageHeight);
        sc.setMinWidth(500);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.setContent((Control)comp);
        Composite tComp = FormUtil.createComposite(comp);
        GridData gd = new GridData(768);
        gd.heightHint = 32;
        tComp.setBackgroundImage(ImageResources.TITLE_BAR.getImage());
        tComp.setLayout((Layout)gL);
        tComp.setLayoutData((Object)gd);
        sc.showControl((Control)comp);
        Label tLabel = FormUtil.createLabel(tComp, this.title, FontResources.FONT_12.getFont());
        GridData gLabel = new GridData();
        gLabel.horizontalIndent = 10;
        gLabel.verticalIndent = 6;
        tLabel.setLayoutData((Object)gLabel);
        Composite space = FormUtil.createComposite(comp);
        GridData spaceGd = new GridData(768);
        spaceGd.heightHint = 4;
        space.setLayoutData((Object)spaceGd);
        this.createView(comp);
        this.initializeWidget();
        this.m_compositeBase.layout(true, true);
    }

    public abstract void createView(Composite var1);

    @Override
    public void showComposite() {
        this.m_vmView.getStackLayout().topControl = this.m_compositeBase;
        this.m_vmView.getComposite().layout();
    }

    public Composite getComposite() {
        return this.m_compositeBase;
    }

    @Override
    public boolean Create() {
        this.createPage();
        return true;
    }

    @Override
    public void OnActivate() {
        if (this.useTimer) {
            MessageTimer.getInstance().startTimer(this.UPDATING_TIME);
        }
    }

    @Override
    public void OnDeactivate() {
        if (this.useTimer) {
            MessageTimer.getInstance().StopTimer();
        }
    }

    @Override
    public void OnTimerMessageExpired() {
    }

    @Override
    public void Close() {
    }

    @Override
    public void OnEventProc(String eventname, JSONObject jsParam) {
    }

    @Override
    public void OnEventProcPB(String eventname, GeneratedMessage param) {
    }

    @Override
    public void OnStatusEventProcPB(GeneratedMessage param) {
    }
}

