/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.utils;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.FontResources;
import org.tizen.ecp.widgets.ECPButton;
import org.tizen.ecp.widgets.ECPSlider;

public class FormUtil {
    public static void setWidth(Control control, int width) {
        GridData gd = (GridData)control.getLayoutData();
        if (gd == null) {
            gd = new GridData();
            gd.widthHint = width;
            control.setLayoutData((Object)gd);
        } else {
            gd.widthHint = width;
        }
        gd.widthHint = width;
    }

    private static Composite setLayout(Composite composite, int cols, boolean equal) {
        GridLayout gLayout = new GridLayout(cols, equal);
        composite.setLayout((Layout)gLayout);
        return composite;
    }

    public static void addComboItem(Combo combo, Object[] items) {
        if (items == null || items.length == 0) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            combo.add(items[i].toString());
        }
        combo.select(0);
    }

    public static void addComboItem(Combo combo, Object[] items, Object selection) {
        if (items == null || items.length == 0) {
            return;
        }
        int idx = 0;
        for (int i = 0; i < items.length; ++i) {
            combo.add(items[i].toString());
            if (!items[i].equals(selection)) continue;
            idx = i;
        }
        combo.select(idx);
    }

    public static Combo createEditableCombo(Composite parent, int colspan) {
        Combo combo = FormUtil.createEditableCombo(parent);
        FormUtil.setColspan((Control)combo, colspan);
        return combo;
    }

    public static void setColspan(Control control, int colspan) {
        GridData gd = (GridData)control.getLayoutData();
        if (gd == null) {
            gd = new GridData();
            gd.horizontalSpan = colspan;
            control.setLayoutData((Object)gd);
        } else {
            gd.horizontalSpan = colspan;
        }
    }

    public static Combo createEditableCombo(Composite parent) {
        Combo combo = new Combo(parent, 4);
        combo.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        GridData gd = new GridData(4, 4, true, false);
        combo.setLayoutData((Object)gd);
        return combo;
    }

    public static Composite createComposite(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(4, 2, true, false));
        return comp;
    }

    public static Composite createAlignComposite(Composite parent, int horizentalAlignment, int verticalAlignment) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(horizentalAlignment, verticalAlignment, true, false));
        return comp;
    }

    public static Composite createStyleComposite(Composite parent, int style) {
        Composite comp = new Composite(parent, style);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(4, 2, true, false));
        return comp;
    }

    public static Composite createComposite(Composite parent, int cols) {
        return FormUtil.setLayout(FormUtil.createComposite(parent), cols, false);
    }

    public static Composite createComposite(Composite parent, int cols, boolean equal) {
        return FormUtil.setLayout(FormUtil.createComposite(parent), cols, equal);
    }

    public static Composite createBorderComposite(Composite parent, int cols, boolean equal) {
        return FormUtil.setLayout(FormUtil.createStyleComposite(parent, 2048), cols, equal);
    }

    public static Button createButton(Composite parent, String text) {
        return FormUtil.createButton(parent, text, 8);
    }

    public static Button createButton(Composite parent, String text, int flag) {
        Button button = new Button(parent, flag);
        button.setText(text);
        button.setLayoutData((Object)new GridData(4, 4, true, false));
        return button;
    }

    public static Label createLabel(Composite parent, String text) {
        return FormUtil.createLabel(parent, text, 10);
    }

    public static Label createLabel(Composite parent, String text, int indent, int widthHint) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gLabel = new GridData();
        gLabel.horizontalIndent = indent;
        gLabel.verticalAlignment = 0x1000000;
        if (widthHint != 0) {
            gLabel.widthHint = widthHint;
        }
        label.setLayoutData((Object)gLabel);
        return label;
    }

    public static Label createLabel(Composite parent, String text, int indent) {
        return FormUtil.createLabel(parent, text, indent, 0);
    }

    public static Label createLabel(Composite parent, String text, boolean width, int widthHint) {
        if (!width) {
            return FormUtil.createLabel(parent, text);
        }
        return FormUtil.createLabel(parent, text, 5, widthHint);
    }

    public static Label createLabel(Composite parent, String text, Font font) {
        Label label = FormUtil.createLabel(parent, text, 5);
        label.setFont(font);
        return label;
    }

    public static Label createLabel(Composite parent, String text, Font font, Color color) {
        Label label = FormUtil.createLabel(parent, text, font);
        label.setForeground(color);
        return label;
    }

    public static Label createLabel(Composite parent, String text, Font font, Color color, int indent) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gLabel = new GridData();
        gLabel.horizontalIndent = indent;
        gLabel.verticalAlignment = 0x1000000;
        label.setLayoutData((Object)gLabel);
        label.setFont(font);
        label.setForeground(color);
        return label;
    }

    public static Label createLabel(Composite parent, String text, int indent, Font font, Color color) {
        Label label = FormUtil.createLabel(parent, text, indent);
        label.setForeground(color);
        label.setFont(font);
        return label;
    }

    public static Slider createSlider(Composite parent) {
        return FormUtil.createSlider(parent, 256);
    }

    public static Slider createSlider(Composite parent, int style) {
        Slider slider = new Slider(parent, style);
        GridData gd = (style & 0x200) == 512 ? new GridData(2, 4, true, true) : new GridData(4, 2, true, true);
        slider.setLayoutData((Object)gd);
        return slider;
    }

    public static Text createText(Composite parent) {
        return FormUtil.createText(parent, 2048);
    }

    public static Text createText(Composite parent, int style) {
        Text text = new Text(parent, style);
        return text;
    }

    public static Text createText(Composite parent, String title) {
        Text text = FormUtil.createText(parent, 0x1000800);
        text.setText(title);
        text.setTextLimit(200);
        GridData gd = new GridData(4, 2, true, false);
        text.setLayoutData((Object)gd);
        return text;
    }

    public static Combo createCombo(Composite parent, int style) {
        Combo combo = new Combo(parent, style);
        return combo;
    }

    public static void addComboItem(Combo combo, ArrayList<String> items) {
        if (items == null || items.size() == 0) {
            return;
        }
        for (String item : items) {
            combo.add(item);
        }
        combo.select(0);
    }

    public static void addComboItem(Combo combo, ArrayList<String> items, Object selection) {
        if (items == null || items.size() == 0) {
            return;
        }
        int idx = 0;
        for (int i = 0; i < items.size(); ++i) {
            combo.add(items.get(i));
            if (!items.get(i).equals(selection)) continue;
            idx = i;
        }
        combo.select(idx);
    }

    public static ECPButton createPushButton(Composite parent, String text) {
        ECPButton button = FormUtil.createECPButton(parent, text, 8);
        GridData gd = FormUtil.createFullGD();
        gd.heightHint = 22;
        button.setLayoutData(gd);
        return button;
    }

    public static ECPButton createECPButton(Composite parent, String text, int flag) {
        ECPButton button = new ECPButton(parent, flag);
        button.setFont(FontResources.FONT_9.getFont());
        button.setText(text);
        return button;
    }

    public static ECPSlider createECPSlider(Composite parent) {
        return FormUtil.createECPSlider(parent, 0);
    }

    public static ECPSlider createECPSlider(Composite parent, int style) {
        GridData gd;
        ECPSlider slider = new ECPSlider(parent, style);
        if ((style & 0x200) == 512) {
            gd = new GridData(2, 4, true, true);
        } else {
            gd = new GridData(4, 2, true, false);
            gd.verticalIndent = 4;
        }
        slider.setLayoutData(gd);
        return slider;
    }

    public static GridData createGD() {
        GridData gd = new GridData();
        return gd;
    }

    public static GridData createGD(int align) {
        GridData gd = FormUtil.createGD();
        gd.horizontalAlignment = align;
        gd.grabExcessVerticalSpace = false;
        return gd;
    }

    public static GridData createGD(int wHint, int hHint) {
        GridData gd = FormUtil.createGD();
        gd.widthHint = wHint;
        gd.heightHint = hHint;
        return gd;
    }

    public static GridData createHGD() {
        GridData gd = FormUtil.createGD();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 0x1000000;
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    public static GridData createHGD(int align) {
        GridData gd = FormUtil.createGD();
        gd.horizontalAlignment = align;
        gd.grabExcessHorizontalSpace = true;
        return gd;
    }

    public static GridData createHGD(int wHint, int hHint) {
        GridData gd = FormUtil.createHGD();
        gd.widthHint = wHint;
        gd.heightHint = hHint;
        return gd;
    }

    public static GridData createHGD(int wHint, int hHint, int hIndent, int vIndent) {
        GridData gd = FormUtil.createHGD(wHint, hHint);
        gd.horizontalIndent = hIndent;
        gd.verticalIndent = vIndent;
        return gd;
    }

    public static GridData createFullGD() {
        GridData gd = FormUtil.createGD();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        return gd;
    }

    public static GridData createGD(int wHint, int hHint, int hIndent, int vIndent) {
        GridData gd = FormUtil.createGD(wHint, hHint);
        gd.horizontalIndent = hIndent;
        gd.verticalIndent = vIndent;
        return gd;
    }

    public static void createVerticalSpace(Composite comp, int vHint) {
        Composite space = new Composite(comp, 0);
        GridData gd = FormUtil.createGD();
        gd.heightHint = vHint;
        space.setLayoutData((Object)gd);
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?\\d+(.\\d+)?");
    }

    public static Label createH2Label(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setFont(FontResources.FONT_12.getFont());
        label.setForeground(ColorResources.TEXT_GREEN.getColor());
        GridData gLabel = new GridData();
        gLabel.horizontalIndent = 15;
        gLabel.verticalIndent = 5;
        label.setLayoutData((Object)gLabel);
        return label;
    }
}

