/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp;

import java.io.File;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.tizen.ecp.utils.FilePath;
import org.tizen.ecp.utils.JaxbUtil;
import org.tizen.ecp.vminfo.xml.BaseInformationType;
import org.tizen.ecp.vminfo.xml.DeviceType;
import org.tizen.ecp.vminfo.xml.EmulatorConfiguration;
import org.tizen.ecp.vminfo.xml.UsabilityType;

public class VMInfo {
    public static VMInfo m_inst = new VMInfo();
    private EmulatorConfiguration configuration = null;
    private String vmName = null;
    private int svrPort;
    private int basePort;

    public static VMInfo getInstance() {
        return m_inst;
    }

    public void initialize(String name, int basePort) throws JAXBException {
        this.vmName = name;
        this.basePort = basePort;
        this.svrPort = basePort + 3;
        String vmInfoPath = FilePath.getInstance().getVmsPath() + File.separator + this.vmName + File.separator + "vm_config.xml";
        JAXBElement<?> element = JaxbUtil.unmarshal(vmInfoPath, EmulatorConfiguration.class);
        this.configuration = (EmulatorConfiguration)element.getValue();
    }

    public BaseInformationType getBaseInformation() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.getBaseInformation();
    }

    public DeviceType getDevice() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.getDevice();
    }

    public UsabilityType getUsability() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.getUsability();
    }

    public String getProfile() {
        if (this.configuration == null || this.configuration.getBaseInformation() == null || this.configuration.getBaseInformation().getDiskImage() == null) {
            System.out.println("cannot get base information.");
            return null;
        }
        return this.configuration.getBaseInformation().getDiskImage().getProfile();
    }

    public String getVMName() {
        return this.vmName;
    }

    public int getSvrPort() {
        return this.svrPort;
    }

    public int getSdbPort() {
        return this.basePort;
    }

    public String getPluginPath() {
        return FilePath.getInstance().getPVPath() + File.separator + this.getProfile() + File.separator + "emulator-resources" + File.separator + "plugins";
    }
}

