/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.category;

import java.util.ArrayList;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.tizen.ecp.category.ECPListCtrl;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.FontResources;

public class ECPListItem
extends Canvas {
    private ECPListCtrl m_ctrl;
    private static int INDENT_SIZE = 10;
    private int m_index = 0;
    private int m_mouse = 0;
    private boolean m_hit = false;
    private boolean m_isSelected = false;
    private boolean m_isExpanded = true;
    public String m_text;
    public String m_displaytext;
    private int m_textPositionX;
    private int m_textPositionY;
    private int m_iconPositionY;
    private static Color m_colorTextNormal;
    private Image m_icon;
    private Point m_lt;
    private int m_height;
    private ItemStatus m_itemstatus;
    private ECPListItem m__parent;
    private ECPListItem m_prev;
    private ECPListItem m_next;
    private ArrayList<ECPListItem> m_childlist = new ArrayList();
    private static Font font;
    protected PaintListener m_paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            ECPListItem.this.OnPaint(e);
        }
    };
    protected KeyAdapter m_keyAdaptor = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            ECPListItem.this.m_mouse = 0;
            ECPListItem item = (ECPListItem)e.widget;
            if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                ECPListItem.this.notifyListeners(13, new Event());
                ECPListItem.this.m_ctrl.setSelect(item.getText());
            } else if (e.keyCode == 0x1000004) {
                if (item.hasChild() && !item.isExpanded()) {
                    item.m_isExpanded = true;
                    item.redraw();
                    item.Expand();
                    ECPListItem.this.m_ctrl.getComposite().layout();
                }
            } else if (e.keyCode == 0x1000003) {
                if (item.hasChild() && item.isExpanded()) {
                    item.m_isExpanded = false;
                    item.redraw();
                    item.Collapse();
                    ECPListItem.this.m_ctrl.getComposite().layout();
                }
            } else if (e.keyCode == 0x1000001) {
                if (ECPListItem.this.m_prev != null) {
                    if (ECPListItem.this.m_prev.hasChild() && ECPListItem.this.m_prev.m_isExpanded) {
                        ECPListItem.this.m_ctrl.setSelect(((ECPListItem)((Object)ECPListItem.this.m_prev.m_childlist.get(ECPListItem.this.m_prev.m_childlist.size() - 1))).getText());
                    } else {
                        ECPListItem.this.m_ctrl.setSelect(ECPListItem.this.m_prev.getText());
                    }
                } else if (ECPListItem.this.m__parent != null) {
                    ECPListItem.this.m_ctrl.setSelect(ECPListItem.this.m__parent.getText());
                } else if (ECPListItem.this.m__parent == null && ECPListItem.this.m_ctrl.getRootIndex(item) > 0) {
                    int index = ECPListItem.this.m_ctrl.getRootIndex(item) - 1;
                    ECPListItem rootItem = ECPListItem.this.m_ctrl.getRootItem().get(index);
                    if (rootItem.hasChild() && rootItem.m_isExpanded) {
                        ECPListItem.this.m_ctrl.setSelect(((ECPListItem)((Object)rootItem.m_childlist.get(rootItem.m_childlist.size() - 1))).getText());
                    } else {
                        ECPListItem.this.m_ctrl.setSelect(rootItem.getText());
                    }
                }
            } else if (e.keyCode == 0x1000002) {
                if (ECPListItem.this.hasChild() && ECPListItem.this.m_isExpanded) {
                    ECPListItem.this.m_ctrl.setSelect(((ECPListItem)((Object)ECPListItem.this.m_childlist.get(0))).getText());
                } else if (ECPListItem.this.m_next != null) {
                    ECPListItem.this.m_ctrl.setSelect(ECPListItem.this.m_next.getText());
                } else if (ECPListItem.this.m__parent != null && ECPListItem.this.m__parent.m_next != null) {
                    ECPListItem.this.m_ctrl.setSelect(ECPListItem.this.m__parent.m_next.getText());
                } else if (ECPListItem.this.m__parent != null && ECPListItem.this.m__parent.isRoot() && ECPListItem.this.m_ctrl.getRootIndex(ECPListItem.this.m__parent) < ECPListItem.this.m_ctrl.getRootItem().size() - 1) {
                    int index = ECPListItem.this.m_ctrl.getRootIndex(ECPListItem.this.m__parent) + 1;
                    ECPListItem rootItem = ECPListItem.this.m_ctrl.getRootItem().get(index);
                    ECPListItem.this.m_ctrl.setSelect(rootItem.getText());
                } else if (ECPListItem.this.m__parent != null && ECPListItem.this.m__parent.m__parent != null && ECPListItem.this.m__parent.m__parent.isRoot() && ECPListItem.this.m_ctrl.getRootIndex(ECPListItem.this.m__parent.m__parent) < ECPListItem.this.m_ctrl.getRootItem().size() - 1) {
                    int index = ECPListItem.this.m_ctrl.getRootIndex(ECPListItem.this.m__parent.m__parent) + 1;
                    ECPListItem rootItem = ECPListItem.this.m_ctrl.getRootItem().get(index);
                    ECPListItem.this.m_ctrl.setSelect(rootItem.getText());
                }
            }
        }
    };
    protected TraverseListener m_traverse = new TraverseListener(){

        public void keyTraversed(TraverseEvent event) {
            switch (event.detail) {
                case 8: 
                case 16: {
                    event.doit = true;
                    ECPListItem.this.redraw();
                }
            }
        }
    };
    protected FocusAdapter m_focusAdapter = new FocusAdapter(){

        public void focusGained(FocusEvent e) {
            ECPListItem.this.redraw();
        }

        public void focusLost(FocusEvent e) {
            ECPListItem.this.redraw();
        }
    };
    protected MouseMoveListener m_mousemoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            if (!ECPListItem.this.m_hit) {
                return;
            }
            ECPListItem.this.m_mouse = 2;
            if (e.x < 0 || e.y < 0 || e.x > ECPListItem.this.getBounds().width || e.y > ECPListItem.this.getBounds().height) {
                ECPListItem.this.m_mouse = 0;
            }
            ECPListItem.this.redraw();
        }
    };
    protected MouseTrackAdapter m_mousetrackAdapter = new MouseTrackAdapter(){

        public void mouseEnter(MouseEvent e) {
            ECPListItem.this.m_mouse = 1;
            ECPListItem.this.redraw();
        }

        public void mouseExit(MouseEvent e) {
            ECPListItem.this.m_mouse = 0;
            ECPListItem.this.redraw();
        }
    };
    private MouseAdapter m_mouseAdapter = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            ECPListItem.this.m_hit = true;
            ECPListItem.this.m_mouse = 2;
            ECPListItem.this.redraw();
        }

        public void mouseUp(MouseEvent e) {
            ECPListItem.this.OnMouseUp(e);
        }
    };

    public void setIndex(int index) {
        this.m_index = index;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setItemStatus(ItemStatus status) {
        this.m_itemstatus = status;
    }

    public ItemStatus getItemStatus() {
        return this.m_itemstatus;
    }

    public void setNext(ECPListItem next) {
        this.m_next = next;
    }

    public void setPrev(ECPListItem prev) {
        this.m_prev = prev;
    }

    public void setsParent(ECPListItem parent) {
        this.m__parent = parent;
    }

    public ECPListItem getPrev() {
        return this.m_prev;
    }

    public ECPListItem getNext() {
        return this.m_next;
    }

    public ECPListItem getsParent() {
        return this.m__parent;
    }

    public void setIndent(int indent) {
        this.m_textPositionX = indent;
    }

    public void setIcon(Image icon) {
        this.m_icon = icon;
    }

    public void insertChild(ECPListItem newItem) {
        if (this.hasChild()) {
            ECPListItem last = this.m_childlist.get(this.m_childlist.size() - 1);
            last.m_next = newItem;
            newItem.m_prev = last;
        }
        newItem.m__parent = this;
        newItem.setIndent(this.m_textPositionX + INDENT_SIZE);
        this.m_childlist.add(newItem);
    }

    public void deleteChild(ECPListItem delItem) {
        this.m_childlist.remove((Object)delItem);
    }

    public boolean hasChild() {
        return this.m_childlist.size() > 0;
    }

    public boolean isExpanded() {
        return this.m_isExpanded;
    }

    public void setPos(int left, int top) {
        this.m_lt.x = left;
        this.m_lt.y = top;
    }

    public void setHeight(int height) {
        this.m_height = height;
    }

    public Point getBottomPos() {
        Point bottom_pos = new Point(0, 0);
        if (this.hasChild()) {
            ECPListItem lastChild = this.m_childlist.get(this.m_childlist.size() - 1);
            return lastChild.getBottomPos();
        }
        bottom_pos.x = this.m_lt.x;
        bottom_pos.y = this.m_lt.y + this.m_height;
        return bottom_pos;
    }

    public ECPListItem(ECPListCtrl ctrl, String text, int style) {
        super(ctrl.getComposite(), 0x20000000 | style);
        this.m_text = text;
        this.m_ctrl = ctrl;
        this.m_lt = new Point(0, 0);
        this.m_itemstatus = ItemStatus.IT_NORMAL;
        m_colorTextNormal = ColorResources.CATEGORY_TEXT_NML.getColor();
        font = FontResources.FONT_10.getFont();
        this.m_text = null;
        this.m_textPositionX = 17;
        this.m_textPositionY = 4;
        this.m_iconPositionY = 3;
        this.setFont(font);
        this.setForeground(m_colorTextNormal);
        this.addPaintListener(this.m_paintListener);
        this.addMouseMoveListener(this.m_mousemoveListener);
        this.addMouseTrackListener((MouseTrackListener)this.m_mousetrackAdapter);
        this.addMouseListener((MouseListener)this.m_mouseAdapter);
        this.addKeyListener((KeyListener)this.m_keyAdaptor);
        this.addFocusListener((FocusListener)this.m_focusAdapter);
        this.addTraverseListener(this.m_traverse);
    }

    public boolean isRoot() {
        return this.m__parent == null;
    }

    public void OnPaint(PaintEvent e) {
        String text = this.m_text;
        Rectangle rect = ((Canvas)e.widget).getClientArea();
        if (this.m_displaytext != null) {
            text = this.m_displaytext;
        }
        switch (this.m_mouse) {
            case 2: 
            case 3: {
                if (this.isRoot()) {
                    e.gc.setForeground(ColorResources.WHITE.getColor());
                    e.gc.setBackground(ColorResources.CATEGORY_LIST_ROOT_SEL.getColor());
                } else {
                    e.gc.setForeground(ColorResources.BLACK.getColor());
                    e.gc.setBackground(ColorResources.CATEGORY_LIST_SEL.getColor());
                }
                e.gc.fillRectangle(rect);
                if (this.m_icon == null) {
                    e.gc.drawText(text, this.m_textPositionX, this.m_textPositionY, true);
                    break;
                }
                e.gc.drawImage(this.m_icon, this.m_textPositionX - 7, this.m_iconPositionY);
                e.gc.drawText(text, this.m_textPositionX + 21, this.m_textPositionY, true);
                break;
            }
            default: {
                if (this.isRoot()) {
                    e.gc.setForeground(ColorResources.WHITE.getColor());
                    e.gc.setBackground(ColorResources.CATEGORY_LIST_ROOT.getColor());
                } else if (this.m_isSelected) {
                    e.gc.setForeground(ColorResources.BLACK.getColor());
                    e.gc.setBackground(ColorResources.CATEGORY_LIST_SEL.getColor());
                } else {
                    e.gc.setForeground(ColorResources.WHITE.getColor());
                    e.gc.setBackground(ColorResources.CATEGORY_LIST_NML.getColor());
                }
                e.gc.fillRectangle(rect);
                if (this.m_icon == null) {
                    e.gc.drawText(text, this.m_textPositionX, this.m_textPositionY, true);
                    break;
                }
                e.gc.drawImage(this.m_icon, this.m_textPositionX - 7, this.m_iconPositionY);
                e.gc.drawText(text, this.m_textPositionX + 21, this.m_textPositionY, true);
            }
        }
        if (this.hasChild()) {
            if (!this.isRoot()) {
                e.gc.drawImage(this.m_isExpanded ? this.m_ctrl.m_rootImgArrowOpened : this.m_ctrl.m_rootImgArrowClosed, this.m_textPositionX - (this.isRoot() ? INDENT_SIZE + 1 : INDENT_SIZE + (this.m_icon == null ? 2 : 9)), 9);
            } else {
                e.gc.drawImage(this.m_isExpanded ? this.m_ctrl.m_imgArrowOpened : this.m_ctrl.m_imgArrowClosed, this.m_textPositionX - (this.isRoot() ? INDENT_SIZE + 1 : INDENT_SIZE + (this.m_icon == null ? 2 : 9)), 9);
            }
        }
        if (this.isFocusControl()) {
            e.gc.drawFocus(1, 1, rect.width - 2, rect.height - 2);
        }
    }

    public boolean setFocus() {
        this.forceFocus();
        return true;
    }

    private void OnMouseUp(MouseEvent e) {
        this.m_hit = false;
        if (e.x < 0 || e.y < 0 || e.x > this.getBounds().width || e.y > this.getBounds().height) {
            this.m_mouse = 0;
            this.m_isSelected = false;
        } else {
            this.m_isSelected = true;
            this.m_isExpanded = !this.m_isExpanded;
            this.m_mouse = 3;
            this.notifyListeners(13, new Event());
            this.m_ctrl.OnItemStateChanged(this);
        }
        this.redraw();
    }

    public void setText(String textValue) {
        if (textValue == null || textValue.isEmpty()) {
            return;
        }
        GC gc = new GC((Drawable)this);
        gc.drawString(textValue, 10, 10);
        gc.dispose();
        this.m_text = textValue;
    }

    public String getText() {
        return this.m_text;
    }

    public void setDisplayText(String text) {
        this.m_displaytext = text;
    }

    public String getDisplayText() {
        return this.m_displaytext;
    }

    public boolean isSelected() {
        return this.m_isSelected;
    }

    public void setSelection(boolean select) {
        this.m_isSelected = select;
        this.redraw();
    }

    public void setImages(Image normal, Image selected) {
        this.redraw();
    }

    public ECPListItem Expand() {
        ECPListItem bottom = this;
        if (this.m_childlist.size() == 0) {
            return bottom;
        }
        if (this.m_isExpanded) {
            for (int i = 0; i < this.m_childlist.size(); ++i) {
                ECPListItem child = this.m_childlist.get(i);
                FormData data = new FormData();
                data.top = new FormAttachment((Control)bottom, 1);
                data.left = new FormAttachment(0, 0);
                data.right = new FormAttachment(100, 0);
                data.height = 24;
                child.setLayoutData(data);
                bottom = this.hasChild() ? child.Expand() : child;
            }
        } else {
            bottom = this.m_childlist.get(this.m_childlist.size() - 1);
        }
        return bottom;
    }

    public ECPListItem Collapse() {
        ECPListItem bottom = this;
        for (int i = 0; i < this.m_childlist.size(); ++i) {
            ECPListItem child = this.m_childlist.get(i);
            FormData data = new FormData();
            data.top = new FormAttachment((Control)bottom, 0);
            data.right = new FormAttachment(100, 0);
            data.height = 0;
            child.setLayoutData(data);
            bottom = this.hasChild() ? child.Collapse() : child;
        }
        return bottom;
    }

    public static enum ItemStatus {
        IT_NORMAL,
        IT_OVER,
        IT_SELECTED,
        IT_EXPENDED;

    }
}

