/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.tizen.ecp.DynamicLoader;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.device.DeviceTreeDisplay;
import org.tizen.ecp.device.HDSDisplay;
import org.tizen.ecp.device.NetworkDisplay;
import org.tizen.ecp.device.UninstallerDisplay;
import org.tizen.ecp.ecpinfo.xml.ListItemType;
import org.tizen.ecp.info.EIInformation;
import org.tizen.ecp.timer.MessageTimer;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.BaseView;

public class ViewMgr {
    private static ViewMgr instance = new ViewMgr();
    private static Logger logger = LogUtil.getECPLogger(ViewMgr.class).getLogger();
    private HashMap<String, BaseView> m_viewmap = new HashMap();
    private BaseView m_activeView;

    public static ViewMgr getInstance() {
        return instance;
    }

    public void initialize() {
        List<String> appList;
        List<String> monList = ECPInfo.getInstance().getMonitorInfo();
        if (monList != null && monList.size() > 0) {
            for (String monitor : monList) {
                if (monitor.equals("Device Tree")) {
                    this.m_viewmap.put("Device Tree", new DeviceTreeDisplay());
                    continue;
                }
                if (monitor.equals("Network")) {
                    this.m_viewmap.put("Network", new NetworkDisplay());
                    continue;
                }
                if (monitor.equals("HDS")) {
                    this.m_viewmap.put("Host Directory Sharing", new HDSDisplay());
                    continue;
                }
                logger.warning("wrong monitor item entered : " + monitor);
            }
        }
        if ((appList = ECPInfo.getInstance().getAppManagerInfo()) != null && appList.size() > 0) {
            for (String app : appList) {
                if (app.equals("Device Tree")) {
                    this.m_viewmap.put("Device Tree", new DeviceTreeDisplay());
                    continue;
                }
                if (app.equals("Uninstaller")) {
                    this.m_viewmap.put("Uninstaller", new UninstallerDisplay());
                    continue;
                }
                logger.warning("wrong app item entered : " + app);
            }
        }
        this.m_viewmap.put("Event Injector", new EIInformation());
    }

    public boolean loadView(String key) {
        String jarPath = ECPInfo.getInstance().getJarPath();
        try {
            List<ListItemType> list = ECPInfo.getInstance().getListInfo();
            if (list == null) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                BaseView view;
                ListItemType type = list.get(i);
                if ("null".equals(type.getViewClass()) || !type.getDevice().equals(key)) continue;
                String menuName = type.getDevice();
                Class<?> dp = DynamicLoader.dynamicLoadClass(jarPath, type.getViewClass());
                if (dp == null || (view = (BaseView)dp.newInstance()) == null) continue;
                this.m_viewmap.put(menuName, view);
                return true;
            }
        }
        catch (IllegalAccessException e) {
            logger.severe("IllegalAccessException: " + e.getMessage());
        }
        catch (InstantiationException e) {
            logger.severe("InstantiationException" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            logger.severe("ClassNotFoundException" + e.getMessage());
        }
        return false;
    }

    public BaseView findView(String key) {
        return this.m_viewmap.get(key);
    }

    public void setActivate(String key) {
        BaseView view = this.findView(key);
        if (view == null) {
            if (this.loadView(key)) {
                view = this.findView(key);
            } else {
                logger.info(key + " - view does not exist");
                System.out.println(key + " - view does not exist");
                return;
            }
        }
        if (this.m_activeView == view) {
            logger.info(key + " - view is already activated");
            return;
        }
        if (!view.isValid()) {
            view.Create();
            view.OnTimerMessageExpired();
        }
        if (this.m_activeView != null) {
            this.m_activeView.OnDeactivate();
        }
        view.OnActivate();
        view.showComposite();
        this.m_activeView = view;
    }

    public String getActivate() {
        if (this.m_activeView != null) {
            for (String key : this.m_viewmap.keySet()) {
                if (!this.m_viewmap.get(key).equals(this.m_activeView)) continue;
                return key;
            }
        }
        return null;
    }

    public void MessageTimerActivate() {
        if (this.m_activeView != null) {
            logger.info("MessageTimerActivate");
            this.m_activeView.OnTimerMessageExpired();
            MessageTimer.getInstance().StopTimer();
        }
    }

    public void close() {
        for (BaseView view : this.m_viewmap.values()) {
            view.Close();
        }
    }
}

