/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.ImageResources;
import org.tizen.ecp.timer.MessageTimer;
import org.tizen.ecp.utils.SwtUtil;

public class ECPButton
extends Canvas {
    protected int STATE_NORMAL = 0;
    protected int STATE_SELECTED = 1;
    protected int STATE_HOVER = 2;
    protected int STATE_SELECTED_HOVER = 3;
    protected int STATE_PUSH = 4;
    protected int STATE_DISABLE = 5;
    private Image img_nml;
    private Image img_hover;
    private Image img_pushed;
    private Image img_disable;
    private Image img_selected;
    private Image img_selected_hover;
    private Color color_nml;
    private Color color_hover;
    private Color color_pushed;
    private Color color_disable;
    private Color color_selected;
    private Color color_selected_hover;
    private String text = "";
    private int state = this.STATE_NORMAL;
    private boolean selected = false;
    private Composite parent;
    private int style = 0;
    private boolean defaultPush = true;
    private int RADIO_IMAGE_SIZE = 21;
    private int CHECK_IMAGE_SIZE = 19;
    private Color bgColor = null;
    private Color fgColor = null;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent arg0) {
            SwtUtil.tryDispose(ECPButton.this.img_nml, ECPButton.this.img_pushed, ECPButton.this.img_hover, ECPButton.this.img_disable, ECPButton.this.img_selected, ECPButton.this.img_selected_hover);
            SwtUtil.tryDispose(ECPButton.this.bgColor, ECPButton.this.fgColor, ECPButton.this.color_nml, ECPButton.this.color_hover, ECPButton.this.color_selected, ECPButton.this.color_pushed, ECPButton.this.color_disable, ECPButton.this.color_selected_hover);
        }
    };
    private PaintListener radioPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Canvas canvas = (Canvas)e.widget;
            Rectangle rect = canvas.getClientArea();
            if (null != ECPButton.this.bgColor) {
                e.gc.setBackground(ECPButton.this.bgColor);
                e.gc.fillRectangle(rect);
            }
            Color color = ECPButton.this.getStateColor(ECPButton.this.state);
            int x = rect.x;
            int y = rect.y;
            if (ECPButton.this.defaultPush && ECPButton.this.checkStyle(ECPButton.this.style, 8)) {
                ECPButton.this.drawPushImage(e.gc, ECPButton.this.state, rect.width, rect.height);
            } else {
                if (ECPButton.this.checkStyle(ECPButton.this.style, 16)) {
                    y += (rect.height - ECPButton.this.RADIO_IMAGE_SIZE) / 2;
                } else if (ECPButton.this.checkStyle(ECPButton.this.style, 32)) {
                    y += (rect.height - ECPButton.this.CHECK_IMAGE_SIZE) / 2;
                }
                ECPButton.this.drawButtonImage(e.gc, ECPButton.this.state, x, y);
            }
            int fontHeight = e.gc.getFontMetrics().getHeight();
            y += (rect.height - fontHeight) / 2 - 1;
            if (ECPButton.this.checkStyle(ECPButton.this.style, 16)) {
                x += ECPButton.this.RADIO_IMAGE_SIZE + 6;
            } else if (ECPButton.this.checkStyle(ECPButton.this.style, 32)) {
                x += ECPButton.this.CHECK_IMAGE_SIZE + 6;
            } else {
                Point extent = e.gc.stringExtent(ECPButton.this.text);
                x += rect.x + (rect.width - extent.x) / 2;
                ++y;
            }
            if (null != ECPButton.this.fgColor) {
                e.gc.setForeground(ECPButton.this.fgColor);
            } else if (null != color) {
                e.gc.setForeground(color);
            }
            if (null != ECPButton.this.text) {
                e.gc.drawText(ECPButton.this.text, x, y, true);
            }
        }
    };
    protected Listener mouseListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.type == 3) {
                MessageTimer.getInstance().setMouseDown(true);
                ECPButton btn = (ECPButton)event.widget;
                btn.setFocus();
                if (ECPButton.this.state == ECPButton.this.STATE_HOVER) {
                    ECPButton.this.state = ECPButton.this.STATE_PUSH;
                    ECPButton.this.redraw();
                }
            } else if (event.type == 4) {
                MessageTimer.getInstance().setMouseDown(false);
                ECPButton button = (ECPButton)event.widget;
                Rectangle rect = button.getClientArea();
                if (rect.contains(event.x, event.y)) {
                    if (ECPButton.this.checkStyle(ECPButton.this.style, 16)) {
                        ECPButton.this.selectRadio();
                    } else if (ECPButton.this.checkStyle(ECPButton.this.style, 8)) {
                        if (ECPButton.this.state == ECPButton.this.STATE_PUSH) {
                            ECPButton.this.state = ECPButton.this.STATE_HOVER;
                            ECPButton.this.redraw();
                        }
                    } else if (ECPButton.this.checkStyle(ECPButton.this.style, 2) || ECPButton.this.checkStyle(ECPButton.this.style, 32)) {
                        if (ECPButton.this.getSelection()) {
                            ECPButton.this.setSelection(false);
                        } else {
                            ECPButton.this.setSelection(true);
                        }
                        ECPButton.this.redraw();
                    }
                    ECPButton.this.notifyListeners(13, new Event());
                    ECPButton.this.notifyListeners(14, new Event());
                }
            } else if (event.type == 6) {
                if (ECPButton.this.state != ECPButton.this.STATE_HOVER && ECPButton.this.state != ECPButton.this.STATE_SELECTED_HOVER) {
                    if (ECPButton.this.selected) {
                        ECPButton.this.state = ECPButton.this.STATE_SELECTED_HOVER;
                    } else {
                        ECPButton.this.state = ECPButton.this.STATE_HOVER;
                    }
                    ECPButton.this.redraw();
                }
            } else if (event.type == 7 && (ECPButton.this.state == ECPButton.this.STATE_HOVER || ECPButton.this.state == ECPButton.this.STATE_SELECTED_HOVER || ECPButton.this.state == ECPButton.this.STATE_PUSH)) {
                if (ECPButton.this.selected) {
                    ECPButton.this.state = ECPButton.this.STATE_SELECTED;
                } else {
                    ECPButton.this.state = ECPButton.this.STATE_NORMAL;
                }
                ECPButton.this.redraw();
            }
        }
    };

    public ECPButton(Composite parent, int style) {
        super(parent, 0x20000000 | style);
        this.parent = parent;
        if (style == 0) {
            style = 8;
        }
        this.style = style;
        this.addPaintListener(this.radioPaintListener);
        this.addListener(3, this.mouseListener);
        this.addListener(4, this.mouseListener);
        this.addListener(6, this.mouseListener);
        this.addListener(7, this.mouseListener);
        this.addDisposeListener(this.disposeListener);
        if (this.checkStyle(style, 16)) {
            this.setDefaultRadioImage();
        } else if (this.checkStyle(style, 32)) {
            this.setDefaultCheckImage();
        }
    }

    private boolean checkStyle(int style, int bit) {
        return (style & bit) != 0;
    }

    public void setForeground(Color color) {
        this.fgColor = color;
        super.setForeground(color);
    }

    public void setBackground(Color color) {
        this.bgColor = color;
        super.setBackground(color);
    }

    public void setText(String text) {
        this.text = text;
        this.redraw();
    }

    public String getText() {
        return this.text;
    }

    public Image getImage() {
        return this.img_nml;
    }

    public void setImage(Image image) {
        this.img_nml = image;
        if (this.checkStyle(this.style, 8)) {
            this.defaultPush = false;
        }
        this.redraw();
    }

    public void setDefaultRadioImage() {
        this.img_pushed = this.img_nml = ImageResources.RADIO_OFF.getImage();
        this.img_disable = this.img_nml;
        this.img_hover = this.img_nml;
        this.img_selected_hover = this.img_selected = ImageResources.RADIO_ON.getImage();
    }

    public void setDefaultCheckImage() {
        this.img_pushed = this.img_nml = ImageResources.CHECK_OFF.getImage();
        this.img_disable = this.img_nml;
        this.img_hover = this.img_nml;
        this.img_selected_hover = this.img_selected = ImageResources.CHECK_ON.getImage();
    }

    public void drawPushImage(GC gc, int state, int width, int height) {
        Image right;
        Image middle;
        Image left;
        if (state == this.STATE_HOVER) {
            left = ImageResources.BUTTON_HOVER_LEFT.getImage();
            middle = ImageResources.BUTTON_HOVER_MID.getImage();
            right = ImageResources.BUTTON_HOVER_RIGHT.getImage();
        } else if (state == this.STATE_PUSH) {
            left = ImageResources.BUTTON_PUSH_LEFT.getImage();
            middle = ImageResources.BUTTON_PUSH_MID.getImage();
            right = ImageResources.BUTTON_PUSH_RIGHT.getImage();
        } else {
            left = ImageResources.BUTTON_NML_LEFT.getImage();
            middle = ImageResources.BUTTON_NML_MID.getImage();
            right = ImageResources.BUTTON_NML_RIGHT.getImage();
        }
        Rectangle rectL = left.getBounds();
        Rectangle rectM = middle.getBounds();
        Rectangle rectR = right.getBounds();
        int y = rectL.y + (height - rectL.height) / 2;
        gc.drawImage(left, rectL.x, y);
        gc.drawImage(middle, rectM.x, rectM.y, rectM.width, rectM.height, rectL.x + rectL.width, y, width - (rectL.width + rectR.width), rectM.height);
        gc.drawImage(right, width - rectR.width, y);
    }

    public void drawButtonImage(GC gc, int state, int width, int height) {
        Image img_fg = this.getStateImage(state);
        if (null == img_fg) {
            return;
        }
        gc.drawImage(img_fg, width, height);
    }

    public void setImages(Image normal, Image hover, Image selected, Image pushed, Image disable, Image selected_hover) {
        this.img_nml = normal;
        this.img_hover = hover;
        this.img_selected = selected;
        this.img_pushed = pushed;
        this.img_disable = disable;
        this.img_selected_hover = selected_hover;
        if (this.checkStyle(this.style, 8)) {
            this.defaultPush = false;
        }
        this.redraw();
    }

    public void setForeground(Color normal, Color hover, Color selected, Color pushed, Color disable, Color selected_hover) {
        this.color_nml = normal;
        this.color_hover = hover;
        this.color_selected = selected;
        this.color_pushed = pushed;
        this.color_disable = disable;
        this.color_selected_hover = selected_hover;
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = 0;
        int height = 0;
        if ((this.checkStyle(this.style, 16) || this.checkStyle(this.style, 32)) && this.img_nml != null) {
            Rectangle bounds = this.img_nml.getBounds();
            width = bounds.width + 14;
            height = bounds.height;
        }
        if (this.text != null) {
            GC gc = new GC((Drawable)this);
            Point extent = gc.stringExtent(this.text);
            gc.dispose();
            width += extent.x;
            height = Math.max(height, extent.y);
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        if (this.checkStyle(this.style, 8) && this.defaultPush) {
            if (width < 13) {
                width = 13;
            }
            if (height < 22) {
                height = 22;
            }
        }
        return new Point(width, height);
    }

    private Image getStateImage(int state) {
        Image img_fg = state == this.STATE_SELECTED ? this.img_selected : (state == this.STATE_HOVER ? this.img_hover : (state == this.STATE_SELECTED_HOVER ? this.img_selected_hover : (state == this.STATE_PUSH ? this.img_pushed : (state == this.STATE_DISABLE ? this.img_disable : this.img_nml))));
        return img_fg;
    }

    private Color getStateColor(int state) {
        Color color = state == this.STATE_SELECTED ? this.color_selected : (state == this.STATE_HOVER ? this.color_hover : (state == this.STATE_SELECTED_HOVER ? this.color_selected_hover : (state == this.STATE_PUSH ? this.color_pushed : (state == this.STATE_DISABLE ? this.color_disable : this.color_nml))));
        return color;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addListener(13, (Listener)new TypedListener((SWTEventListener)listener));
        this.addListener(14, (Listener)new TypedListener((SWTEventListener)listener));
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void setSelection(boolean selected) {
        if (selected) {
            this.state = this.STATE_SELECTED;
            this.selected = true;
        } else {
            this.state = this.STATE_NORMAL;
            this.selected = false;
        }
        this.redraw();
    }

    public boolean getSelection() {
        return this.selected;
    }

    public void selectRadio() {
        Control[] children = this.parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (!(child instanceof ECPButton) || child == this) continue;
            ((ECPButton)child).setSelection(false);
        }
        this.setSelection(true);
    }

    public void setEnabled(boolean enable) {
        this.fgColor = !enable ? ColorResources.BUTTON_DISABLE.getColor() : null;
        this.redraw();
        super.setEnabled(enable);
    }
}

