/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.widgets;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.tizen.ecp.resources.ImageResources;
import org.tizen.ecp.timer.MessageTimer;
import org.tizen.ecp.utils.SwtUtil;

public class ECPSlider
extends Canvas {
    private int style;
    private Color bgColor = null;
    private int ARROW_SIZE = 17;
    private int THUMB_WIDTH = 24;
    private int THUMB_HEIGHT = 11;
    private int SLIDER_HEIGHT = 21;
    private int selection = 0;
    private int increment = 1;
    private int pageIncrement = 1;
    private int maxValue = 1;
    private int minValue = 0;
    private Image leftArrow = null;
    private int leftArrowStatus = 0;
    private Image rightArrow = null;
    private int rightArrowStatus = 0;
    private Image[] leftArrows = null;
    private Image[] rightArrows = null;
    private Image leftBack = null;
    private Image middleBack = null;
    private Image rightBack = null;
    private Image bar = null;
    private Rectangle sliderRect = new Rectangle(0, 0, 0, 0);
    private Rectangle thumbRect = new Rectangle(0, 0, 0, 0);
    private Rectangle areaRect = new Rectangle(0, 0, 0, 0);
    private Rectangle leftRect = new Rectangle(0, 0, 0, 0);
    private Rectangle rightRect = new Rectangle(0, 0, 0, 0);
    private boolean mouseDown = false;
    private DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent arg0) {
            if (null != ECPSlider.this.leftArrows) {
                for (Image arrow : ECPSlider.this.leftArrows) {
                    arrow.dispose();
                }
            }
            if (null != ECPSlider.this.rightArrows) {
                for (Image arrow : ECPSlider.this.rightArrows) {
                    arrow.dispose();
                }
            }
            SwtUtil.tryDispose(ECPSlider.this.leftBack, ECPSlider.this.middleBack, ECPSlider.this.rightBack, ECPSlider.this.bar);
        }
    };
    private PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            int width = 0;
            if ((ECPSlider.this.style & 0x200) == 0) {
                Rectangle rect = ((Canvas)e.widget).getClientArea();
                if (null != ECPSlider.this.bgColor) {
                    e.gc.setBackground(ECPSlider.this.bgColor);
                    e.gc.fillRectangle(rect);
                }
                int x = rect.x;
                Rectangle rectL = ECPSlider.this.leftBack.getBounds();
                Rectangle rectM = ECPSlider.this.middleBack.getBounds();
                Rectangle rectR = ECPSlider.this.rightBack.getBounds();
                int y = ((ECPSlider)ECPSlider.this).sliderRect.y + (((ECPSlider)ECPSlider.this).sliderRect.height - ECPSlider.this.SLIDER_HEIGHT) / 2;
                e.gc.drawImage(ECPSlider.this.leftBack, x, y);
                width = rect.x + rect.width - (rectL.width + rectR.width);
                e.gc.drawImage(ECPSlider.this.middleBack, rectM.x, rectM.y, rectM.width, rectM.height, x += rectL.width, y, width, rectM.height);
                e.gc.drawImage(ECPSlider.this.rightBack, x += width, y);
                e.gc.drawImage(ECPSlider.this.leftArrow, rect.x + 8, y + 6);
                e.gc.drawImage(ECPSlider.this.rightArrow, rect.x + rect.width - 11, y + 6);
                e.gc.drawImage(ECPSlider.this.bar, ((ECPSlider)ECPSlider.this).thumbRect.x, ((ECPSlider)ECPSlider.this).thumbRect.y);
            }
        }
    };
    private Listener mouseListener = new Listener(){

        public void handleEvent(Event event) {
            Point point = new Point(event.x, event.y);
            if (event.type == 3) {
                if (ECPSlider.this.thumbRect.contains(point)) {
                    ECPSlider.this.mouseDown = true;
                    MessageTimer.getInstance().setMouseDown(ECPSlider.this.mouseDown);
                } else if (ECPSlider.this.leftRect.contains(point)) {
                    ECPSlider.this.arrowStatus(true, 2, ECPSlider.this.leftArrowStatus != 2);
                } else if (ECPSlider.this.rightRect.contains(point)) {
                    ECPSlider.this.arrowStatus(false, 2, ECPSlider.this.leftArrowStatus != 2);
                } else if (ECPSlider.this.areaRect.contains(point)) {
                    int thumbX = ((ECPSlider)ECPSlider.this).thumbRect.x + ECPSlider.this.THUMB_WIDTH / 2;
                    if (event.x < thumbX) {
                        ECPSlider.this.pageHandler(false);
                    } else {
                        ECPSlider.this.pageHandler(true);
                    }
                    ECPSlider.this.notifyListeners(13, new Event());
                    ECPSlider.this.redraw();
                }
            }
            if (event.type == 4) {
                if (ECPSlider.this.leftRect.contains(point)) {
                    ECPSlider.this.incrementHandler(false);
                    ECPSlider.this.redraw();
                    ECPSlider.this.arrowStatus(true, 1, ECPSlider.this.leftArrowStatus == 2);
                    ECPSlider.this.notifyListeners(13, new Event());
                } else if (ECPSlider.this.rightRect.contains(point)) {
                    ECPSlider.this.incrementHandler(true);
                    ECPSlider.this.redraw();
                    ECPSlider.this.arrowStatus(false, 1, ECPSlider.this.rightArrowStatus == 2);
                    ECPSlider.this.notifyListeners(13, new Event());
                } else {
                    if (ECPSlider.this.mouseDown) {
                        ECPSlider.this.setThumbRect(point);
                        ECPSlider.this.redraw();
                        ECPSlider.this.notifyListeners(13, new Event());
                    }
                    ECPSlider.this.arrowStatus(true, 0, ECPSlider.this.leftArrowStatus == 2);
                    ECPSlider.this.arrowStatus(false, 0, ECPSlider.this.rightArrowStatus == 2);
                }
                ECPSlider.this.mouseDown = false;
                MessageTimer.getInstance().setMouseDown(ECPSlider.this.mouseDown);
            }
            if (event.type == 5) {
                if (ECPSlider.this.mouseDown) {
                    ECPSlider.this.setThumbRect(point);
                    ECPSlider.this.redraw();
                } else if (ECPSlider.this.leftRect.contains(point)) {
                    ECPSlider.this.arrowStatus(true, 1, ECPSlider.this.leftArrowStatus == 0);
                } else if (ECPSlider.this.rightRect.contains(point)) {
                    ECPSlider.this.arrowStatus(false, 1, ECPSlider.this.rightArrowStatus == 0);
                } else {
                    ECPSlider.this.arrowStatus(true, 0, ECPSlider.this.leftArrowStatus == 1);
                    ECPSlider.this.arrowStatus(false, 0, ECPSlider.this.rightArrowStatus == 1);
                }
            }
        }
    };
    private ControlAdapter controlListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            Canvas canvas = (Canvas)e.widget;
            ECPSlider.this.sliderRect = canvas.getClientArea();
            int y = ((ECPSlider)ECPSlider.this).sliderRect.y + (((ECPSlider)ECPSlider.this).sliderRect.height - ECPSlider.this.SLIDER_HEIGHT) / 2;
            ((ECPSlider)ECPSlider.this).leftRect.x = 0;
            ((ECPSlider)ECPSlider.this).leftRect.y = y;
            ((ECPSlider)ECPSlider.this).leftRect.width = ECPSlider.this.ARROW_SIZE;
            ((ECPSlider)ECPSlider.this).leftRect.height = ECPSlider.this.ARROW_SIZE;
            ((ECPSlider)ECPSlider.this).rightRect.x = ((ECPSlider)ECPSlider.this).sliderRect.x + ((ECPSlider)ECPSlider.this).sliderRect.width - ECPSlider.this.ARROW_SIZE;
            ((ECPSlider)ECPSlider.this).rightRect.y = y;
            ((ECPSlider)ECPSlider.this).rightRect.width = ECPSlider.this.ARROW_SIZE;
            ((ECPSlider)ECPSlider.this).rightRect.height = ECPSlider.this.ARROW_SIZE;
            ((ECPSlider)ECPSlider.this).areaRect.x = ECPSlider.this.ARROW_SIZE;
            ((ECPSlider)ECPSlider.this).areaRect.y = y;
            ((ECPSlider)ECPSlider.this).areaRect.width = ((ECPSlider)ECPSlider.this).sliderRect.x + ((ECPSlider)ECPSlider.this).sliderRect.width - ECPSlider.this.ARROW_SIZE * 2;
            ((ECPSlider)ECPSlider.this).areaRect.height = ECPSlider.this.ARROW_SIZE;
            ECPSlider.this.setThumbRect(ECPSlider.this.selection);
        }
    };

    public ECPSlider(Composite parent, int style) {
        super(parent, 0x20000000 | style);
        this.style = style;
        this.addListener(3, this.mouseListener);
        this.addListener(4, this.mouseListener);
        this.addListener(5, this.mouseListener);
        this.leftArrows = new Image[3];
        this.leftArrows[0] = ImageResources.SLIDER_ARROW_LEFT_NORMAL.getImage();
        this.leftArrows[1] = ImageResources.SLIDER_ARROW_LEFT_HOVER.getImage();
        this.leftArrows[2] = ImageResources.SLIDER_ARROW_LEFT_PUSHED.getImage();
        this.rightArrows = new Image[3];
        this.rightArrows[0] = ImageResources.SLIDER_ARROW_RIGHT_NORMAL.getImage();
        this.rightArrows[1] = ImageResources.SLIDER_ARROW_RIGHT_HOVER.getImage();
        this.rightArrows[2] = ImageResources.SLIDER_ARROW_RIGHT_PUSHED.getImage();
        this.leftArrow = this.leftArrows[0];
        this.rightArrow = this.rightArrows[0];
        this.leftBack = ImageResources.SLIDER_BACK_LEFT.getImage();
        this.middleBack = ImageResources.SLIDER_BACK_MIDDLE.getImage();
        this.rightBack = ImageResources.SLIDER_BACK_RIGHT.getImage();
        this.bar = ImageResources.SLIDER_BAR.getImage();
        this.addPaintListener(this.paintListener);
        this.addDisposeListener(this.disposeListener);
        this.addControlListener((ControlListener)this.controlListener);
    }

    private void redrawRect(Rectangle rect) {
        if (rect == null) {
            return;
        }
        this.redraw(rect.x, rect.y, rect.width, rect.height, false);
    }

    private void incrementHandler(boolean plus) {
        if (plus) {
            if (this.selection < this.maxValue) {
                int selected = this.selection + this.increment;
                this.selection = selected >= this.maxValue ? this.maxValue : selected;
                this.setThumbRect(this.selection);
            }
        } else if (this.selection > this.minValue) {
            int selected = this.selection - this.increment;
            this.selection = selected <= this.minValue ? this.minValue : selected;
            this.setThumbRect(this.selection);
        }
    }

    private void pageHandler(boolean plus) {
        int selected = 0;
        if (plus) {
            if (this.selection < this.maxValue) {
                selected = this.selection + this.pageIncrement;
                this.selection = selected >= this.maxValue ? this.maxValue : selected;
                this.setThumbRect(this.selection);
            }
        } else if (this.selection > this.minValue) {
            selected = this.selection - this.pageIncrement;
            this.selection = selected <= this.minValue ? this.minValue : selected;
            this.setThumbRect(this.selection);
        }
    }

    private void arrowStatus(boolean left, int status, boolean equal) {
        if (left) {
            if (equal) {
                this.leftArrowStatus = status;
                this.leftArrow = this.leftArrows[status];
                this.redrawRect(this.leftRect);
            }
        } else if (equal) {
            this.rightArrowStatus = status;
            this.rightArrow = this.rightArrows[status];
            this.redrawRect(this.rightRect);
        }
    }

    private int selectionToPoint(int selection) {
        return this.areaRect.x + selection * (this.areaRect.width - this.THUMB_WIDTH) / (this.maxValue - this.minValue);
    }

    private void setThumbRect(int selected) {
        if (selected < this.minValue || selected > this.maxValue) {
            return;
        }
        int xPos = this.selectionToPoint(selected);
        int y = this.areaRect.y - (this.THUMB_HEIGHT - this.areaRect.height) / 2;
        this.thumbRect.x = xPos;
        this.thumbRect.y = y;
        this.thumbRect.width = this.THUMB_WIDTH;
        this.thumbRect.height = this.THUMB_HEIGHT;
    }

    private void setThumbRect(Point point) {
        int thumbHeight = this.THUMB_HEIGHT;
        int thumbWidth = this.THUMB_WIDTH;
        if (point.x < this.areaRect.x) {
            point.x = this.areaRect.x;
        } else if (point.x > this.areaRect.x + this.areaRect.width - this.THUMB_WIDTH) {
            point.x = this.areaRect.x + this.areaRect.width - this.THUMB_WIDTH;
        }
        int y = this.areaRect.y - (thumbHeight - this.areaRect.height) / 2;
        int x = point.x;
        this.selection = (this.maxValue - this.minValue) * (point.x - this.areaRect.x) / (this.areaRect.width - this.THUMB_WIDTH);
        this.thumbRect.x = x;
        this.thumbRect.y = y;
        this.thumbRect.width = thumbWidth;
        this.thumbRect.height = thumbHeight;
    }

    public void setBackground(Color color) {
        this.bgColor = color;
        super.setBackground(color);
    }

    public Color getBackground() {
        return this.bgColor;
    }

    public void setIncrement(int increment) {
        this.increment = Math.abs(increment);
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setPageIncrement(int increment) {
        this.pageIncrement = Math.abs(increment);
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    public void setMaximum(int max) {
        this.maxValue = max;
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public void setMinimum(int min) {
        this.minValue = min;
    }

    public int getMinimum() {
        return this.minValue;
    }

    public int getSelection() {
        return this.selection;
    }

    public void setSelection(int selection) {
        this.setSelection(selection, true);
    }

    public void setSelection(int selection, boolean notify) {
        if (selection > this.maxValue) {
            selection = this.maxValue;
        } else if (selection < this.minValue) {
            selection = this.minValue;
        }
        this.selection = selection;
        this.setThumbRect(selection);
        this.redraw();
        if (notify) {
            this.notifyListeners(13, new Event());
        }
    }

    public void setValues(int sel, int min, int max, int thumb, int inc, int pageInc) {
        this.minValue = min;
        this.maxValue = max;
        if (max < min) {
            this.maxValue = min + 1;
        }
        this.increment = Math.abs(inc);
        this.pageIncrement = Math.abs(pageInc);
        this.setSelection(sel, false);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addListener(13, (Listener)new TypedListener((SWTEventListener)listener));
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = 0;
        int height = 0;
        this.checkWidget();
        if ((this.style & 0x200) == 0) {
            Rectangle bounds = this.bar.getBounds();
            width = bounds.width + 34;
            height = bounds.height + 10;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        this.sliderRect.x = 0;
        this.sliderRect.y = 0;
        this.sliderRect.width = width;
        this.sliderRect.height = height;
        return new Point(width, height);
    }
}

