/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.device;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.json.simple.JSONObject;
import org.tizen.ecp.device.ApplicationConstants;
import org.tizen.ecp.device.ApplicationInfo;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.FontResources;
import org.tizen.ecp.resources.ImageResources;
import org.tizen.ecp.sdb.MultiLineReceiver;
import org.tizen.ecp.sdb.SDBCommandRejectedException;
import org.tizen.ecp.sdb.SDBHelperUtil;
import org.tizen.ecp.sdb.SDBNotExistException;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.views.VMView;
import org.tizen.ecp.widgets.ECPButton;

public class UninstallerDisplay
extends ECPSubView
implements ILsn {
    private static Logger logger = LogUtil.getECPLogger(UninstallerDisplay.class).getLogger();
    private Table AppTable = null;
    private ArrayList<ApplicationInfo> appList = new ArrayList();
    private static String patternLs = "\\[(.*?)\\]";
    private static Pattern sLsPattern = Pattern.compile("pkg_type " + patternLs + "\tpkgid " + patternLs + "\tname " + patternLs + "\tversion " + patternLs);
    private String shellResult = null;
    private boolean isFinished = false;
    private Timer uninstallTimer;
    private UninstallTask UninstallTask = null;
    private Composite uComp = null;
    private TableItem[] selectionItems;
    private ECPButton uninstallBtn;
    private ECPButton refreshBtn;
    private SelectionAdapter UninstallListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            String message;
            UninstallerDisplay.access$702(UninstallerDisplay.this, UninstallerDisplay.this.AppTable.getSelection());
            logger.info("selection length: " + UninstallerDisplay.this.selectionItems.length);
            if (UninstallerDisplay.this.selectionItems.length == 1) {
                message = "Are you sure you want to uninstall this application?";
            } else {
                if (UninstallerDisplay.this.selectionItems.length == 0) {
                    return;
                }
                message = "Are you sure you want to uninstall these applications?";
            }
            MessageDialog msg = new MessageDialog();
            int response = msg.openSelectionDialog(message);
            if (response != 32) {
                return;
            }
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        UninstallerDisplay.this.startUninstallTask();
                    }
                    catch (Exception e) {
                        logger.severe(e.getMessage());
                    }
                }
            });
        }
    };
    private Runnable runnableRefresh = new Runnable(){

        @Override
        public void run() {
            if (!UninstallerDisplay.this.refresh()) {
                logger.severe("Failed to refresh");
            }
            logger.info("setEnable");
            UninstallerDisplay.this.refreshBtn.setEnabled(true);
            UninstallerDisplay.this.uninstallBtn.setEnabled(false);
        }
    };
    private SelectionAdapter RefreshListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            logger.info("refresh in");
            UninstallerDisplay.this.refreshBtn.setEnabled(false);
            Display.getCurrent().asyncExec(UninstallerDisplay.this.runnableRefresh);
            logger.info("refresh out");
        }
    };
    private SelectionAdapter SelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (UninstallerDisplay.this.AppTable.getSelectionIndices().length > 0) {
                UninstallerDisplay.this.uninstallBtn.setEnabled(true);
            } else {
                UninstallerDisplay.this.uninstallBtn.setEnabled(false);
            }
        }
    };

    public UninstallerDisplay() {
        this.title = "Uninstaller";
        this.pageHeight = 510;
    }

    @Override
    public void createView(Composite composite) {
        Composite comp = new Composite(composite, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginBottom = 5;
        gl.marginWidth = 12;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(1808));
        this.uComp = new Composite(comp, 0);
        GridLayout unGl = new GridLayout(3, false);
        unGl.marginWidth = 0;
        unGl.marginHeight = 0;
        this.uComp.setLayout((Layout)unGl);
        GridData unGD = new GridData(768);
        unGD.verticalIndent = 10;
        unGD.heightHint = 22;
        this.uComp.setLayoutData((Object)unGD);
        Label unlabel = new Label(this.uComp, 0);
        unlabel.setText("User Installed Applications");
        GridData unLabel = new GridData(1);
        unLabel.verticalAlignment = 0x1000000;
        unLabel.grabExcessHorizontalSpace = true;
        unlabel.setLayoutData((Object)unLabel);
        unlabel.setFont(FontResources.FONT_11.getFont());
        unlabel.setForeground(ColorResources.TEXT_GREEN.getColor());
        this.uninstallBtn = new ECPButton(this.uComp, 0);
        this.uninstallBtn.setText("Uninstall");
        this.uninstallBtn.setFont(FontResources.FONT_9.getFont());
        GridData andGd = new GridData(3);
        andGd.widthHint = 80;
        this.uninstallBtn.setLayoutData(andGd);
        this.uninstallBtn.addSelectionListener((SelectionListener)this.UninstallListener);
        this.uninstallBtn.setEnabled(false);
        this.refreshBtn = new ECPButton(this.uComp, 8);
        Image HoverBtn = ImageResources.REFRESH_HOVER.getImage();
        Image PushBtn = ImageResources.REFRESH_PUSH.getImage();
        Image NmlBtn = ImageResources.REFRESH_NML.getImage();
        Image DisBtn = ImageResources.REFRESH_DISABLE.getImage();
        this.refreshBtn.setImages(NmlBtn, HoverBtn, PushBtn, PushBtn, DisBtn, HoverBtn);
        GridData refreshGd = new GridData(3);
        refreshGd.widthHint = 18;
        refreshGd.verticalIndent = 3;
        this.refreshBtn.setLayoutData(refreshGd);
        this.refreshBtn.addSelectionListener((SelectionListener)this.RefreshListener);
        this.AppTable = new Table(comp, 67842);
        this.AppTable.setFont(FontResources.FONT_9.getFont());
        GridData unGd = new GridData(768);
        unGd.heightHint = 163;
        unGd.widthHint = 500;
        this.AppTable.setLayoutData((Object)unGd);
        for (appHList list : appHList.values()) {
            TableColumn column = new TableColumn(this.AppTable, 16384);
            column.setWidth(list.size);
            column.setText(list.name);
        }
        this.AppTable.addSelectionListener((SelectionListener)this.SelectionListener);
        this.AppTable.setHeaderVisible(true);
        this.refreshBtn.setEnabled(false);
        Display.getCurrent().asyncExec(this.runnableRefresh);
    }

    public ApplicationInfo getPackageByid(String pkgid) {
        for (ApplicationInfo list : this.appList) {
            if (!list.getPkgid().equals(pkgid)) continue;
            return list;
        }
        return null;
    }

    private void closeMultiLineReceiver(MultiLineReceiver receiver) {
        if (receiver != null) {
            try {
                receiver.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            receiver = null;
        }
    }

    public boolean refresh() {
        this.AppTable.removeAll();
        MultiLineReceiver receiver = new MultiLineReceiver(){

            @Override
            public void processNewLines(String[] lines) {
                for (String line : lines) {
                    Matcher m = sLsPattern.matcher(line);
                    if (m.matches()) {
                        if (!UninstallerDisplay.this.isRemovable(m.group(2))) continue;
                        ApplicationInfo appinfo = new ApplicationInfo(m.group(1), m.group(2), m.group(3), m.group(4));
                        UninstallerDisplay.this.appList.add(appinfo);
                        TableItem item = new TableItem(UninstallerDisplay.this.AppTable, 0);
                        item.setText(new String[]{m.group(2), m.group(1), m.group(3), m.group(4)});
                        logger.info("refreshing");
                        continue;
                    }
                    logger.info("not matched");
                }
                UninstallerDisplay.this.AppTable.layout();
            }
        };
        try {
            SDBHelperUtil.getInstance().executeShellCommand("pkgcmd -l", receiver);
            this.closeMultiLineReceiver(receiver);
        }
        catch (SDBNotExistException e) {
            this.closeMultiLineReceiver(receiver);
            new MessageDialog().openWarningDialog(e.getMessage());
            return false;
        }
        catch (SDBCommandRejectedException e) {
            this.closeMultiLineReceiver(receiver);
            logger.severe("SDBCommandRejectedException:" + e.getMessage());
            new MessageDialog().openWarningDialog("Emulator is not ready.\nPlease retry when the emulator is ready.");
            return false;
        }
        catch (TimeoutException e) {
            this.closeMultiLineReceiver(receiver);
            logger.severe("TimeoutException: " + e.getMessage());
            new MessageDialog().openWarningDialog(ApplicationConstants.FAIL_REFRESH + "SDB: " + e.getMessage());
            return false;
        }
        catch (IOException e) {
            this.closeMultiLineReceiver(receiver);
            logger.severe("IOException: " + e.getMessage());
            new MessageDialog().openWarningDialog(ApplicationConstants.FAIL_REFRESH + "SDB: " + e.getMessage());
            return false;
        }
        return true;
    }

    private void restoreItems() {
        this.AppTable.setEnabled(true);
        if (this.selectionItems.length == 0) {
            this.uninstallBtn.setEnabled(false);
        } else {
            this.uninstallBtn.setEnabled(true);
        }
        this.refreshBtn.setEnabled(true);
        this.isFinished = true;
    }

    public synchronized void startUninstallTask() {
        this.isFinished = false;
        this.uninstallBtn.setEnabled(false);
        this.refreshBtn.setEnabled(false);
        this.AppTable.setEnabled(false);
        this.uninstallTimer = new Timer();
        this.UninstallTask = new UninstallTask();
        this.uninstallTimer.schedule((TimerTask)this.UninstallTask, 0L, 100L);
        Shell tempShell = new Shell(Display.getDefault());
        MessageDialog msg = new MessageDialog(tempShell);
        for (int i = 0; i < this.selectionItems.length; ++i) {
            switch (this.uninstallSelection(this.selectionItems[i])) {
                case 2: {
                    msg.openWarningDialog("Failed to Uninstall. Cannot Communicate with Emulator.\nPlease Check the Connection.");
                    this.restoreItems();
                    return;
                }
                case 3: {
                    msg.openWarningDialog("Failed to Uninstall. Waiting time is over.");
                    this.restoreItems();
                    return;
                }
                case 4: {
                    msg.openWarningDialog("Failed to Uninstall. Selection App(s) is(are) not Matching.");
                    this.restoreItems();
                    return;
                }
            }
            logger.info("Succeeded to uninstall.");
        }
        this.AppTable.remove(this.AppTable.getSelectionIndices());
        this.selectionItems = this.AppTable.getSelection();
        logger.info("selection length: " + this.selectionItems.length);
        this.restoreItems();
    }

    public int removeApp(ApplicationInfo pkginfo) {
        MultiLineReceiver receiver = new MultiLineReceiver(){

            @Override
            public void processNewLines(String[] lines) {
                UninstallerDisplay.this.shellResult = lines[0];
                logger.info("Remove: " + lines[0]);
            }
        };
        try {
            SDBHelperUtil.getInstance().executeShellCommand(String.format("/usr/bin/pkgcmd -q -u -t %s -n %s", pkginfo.getPkg_type(), pkginfo.getPkgid()), receiver);
            this.closeMultiLineReceiver(receiver);
        }
        catch (SDBNotExistException e) {
            this.closeMultiLineReceiver(receiver);
            new MessageDialog().openWarningDialog(e.getMessage());
            return 5;
        }
        catch (TimeoutException e) {
            this.closeMultiLineReceiver(receiver);
            logger.severe(e.getMessage());
            return 3;
        }
        catch (SDBCommandRejectedException e) {
            this.closeMultiLineReceiver(receiver);
            logger.severe(e.getMessage());
            return 2;
        }
        catch (IOException e) {
            this.closeMultiLineReceiver(receiver);
            logger.severe(e.getMessage());
            return 1;
        }
        return 0;
    }

    public boolean isRemovable(String pkgid) {
        boolean result = false;
        MultiLineReceiver receiver = new MultiLineReceiver(){

            @Override
            public void processNewLines(String[] lines) {
                UninstallerDisplay.this.shellResult = lines[0];
            }
        };
        try {
            SDBHelperUtil.getInstance().executeShellCommand(String.format("/usr/bin/pkginfo --pkg %s | grep -i Removable", pkgid), receiver);
        }
        catch (SDBNotExistException e) {
            new MessageDialog().openWarningDialog(e.getMessage());
            result = false;
        }
        catch (SDBCommandRejectedException e) {
            logger.severe(e.getMessage());
            new MessageDialog().openWarningDialog("Emulator is not ready.\nPlease retry when the emulator is ready.");
            result = false;
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            new MessageDialog().openWarningDialog(ApplicationConstants.FAIL_REMOVE + "SDB: " + e.getMessage());
            result = false;
        }
        catch (IOException e) {
            e.printStackTrace();
            new MessageDialog().openWarningDialog(ApplicationConstants.FAIL_REMOVE + "SDB: " + e.getMessage());
            result = false;
        }
        this.closeMultiLineReceiver(receiver);
        if (this.shellResult != null) {
            if (this.shellResult.equals("Removable: 0")) {
                result = false;
            } else if (this.shellResult.equals("Removable: 1")) {
                result = true;
            } else {
                logger.severe("wrong message: " + this.shellResult);
            }
            this.shellResult = null;
        }
        return result;
    }

    private int uninstallSelection(TableItem item) {
        logger.info("selection data: " + item.getText());
        ApplicationInfo pkginfo = this.getPackageByid(item.getText());
        if (pkginfo == null) {
            logger.warning("Cannot find matching app");
            return 4;
        }
        return this.removeApp(pkginfo);
    }

    @Override
    protected void initializeWidget() {
    }

    public void displayContents(VMView instance) {
        super.showComposite();
    }

    @Override
    public void OnEventProc(String eventname, JSONObject jsParam) {
        String message = (String)jsParam.get((Object)"return");
        logger.info(message);
    }

    @Override
    public void OnEventProcPB(String eventname, GeneratedMessage param) {
        if (param instanceof Ecs.DeviceNtf) {
            // empty if block
        }
    }

    @Override
    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsnSet("Uninstaller");
        EventMgr.getInstance().AddLsn("Uninstaller", this);
        return true;
    }

    @Override
    public void OnActivate() {
    }

    @Override
    public void OnDeactivate() {
    }

    static /* synthetic */ TableItem[] access$702(UninstallerDisplay x0, TableItem[] x1) {
        x0.selectionItems = x1;
        return x1;
    }

    class UninstallTask
    extends TimerTask {
        UninstallTask() {
        }

        @Override
        public void run() {
            if (UninstallerDisplay.this.isFinished && UninstallerDisplay.this.uninstallTimer != null) {
                UninstallerDisplay.this.uninstallTimer.cancel();
            }
        }
    }

    private static enum appHList {
        APPID(0, "ID"),
        APPTYPE(70, "Type"),
        LABEL(250, "Label"),
        VERSION(100, "Version");

        int size;
        String name;

        private appHList(int size, String name) {
            this.size = size;
            this.name = name;
        }
    }
}

