/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.info;

import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.ecpinfo.xml.ContentsType;
import org.tizen.ecp.info.ContentButton;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.FontResources;
import org.tizen.ecp.utils.FormUtil;
import org.tizen.ecp.utils.SwtUtil;
import org.tizen.ecp.views.ECPSubView;

public class EIInformation
extends ECPSubView {
    private Composite comp;
    private String DETAIL = "The Event Injector lets you artificially create and use any data you need during \napplication execution. You can even imitate environmental conditions for device \nsensors:";
    private int WIDTH = 438;
    private int HEIGHT = 48;
    private int H_INDENT = 31;
    private int V_INDENT = 7;

    public EIInformation() {
        int count;
        this.title = "Event Injector";
        List<ContentsType> contents = ECPInfo.getInstance().getContentsInfo();
        if (contents != null && (count = contents.size()) > 0) {
            this.pageHeight = 100 + (this.HEIGHT + 10) * count;
        }
    }

    @Override
    protected void initializeWidget() {
    }

    @Override
    public void createView(Composite composite) {
        this.comp = FormUtil.createComposite(composite, 1);
        FormUtil.createLabel(this.comp, this.DETAIL, FontResources.FONT_9.getFont(), ColorResources.TEXT_NORMAL.getColor());
        GridData gd = FormUtil.createGD(this.WIDTH, this.HEIGHT, this.H_INDENT, this.V_INDENT);
        List<ContentsType> contents = ECPInfo.getInstance().getContentsInfo();
        if (contents == null) {
            return;
        }
        String jarPath = ECPInfo.getInstance().getJarPath();
        for (ContentsType content : contents) {
            Composite compContent = FormUtil.createComposite(composite, 2);
            compContent.setLayoutData((Object)gd);
            String prefixName = content.getDevice() + "/";
            Image nml = SwtUtil.dynamicLoadImage(jarPath, prefixName + content.getNormalImage());
            Image hover = SwtUtil.dynamicLoadImage(jarPath, prefixName + content.getHoverImage());
            if (nml == null || hover == null) continue;
            String label = content.getDevice();
            if (content.getDesc() != null) {
                label = label + " - " + content.getDesc();
            }
            new ContentButton(compContent, content.getDevice(), nml, hover, label);
        }
    }
}

