/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.resources;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.tizen.ecp.utils.SwtUtil;

class FontRegistry {
    private static Map<String, Font> map = new HashMap<String, Font>();

    FontRegistry() {
    }

    public static void dispose() {
        for (Font i : map.values()) {
            i.dispose();
        }
    }

    public static Font getFont(int height, int style) {
        String fontName = null;
        fontName = SwtUtil.isLinuxPlatform() ? "Dejavu Sans" : (SwtUtil.isWindowsPlatform() ? "Verdana" : "Lucida Grande");
        String fontKey = fontName + height + style;
        Font i = map.get(fontKey);
        if (i == null) {
            FontData data = new FontData(fontName, height, style);
            i = Display.getCurrent() == null ? new Font((Device)new Display(), data) : new Font((Device)Display.getCurrent(), data);
            map.put(fontKey, i);
        }
        return i;
    }
}

