/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.tizen.ecp.DynamicLoader;

public class SwtUtil {
    private SwtUtil() {
    }

    public static boolean isLinuxPlatform() {
        return "gtk".equalsIgnoreCase(SWT.getPlatform());
    }

    public static boolean isWindowsPlatform() {
        return "win32".equalsIgnoreCase(SWT.getPlatform());
    }

    public static boolean isMacPlatform() {
        return "cocoa".equalsIgnoreCase(SWT.getPlatform());
    }

    public static void tryDispose(Object ... Disposables) {
        if (null == Disposables) {
            return;
        }
        for (Object obj : Disposables) {
            if (null == obj || !(obj instanceof Widget)) continue;
            ((Widget)obj).dispose();
        }
    }

    public static void openInfoDialog(Shell shell, final String title, final String message) {
        final Shell s = shell == null ? new Shell() : shell;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageBox dialog = new MessageBox(s, 34);
                dialog.setText(title);
                dialog.setMessage(message);
                dialog.open();
            }
        });
    }

    public static Image dynamicLoadImage(String jarPath, String fileName) {
        URLClassLoader loader = DynamicLoader.getURLClassLoader(jarPath);
        if (loader == null) {
            return null;
        }
        Image image = null;
        InputStream is = loader.getResourceAsStream(fileName);
        if (is != null) {
            image = new Image((Device)Display.getCurrent(), is);
            try {
                is.close();
            }
            catch (IOException e) {
                return null;
            }
        }
        return image;
    }
}

