/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    String text;
    String message;
    TrayItem item;
    int x;
    int y;
    int timerId;
    long layoutText = 0L;
    long layoutMessage = 0L;
    int[] borderPolygon;
    boolean spikeAbove;
    boolean autohide;
    static final int BORDER = 5;
    static final int PADDING = 5;
    static final int INSET = 4;
    static final int TIP_HEIGHT = 20;
    static final int IMAGE_SIZE = 16;
    static final int DELAY = 8000;

    public ToolTip(Shell shell, int n) {
        super(shell, ToolTip.checkStyle(n));
        this.parent = shell;
        this.createWidget(0);
        shell.addToolTip(this);
    }

    static int checkStyle(int n) {
        int n2 = 11;
        if ((n & n2) == 0) {
            return n;
        }
        return ToolTip.checkBits(n, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void configure() {
        int[] nArray;
        int n;
        long l = OS.gdk_screen_get_default();
        OS.gtk_widget_realize(this.handle);
        int n2 = OS.gdk_screen_get_monitor_at_window(l, this.gtk_widget_get_window(this.handle));
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gdk_screen_get_monitor_geometry(l, n2, gdkRectangle);
        Point point = this.getSize(gdkRectangle.width / 4);
        int n3 = point.x;
        int n4 = point.y;
        point = this.getLocation();
        int n5 = point.x;
        int n6 = point.y;
        OS.gtk_window_resize(this.handle, n3, n4 + 20);
        boolean bl = this.spikeAbove = gdkRectangle.height >= n6 + n4 + 20;
        if (gdkRectangle.width >= n5 + n3) {
            if (gdkRectangle.height >= n6 + n4 + 20) {
                n = 20;
                nArray = new int[]{0, 5 + n, 1, 5 + n, 1, 3 + n, 3, 1 + n, 5, 1 + n, 5, n, 16, n, 16, 0, 35, n, n3 - 5, n, n3 - 5, 1 + n, n3 - 3, 1 + n, n3 - 1, 3 + n, n3 - 1, 5 + n, n3, 5 + n, n3, n4 - 5 + n, n3 - 1, n4 - 5 + n, n3 - 1, n4 - 3 + n, n3 - 2, n4 - 3 + n, n3 - 2, n4 - 2 + n, n3 - 3, n4 - 2 + n, n3 - 3, n4 - 1 + n, n3 - 5, n4 - 1 + n, n3 - 5, n4 + n, 5, n4 + n, 5, n4 - 1 + n, 3, n4 - 1 + n, 3, n4 - 2 + n, 2, n4 - 2 + n, 2, n4 - 3 + n, 1, n4 - 3 + n, 1, n4 - 5 + n, 0, n4 - 5 + n, 0, 5 + n};
                this.borderPolygon = new int[]{0, 5 + n, 1, 4 + n, 1, 3 + n, 3, 1 + n, 4, 1 + n, 5, n, 16, n, 16, 1, 35, n, n3 - 6, 0 + n, n3 - 5, 1 + n, n3 - 4, 1 + n, n3 - 2, 3 + n, n3 - 2, 4 + n, n3 - 1, 5 + n, n3 - 1, n4 - 6 + n, n3 - 2, n4 - 5 + n, n3 - 2, n4 - 4 + n, n3 - 4, n4 - 2 + n, n3 - 5, n4 - 2 + n, n3 - 6, n4 - 1 + n, 5, n4 - 1 + n, 4, n4 - 2 + n, 3, n4 - 2 + n, 1, n4 - 4 + n, 1, n4 - 5 + n, 0, n4 - 6 + n, 0, 5 + n};
                if ((this.parent.style & 0x8000000) != 0) {
                    n5 -= n3 - 36;
                    nArray[12] = n3 - 36;
                    nArray[14] = n3 - 16;
                    nArray[16] = n3 - 15;
                    this.borderPolygon[12] = n3 - 35;
                    this.borderPolygon[14] = this.borderPolygon[16] = n3 - 16;
                }
                OS.gtk_window_move(this.handle, Math.max(0, n5 - 17), n6);
            } else {
                nArray = new int[]{0, 5, 1, 5, 1, 3, 3, 1, 5, 1, 5, 0, n3 - 5, 0, n3 - 5, 1, n3 - 3, 1, n3 - 1, 3, n3 - 1, 5, n3, 5, n3, n4 - 5, n3 - 1, n4 - 5, n3 - 1, n4 - 3, n3 - 2, n4 - 3, n3 - 2, n4 - 2, n3 - 3, n4 - 2, n3 - 3, n4 - 1, n3 - 5, n4 - 1, n3 - 5, n4, 35, n4, 16, n4 + 20, 16, n4, 5, n4, 5, n4 - 1, 3, n4 - 1, 3, n4 - 2, 2, n4 - 2, 2, n4 - 3, 1, n4 - 3, 1, n4 - 5, 0, n4 - 5, 0, 5};
                this.borderPolygon = new int[]{0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0, n3 - 6, 0, n3 - 5, 1, n3 - 4, 1, n3 - 2, 3, n3 - 2, 4, n3 - 1, 5, n3 - 1, n4 - 6, n3 - 2, n4 - 5, n3 - 2, n4 - 4, n3 - 4, n4 - 2, n3 - 5, n4 - 2, n3 - 6, n4 - 1, 35, n4 - 1, 17, n4 + 20 - 2, 17, n4 - 1, 5, n4 - 1, 4, n4 - 2, 3, n4 - 2, 1, n4 - 4, 1, n4 - 5, 0, n4 - 6, 0, 5};
                if ((this.parent.style & 0x8000000) != 0) {
                    n5 -= n3 - 36;
                    nArray[42] = nArray[44] = n3 - 16;
                    nArray[46] = n3 - 35;
                    this.borderPolygon[36] = this.borderPolygon[38] = n3 - 17;
                    this.borderPolygon[40] = n3 - 35;
                }
                OS.gtk_window_move(this.handle, Math.max(0, n5 - 17), n6 - n4 - 20);
            }
        } else if (gdkRectangle.height >= n6 + n4 + 20) {
            n = 20;
            nArray = new int[]{0, 5 + n, 1, 5 + n, 1, 3 + n, 3, 1 + n, 5, 1 + n, 5, n, n3 - 35, n, n3 - 16, 0, n3 - 16, n, n3 - 5, n, n3 - 5, 1 + n, n3 - 3, 1 + n, n3 - 1, 3 + n, n3 - 1, 5 + n, n3, 5 + n, n3, n4 - 5 + n, n3 - 1, n4 - 5 + n, n3 - 1, n4 - 3 + n, n3 - 2, n4 - 3 + n, n3 - 2, n4 - 2 + n, n3 - 3, n4 - 2 + n, n3 - 3, n4 - 1 + n, n3 - 5, n4 - 1 + n, n3 - 5, n4 + n, 5, n4 + n, 5, n4 - 1 + n, 3, n4 - 1 + n, 3, n4 - 2 + n, 2, n4 - 2 + n, 2, n4 - 3 + n, 1, n4 - 3 + n, 1, n4 - 5 + n, 0, n4 - 5 + n, 0, 5 + n};
            this.borderPolygon = new int[]{0, 5 + n, 1, 4 + n, 1, 3 + n, 3, 1 + n, 4, 1 + n, 5, n, n3 - 35, n, n3 - 17, 2, n3 - 17, n, n3 - 6, n, n3 - 5, 1 + n, n3 - 4, 1 + n, n3 - 2, 3 + n, n3 - 2, 4 + n, n3 - 1, 5 + n, n3 - 1, n4 - 6 + n, n3 - 2, n4 - 5 + n, n3 - 2, n4 - 4 + n, n3 - 4, n4 - 2 + n, n3 - 5, n4 - 2 + n, n3 - 6, n4 - 1 + n, 5, n4 - 1 + n, 4, n4 - 2 + n, 3, n4 - 2 + n, 1, n4 - 4 + n, 1, n4 - 5 + n, 0, n4 - 6 + n, 0, 5 + n};
            if ((this.parent.style & 0x8000000) != 0) {
                n5 += n3 - 35;
                nArray[14] = 16;
                nArray[12] = 16;
                nArray[16] = 35;
                this.borderPolygon[14] = 16;
                this.borderPolygon[12] = 16;
                this.borderPolygon[16] = 35;
            }
            OS.gtk_window_move(this.handle, Math.min(gdkRectangle.width - n3, n5 - n3 + 17), n6);
        } else {
            nArray = new int[]{0, 5, 1, 5, 1, 3, 3, 1, 5, 1, 5, 0, n3 - 5, 0, n3 - 5, 1, n3 - 3, 1, n3 - 1, 3, n3 - 1, 5, n3, 5, n3, n4 - 5, n3 - 1, n4 - 5, n3 - 1, n4 - 3, n3 - 2, n4 - 3, n3 - 2, n4 - 2, n3 - 3, n4 - 2, n3 - 3, n4 - 1, n3 - 5, n4 - 1, n3 - 5, n4, n3 - 16, n4, n3 - 16, n4 + 20, n3 - 35, n4, 5, n4, 5, n4 - 1, 3, n4 - 1, 3, n4 - 2, 2, n4 - 2, 2, n4 - 3, 1, n4 - 3, 1, n4 - 5, 0, n4 - 5, 0, 5};
            this.borderPolygon = new int[]{0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0, n3 - 6, 0, n3 - 5, 1, n3 - 4, 1, n3 - 2, 3, n3 - 2, 4, n3 - 1, 5, n3 - 1, n4 - 6, n3 - 2, n4 - 5, n3 - 2, n4 - 4, n3 - 4, n4 - 2, n3 - 5, n4 - 2, n3 - 6, n4 - 1, n3 - 17, n4 - 1, n3 - 17, n4 + 20 - 2, n3 - 36, n4 - 1, 5, n4 - 1, 4, n4 - 2, 3, n4 - 2, 1, n4 - 4, 1, n4 - 5, 0, n4 - 6, 0, 5};
            if ((this.parent.style & 0x8000000) != 0) {
                n5 += n3 - 35;
                nArray[42] = 35;
                nArray[46] = 16;
                nArray[44] = 16;
                this.borderPolygon[36] = 35;
                this.borderPolygon[40] = 17;
                this.borderPolygon[38] = 17;
            }
            OS.gtk_window_move(this.handle, Math.min(gdkRectangle.width - n3, n5 - n3 + 17), n6 - n4 - 20);
        }
        OS.gtk_widget_realize(this.handle);
        Region region = new Region(this.display);
        region.add(nArray);
        if (OS.GTK3) {
            OS.gtk_widget_shape_combine_region(this.handle, region.handle);
        } else {
            long l2 = this.gtk_widget_get_window(this.handle);
            OS.gdk_window_shape_combine_region(l2, region.handle, 0, 0);
        }
        region.dispose();
    }

    void createHandle(int n) {
        if ((this.style & 0x1000) != 0) {
            this.state |= 8;
            this.handle = OS.gtk_window_new(1);
            Color color = this.display.getSystemColor(29);
            if (OS.GTK3) {
                GdkColor gdkColor = color.handle;
                GdkRGBA gdkRGBA = new GdkRGBA();
                gdkRGBA.alpha = 1.0;
                gdkRGBA.red = (float)(gdkColor.red & 0xFFFF) / 65535.0f;
                gdkRGBA.green = (float)(gdkColor.green & 0xFFFF) / 65535.0f;
                gdkRGBA.blue = (float)(gdkColor.blue & 0xFFFF) / 65535.0f;
                OS.gtk_widget_override_background_color(this.handle, 0, gdkRGBA);
            } else {
                OS.gtk_widget_modify_bg(this.handle, 0, color.handle);
            }
            OS.gtk_widget_set_app_paintable(this.handle, true);
            OS.gtk_window_set_type_hint(this.handle, 10);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.text = "";
        this.message = "";
        this.y = -1;
        this.x = -1;
        this.autohide = true;
    }

    void destroyWidget() {
        long l = this.topHandle();
        if (this.parent != null) {
            this.parent.removeTooTip(this);
        }
        this.releaseHandle();
        if (l != 0L && (this.state & 8) != 0) {
            if ((this.style & 0x1000) != 0) {
                OS.gtk_widget_destroy(l);
            } else {
                OS.g_object_unref(l);
            }
        }
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autohide;
    }

    Point getLocation() {
        int n = this.x;
        int n2 = this.y;
        if (this.item != null) {
            long l = this.item.handle;
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.gtk_status_icon_get_geometry(l, 0L, gdkRectangle, 0L);
            n = gdkRectangle.x + gdkRectangle.width / 2;
            n2 = gdkRectangle.y + gdkRectangle.height / 2;
        }
        if (n == -1 || n2 == -1) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.gdk_window_get_device_position(0L, nArray, nArray2, null);
            n = nArray[0];
            n2 = nArray2[0];
        }
        return new Point(n, n2);
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    String getNameText() {
        return this.getText();
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    Point getSize(int n) {
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (this.layoutText != 0L) {
            OS.pango_layout_set_width(this.layoutText, -1);
            OS.pango_layout_get_pixel_size(this.layoutText, nArray, nArray2);
            n2 = nArray[0];
        }
        if (this.layoutMessage != 0L) {
            OS.pango_layout_set_width(this.layoutMessage, -1);
            OS.pango_layout_get_pixel_size(this.layoutMessage, nArray, nArray2);
            n3 = nArray[0];
        }
        int n4 = 28;
        boolean bl = this.layoutText != 0L && (this.style & 0xB) != 0;
        int n5 = n4 + (bl ? 16 : 0);
        int n6 = Math.min(n, Math.max(n2 + n5, n3 + n4));
        int n7 = 0;
        int n8 = 0;
        if (this.layoutText != 0L) {
            OS.pango_layout_set_width(this.layoutText, (n - n5) * 1024);
            OS.pango_layout_get_pixel_size(this.layoutText, nArray, nArray2);
            n7 = nArray2[0];
        }
        if (this.layoutMessage != 0L) {
            OS.pango_layout_set_width(this.layoutMessage, (n - n4) * 1024);
            OS.pango_layout_get_pixel_size(this.layoutMessage, nArray, nArray2);
            n8 = nArray2[0];
        }
        int n9 = 20 + n8;
        if (this.layoutText != 0L) {
            n9 += Math.max(16, n7) + 10;
        }
        return new Point(n6, n9);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 0x1000) != 0) {
            return OS.gtk_widget_get_visible(this.handle);
        }
        return false;
    }

    long gtk_button_press_event(long l, long l2) {
        this.sendSelectionEvent(13, null, true);
        this.setVisible(false);
        return 0L;
    }

    void drawTooltip(long l) {
        Object object;
        long l2 = this.gtk_widget_get_window(this.handle);
        int n = 10;
        int n2 = 10;
        if (OS.USE_CAIRO) {
            int n3;
            int n4;
            long l3;
            long l4 = l3 = l != 0L ? l : OS.gdk_cairo_create(l2);
            if (l3 == 0L) {
                this.error(2);
            }
            if ((n4 = this.borderPolygon.length / 2) != 0) {
                Cairo.cairo_set_line_width(l3, 1.0);
                Cairo.cairo_move_to(l3, this.borderPolygon[0], this.borderPolygon[1]);
                int n5 = 1;
                n3 = 2;
                while (n5 < n4) {
                    Cairo.cairo_line_to(l3, (double)this.borderPolygon[n3] + 0.5, (double)this.borderPolygon[n3 + 1] + 0.5);
                    ++n5;
                    n3 += 2;
                }
                Cairo.cairo_close_path(l3);
                Cairo.cairo_stroke(l3);
            }
            if (this.spikeAbove) {
                n2 += 20;
            }
            if (this.layoutText != 0L) {
                byte[] byArray = null;
                n3 = this.style & 0xB;
                switch (n3) {
                    case 1: {
                        byArray = Converter.wcsToMbcs(null, "gtk-dialog-error", true);
                        break;
                    }
                    case 2: {
                        byArray = Converter.wcsToMbcs(null, "gtk-dialog-info", true);
                        break;
                    }
                    case 8: {
                        byArray = Converter.wcsToMbcs(null, "gtk-dialog-warning", true);
                    }
                }
                if (byArray != null) {
                    long l5;
                    long l6 = OS.gtk_icon_factory_lookup_default(byArray);
                    if (OS.GTK3) {
                        l5 = OS.gtk_icon_set_render_icon_pixbuf(l6, OS.gtk_widget_get_style_context(this.handle), 1);
                    } else {
                        long l7 = OS.gtk_widget_get_default_style();
                        l5 = OS.gtk_icon_set_render_icon(l6, l7, 0, 0, 1, 0L, 0L);
                    }
                    OS.gdk_cairo_set_source_pixbuf(l3, l5, n, n2);
                    Cairo.cairo_paint(l3);
                    OS.g_object_unref(l5);
                    n += 16;
                }
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                Color color = this.display.getSystemColor(28);
                OS.gdk_cairo_set_source_color(l3, color.handle);
                Cairo.cairo_move_to(l3, n += 4, n2);
                OS.pango_cairo_show_layout(l3, this.layoutText);
                OS.pango_layout_get_pixel_size(this.layoutText, nArray, nArray2);
                n2 += 10 + Math.max(16, nArray2[0]);
            }
            if (this.layoutMessage != 0L) {
                n = 14;
                Color color = this.display.getSystemColor(28);
                OS.gdk_cairo_set_source_color(l3, color.handle);
                Cairo.cairo_move_to(l3, n, n2);
                OS.pango_cairo_show_layout(l3, this.layoutMessage);
            }
            if (l3 != l) {
                Cairo.cairo_destroy(l3);
            }
            return;
        }
        long l8 = OS.gdk_gc_new(l2);
        OS.gdk_draw_polygon(l2, l8, 0, this.borderPolygon, this.borderPolygon.length / 2);
        if (this.spikeAbove) {
            n2 += 20;
        }
        if (this.layoutText != 0L) {
            object = null;
            int n6 = this.style & 0xB;
            switch (n6) {
                case 1: {
                    object = Converter.wcsToMbcs(null, "gtk-dialog-error", true);
                    break;
                }
                case 2: {
                    object = Converter.wcsToMbcs(null, "gtk-dialog-info", true);
                    break;
                }
                case 8: {
                    object = Converter.wcsToMbcs(null, "gtk-dialog-warning", true);
                }
            }
            if (object != null) {
                long l9 = OS.gtk_widget_get_default_style();
                long l10 = OS.gtk_icon_set_render_icon(OS.gtk_icon_factory_lookup_default((byte[])object), l9, 0, 0, 1, 0L, 0L);
                OS.gdk_draw_pixbuf(l2, l8, l10, 0, 0, n, n2, 16, 16, 1, 0, 0);
                OS.g_object_unref(l10);
                n += 16;
            }
            Color color = this.display.getSystemColor(28);
            OS.gdk_gc_set_foreground(l8, color.handle);
            OS.gdk_draw_layout(l2, l8, n += 4, n2, this.layoutText);
            int[] nArray = new int[1];
            int[] nArray3 = new int[1];
            OS.pango_layout_get_pixel_size(this.layoutText, nArray, nArray3);
            n2 += 10 + Math.max(16, nArray3[0]);
        }
        if (this.layoutMessage != 0L) {
            n = 14;
            object = this.display.getSystemColor(28);
            OS.gdk_gc_set_foreground(l8, ((Color)object).handle);
            OS.gdk_draw_layout(l2, l8, n, n2, this.layoutMessage);
        }
        OS.g_object_unref(l8);
    }

    long gtk_draw(long l, long l2) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        this.drawTooltip(l2);
        return 0L;
    }

    long gtk_expose_event(long l, long l2) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        this.drawTooltip(0L);
        return 0L;
    }

    long gtk_size_allocate(long l, long l2) {
        Point point = this.getLocation();
        int n = point.x;
        int n2 = point.y;
        long l3 = OS.gdk_screen_get_default();
        OS.gtk_widget_realize(l);
        int n3 = OS.gdk_screen_get_monitor_at_window(l3, this.gtk_widget_get_window(l));
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gdk_screen_get_monitor_geometry(l3, n3, gdkRectangle);
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(l, gtkAllocation);
        int n4 = gtkAllocation.width;
        int n5 = gtkAllocation.height;
        if (gdkRectangle.height < n2 + n5) {
            n2 -= n5;
        }
        if (gdkRectangle.width < n + n4) {
            n -= n4;
        }
        OS.gtk_window_move(l, n, n2);
        return 0L;
    }

    void hookEvents() {
        if ((this.style & 0x1000) != 0) {
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[18], 0, this.display.getClosure(18), true);
            OS.gtk_widget_add_events(this.handle, 256);
            OS.g_signal_connect_closure(this.handle, OS.button_press_event, this.display.getClosure(2), false);
        }
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void releaseWidget() {
        super.releaseWidget();
        this.setVisible(false);
        if (this.layoutText != 0L) {
            OS.g_object_unref(this.layoutText);
        }
        this.layoutText = 0L;
        if (this.layoutMessage != 0L) {
            OS.g_object_unref(this.layoutMessage);
        }
        this.layoutMessage = 0L;
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
        this.text = null;
        this.message = null;
        this.borderPolygon = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAutoHide(boolean bl) {
        this.checkWidget();
        this.autohide = bl;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.x = n;
        this.y = n2;
        if ((this.style & 0x1000) != 0 && OS.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
        if (this.layoutMessage != 0L) {
            OS.g_object_unref(this.layoutMessage);
        }
        this.layoutMessage = 0L;
        if (this.message.length() != 0) {
            byte[] byArray = Converter.wcsToMbcs(null, this.message, true);
            this.layoutMessage = OS.gtk_widget_create_pango_layout(this.handle, byArray);
            OS.pango_layout_set_auto_dir(this.layoutMessage, false);
            OS.pango_layout_set_wrap(this.layoutMessage, 2);
        }
        if (OS.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
        if (this.layoutText != 0L) {
            OS.g_object_unref(this.layoutText);
        }
        this.layoutText = 0L;
        if (this.text.length() != 0) {
            byte[] byArray = Converter.wcsToMbcs(null, this.text, true);
            this.layoutText = OS.gtk_widget_create_pango_layout(this.handle, byArray);
            OS.pango_layout_set_auto_dir(this.layoutText, false);
            long l = OS.pango_attr_weight_new(700);
            PangoAttribute pangoAttribute = new PangoAttribute();
            OS.memmove(pangoAttribute, l, (long)PangoAttribute.sizeof);
            pangoAttribute.start_index = 0;
            pangoAttribute.end_index = byArray.length;
            OS.memmove(l, pangoAttribute, (long)PangoAttribute.sizeof);
            long l2 = OS.pango_attr_list_new();
            OS.pango_attr_list_insert(l2, l);
            OS.pango_layout_set_attributes(this.layoutText, l2);
            OS.pango_attr_list_unref(l2);
            OS.pango_layout_set_wrap(this.layoutText, 2);
        }
        if (OS.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
        if (bl) {
            if ((this.style & 0x1000) != 0) {
                this.configure();
                OS.gtk_widget_show(this.handle);
            } else {
                long l = this.parent.vboxHandle;
                StringBuffer stringBuffer = new StringBuffer(this.text);
                if (this.text.length() > 0) {
                    stringBuffer.append("\n\n");
                }
                stringBuffer.append(this.message);
                byte[] byArray = Converter.wcsToMbcs(null, stringBuffer.toString(), true);
                OS.gtk_widget_set_tooltip_text(l, byArray);
            }
            if (this.autohide) {
                this.timerId = OS.g_timeout_add(8000, this.display.windowTimerProc, this.handle);
            }
        } else if ((this.style & 0x1000) != 0) {
            OS.gtk_widget_hide(this.handle);
        } else {
            long l = this.parent.vboxHandle;
            byte[] byArray = Converter.wcsToMbcs(null, "", true);
            OS.gtk_widget_set_tooltip_text(l, byArray);
        }
    }

    long timerProc(long l) {
        if ((this.style & 0x1000) != 0) {
            OS.gtk_widget_hide(this.handle);
        }
        return 0L;
    }
}

