/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public class HTMLTransfer
extends ByteArrayTransfer {
    private static HTMLTransfer _instance = new HTMLTransfer();
    private static final String TEXT_HTML = "text/html";
    private static final int TEXT_HTML_ID = HTMLTransfer.registerType("text/html");
    private static final String TEXT_HTML2 = "TEXT/HTML";
    private static final int TEXT_HTML2_ID = HTMLTransfer.registerType("TEXT/HTML");

    private HTMLTransfer() {
    }

    public static HTMLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        String string;
        byte[] byArray;
        int n;
        int n2;
        transferData.result = 0;
        if (!this.checkHTML(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((n2 = OS.g_malloc(n = (byArray = Converter.wcsToMbcs(null, string = (String)object, true)).length)) == 0) {
            return;
        }
        OS.memmove(n2, byArray, n);
        transferData.length = n;
        transferData.format = 8;
        transferData.pValue = n2;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        String string;
        Object[] objectArray;
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int n = transferData.format * transferData.length / 8 / 2 * 2;
        if (n <= 0) {
            return null;
        }
        char[] cArray = new char[1];
        if (n > 1) {
            OS.memmove(cArray, transferData.pValue, 2);
        }
        if (cArray[0] == '\ufeff' || cArray[0] == '\ufffe') {
            objectArray = new char[n / 2];
            OS.memmove(objectArray, transferData.pValue, n);
            string = new String((char[])objectArray);
        } else {
            objectArray = new byte[n];
            OS.memmove((byte[])objectArray, transferData.pValue, n);
            char[] cArray2 = Converter.mbcsToWcs(null, (byte[])objectArray);
            string = new String(cArray2);
        }
        int n2 = string.indexOf(0);
        return n2 == -1 ? string : string.substring(0, n2);
    }

    protected int[] getTypeIds() {
        return new int[]{TEXT_HTML_ID, TEXT_HTML2_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TEXT_HTML, TEXT_HTML2};
    }

    boolean checkHTML(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkHTML(object);
    }
}

