/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ExpanderDrawData
extends DrawData {
    public ExpanderDrawData() {
        this.state = new int[1];
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        int n = theme.treeHandle;
        int n2 = OS.gtk_widget_get_style(n);
        int n3 = gC.getGCData().drawable;
        theme.transferClipping(gC, n2);
        int n4 = this.getStateType(0);
        int n5 = 0;
        if ((this.style & 0x400) != 0) {
            n5 = 3;
        }
        byte[] byArray = Converter.wcsToMbcs(null, "treeview", true);
        int n6 = theme.getWidgetProperty(n, "expander-size");
        int n7 = rectangle.x + n6 / 2;
        int n8 = rectangle.y + n6 / 2;
        if (OS.GTK3) {
            int n9 = OS.gdk_cairo_create(n3);
            int n10 = OS.gtk_widget_get_style_context(n2);
            OS.gtk_render_expander(n10, n9, rectangle.x, rectangle.y, n6, n6);
            Cairo.cairo_destroy(n9);
        } else {
            OS.gtk_paint_expander(n2, n3, n4, null, n, byArray, n7, n8, n5);
        }
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        if (!rectangle.contains(point)) {
            return -1;
        }
        int n = theme.treeHandle;
        int n2 = theme.getWidgetProperty(n, "expander-size");
        if (new Rectangle(rectangle.x, rectangle.y, n2, n2).contains(point)) {
            return 0;
        }
        return -1;
    }
}

