/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkDragContext;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    long dragOverStart;
    Runnable dragOverHeartbeat;
    DNDEvent dragOverEvent;
    int drag_motion_handler;
    int drag_leave_handler;
    int drag_data_received_handler;
    int drag_drop_handler;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";
    static final String IS_ACTIVE = "org.eclipse.swt.internal.control.isactive";
    static final int DRAGOVER_HYSTERESIS = 50;
    static Callback Drag_Motion = new Callback(DropTarget.class, "Drag_Motion", 5);
    static Callback Drag_Leave;
    static Callback Drag_Data_Received;
    static Callback Drag_Drop;

    public DropTarget(Control control, int n) {
        super(control, DropTarget.checkStyle(n));
        this.control = control;
        if (Drag_Motion == null || Drag_Leave == null || Drag_Data_Received == null || Drag_Drop == null) {
            DND.error(2001);
        }
        if (control.getData("DropTarget") != null) {
            DND.error(2001);
        }
        control.setData("DropTarget", this);
        this.drag_motion_handler = OS.g_signal_connect(control.handle, OS.drag_motion, Drag_Motion.getAddress(), 0);
        this.drag_leave_handler = OS.g_signal_connect(control.handle, OS.drag_leave, Drag_Leave.getAddress(), 0);
        this.drag_data_received_handler = OS.g_signal_connect(control.handle, OS.drag_data_received, Drag_Data_Received.getAddress(), 0);
        this.drag_drop_handler = OS.g_signal_connect(control.handle, OS.drag_drop, Drag_Drop.getAddress(), 0);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        Object object = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (object instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)object;
        } else if (control instanceof Table) {
            this.dropEffect = new TableDropTargetEffect((Table)control);
        } else if (control instanceof Tree) {
            this.dropEffect = new TreeDropTargetEffect((Tree)control);
        }
        this.dragOverHeartbeat = new Runnable(){

            public void run() {
                Control control = DropTarget.this.control;
                if (control == null || control.isDisposed() || DropTarget.this.dragOverStart == 0L) {
                    return;
                }
                long l = System.currentTimeMillis();
                int n = 50;
                if (l < DropTarget.this.dragOverStart) {
                    n = (int)(DropTarget.this.dragOverStart - l);
                } else {
                    DropTarget.this.dragOverEvent.time += 50;
                    int n2 = DropTarget.this.dragOverEvent.operations;
                    TransferData[] transferDataArray = DropTarget.this.dragOverEvent.dataTypes;
                    TransferData[] transferDataArray2 = new TransferData[transferDataArray.length];
                    System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray2.length);
                    DNDEvent dNDEvent = new DNDEvent();
                    dNDEvent.widget = DropTarget.this.dragOverEvent.widget;
                    dNDEvent.x = DropTarget.this.dragOverEvent.x;
                    dNDEvent.y = DropTarget.this.dragOverEvent.y;
                    dNDEvent.time = DropTarget.this.dragOverEvent.time;
                    dNDEvent.feedback = 1;
                    dNDEvent.dataTypes = transferDataArray2;
                    dNDEvent.dataType = DropTarget.this.selectedDataType;
                    dNDEvent.operations = DropTarget.this.dragOverEvent.operations;
                    dNDEvent.detail = DropTarget.this.selectedOperation;
                    if (DropTarget.this.dropEffect != null) {
                        dNDEvent.item = DropTarget.this.dropEffect.getItem(DropTarget.this.dragOverEvent.x, DropTarget.this.dragOverEvent.y);
                    }
                    DropTarget.this.selectedDataType = null;
                    DropTarget.this.selectedOperation = 0;
                    DropTarget.this.notifyListeners(2004, dNDEvent);
                    if (dNDEvent.dataType != null) {
                        for (int i = 0; i < transferDataArray.length; ++i) {
                            if (transferDataArray[i].type != dNDEvent.dataType.type) continue;
                            DropTarget.this.selectedDataType = dNDEvent.dataType;
                            break;
                        }
                    }
                    if (DropTarget.this.selectedDataType != null && (dNDEvent.detail & n2) != 0) {
                        DropTarget.this.selectedOperation = dNDEvent.detail;
                    }
                }
                control = DropTarget.this.control;
                if (control == null || control.isDisposed()) {
                    return;
                }
                control.getDisplay().timerExec(n, DropTarget.this.dragOverHeartbeat);
            }
        };
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    static int Drag_Data_Received(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        DropTarget dropTarget = DropTarget.FindDropTarget(n);
        if (dropTarget == null) {
            return 0;
        }
        dropTarget.drag_data_received(n, n2, n3, n4, n5, n6, n7);
        return 0;
    }

    static int Drag_Drop(int n, int n2, int n3, int n4, int n5) {
        DropTarget dropTarget = DropTarget.FindDropTarget(n);
        if (dropTarget == null) {
            return 0;
        }
        return dropTarget.drag_drop(n, n2, n3, n4, n5) ? 1 : 0;
    }

    static int Drag_Leave(int n, int n2, int n3) {
        DropTarget dropTarget = DropTarget.FindDropTarget(n);
        if (dropTarget == null) {
            return 0;
        }
        dropTarget.drag_leave(n, n2, n3);
        return 0;
    }

    static int Drag_Motion(int n, int n2, int n3, int n4, int n5) {
        DropTarget dropTarget = DropTarget.FindDropTarget(n);
        if (dropTarget == null) {
            return 0;
        }
        return dropTarget.drag_motion(n, n2, n3, n4, n5) ? 1 : 0;
    }

    static DropTarget FindDropTarget(int n) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData("DropTarget");
    }

    public void addDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dropTargetListener);
        dNDListener.dndWidget = this;
        this.addListener(2002, dNDListener);
        this.addListener(2003, dNDListener);
        this.addListener(2004, dNDListener);
        this.addListener(2005, dNDListener);
        this.addListener(2006, dNDListener);
        this.addListener(2007, dNDListener);
    }

    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = DropTarget.class.getName();
        if (!string2.equals(string)) {
            DND.error(43);
        }
    }

    void drag_data_received(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        DNDEvent dNDEvent = new DNDEvent();
        if (n5 == 0 || !this.setEventData(n2, n3, n4, n7, dNDEvent)) {
            this.keyOperation = -1;
            return;
        }
        this.keyOperation = -1;
        int n8 = dNDEvent.operations;
        Object object = null;
        TransferData transferData = new TransferData();
        int n9 = OS.gtk_selection_data_get_length(n5);
        int n10 = OS.gtk_selection_data_get_format(n5);
        int n11 = OS.gtk_selection_data_get_data(n5);
        int n12 = OS.gtk_selection_data_get_data_type(n5);
        if (n11 != 0) {
            transferData.type = n12;
            transferData.length = n9;
            transferData.pValue = n11;
            transferData.format = n10;
            for (int i = 0; i < this.transferAgents.length; ++i) {
                Transfer transfer = this.transferAgents[i];
                if (transfer == null || !transfer.isSupportedType(transferData)) continue;
                object = transfer.nativeToJava(transferData);
                break;
            }
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        dNDEvent.detail = this.selectedOperation;
        dNDEvent.dataType = transferData;
        dNDEvent.data = object;
        this.selectedOperation = 0;
        this.notifyListeners(2006, dNDEvent);
        if ((n8 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.g_signal_stop_emission_by_name(n, OS.drag_data_received);
        OS.gtk_drag_finish(n2, this.selectedOperation != 0, this.selectedOperation == 2, n7);
    }

    boolean drag_drop(int n, int n2, int n3, int n4, int n5) {
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(n2, n3, n4, n5, dNDEvent)) {
            this.keyOperation = -1;
            return false;
        }
        this.keyOperation = -1;
        int n6 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.detail = this.selectedOperation;
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(2007, dNDEvent);
        if (dNDEvent.dataType != null) {
            for (int i = 0; i < transferDataArray.length; ++i) {
                if (transferDataArray[i].type != dNDEvent.dataType.type) continue;
                this.selectedDataType = transferDataArray[i];
                break;
            }
        }
        if (this.selectedDataType != null && (dNDEvent.detail & n6) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0) {
            return false;
        }
        OS.gtk_drag_get_data(n, n2, this.selectedDataType.type, n5);
        return true;
    }

    void drag_leave(int n, int n2, int n3) {
        this.updateDragOverHover(0L, null);
        if (this.keyOperation == -1) {
            return;
        }
        this.keyOperation = -1;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = n3;
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
    }

    boolean drag_motion(int n, int n2, int n3, int n4, int n5) {
        DNDEvent dNDEvent;
        int n6 = this.keyOperation;
        if (n6 == -1 || !((Boolean)this.control.getData(IS_ACTIVE)).booleanValue()) {
            this.selectedDataType = null;
            this.selectedOperation = 0;
        }
        if (!this.setEventData(n2, n3, n4, n5, dNDEvent = new DNDEvent())) {
            this.keyOperation = -1;
            OS.gdk_drag_status(n2, 0, n5);
            return false;
        }
        int n7 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        if (n6 == -1) {
            dNDEvent.type = 2002;
        } else if (this.keyOperation == n6) {
            dNDEvent.type = 2004;
            dNDEvent.dataType = this.selectedDataType;
            dNDEvent.detail = this.selectedOperation;
        } else {
            dNDEvent.type = 2005;
            dNDEvent.dataType = this.selectedDataType;
        }
        this.updateDragOverHover(50L, dNDEvent);
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(dNDEvent.type, dNDEvent);
        if (dNDEvent.detail == 16) {
            int n8 = dNDEvent.detail = (n7 & 2) != 0 ? 2 : 0;
        }
        if (dNDEvent.dataType != null) {
            for (int i = 0; i < transferDataArray.length; ++i) {
                if (transferDataArray[i].type != dNDEvent.dataType.type) continue;
                this.selectedDataType = transferDataArray[i];
                break;
            }
        }
        if (this.selectedDataType != null && (n7 & dNDEvent.detail) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        switch (this.selectedOperation) {
            case 0: {
                OS.gdk_drag_status(n2, 0, n5);
                break;
            }
            case 1: {
                OS.gdk_drag_status(n2, 2, n5);
                break;
            }
            case 2: {
                OS.gdk_drag_status(n2, 4, n5);
                break;
            }
            case 4: {
                OS.gdk_drag_status(n2, 8, n5);
            }
        }
        if (n6 == -1) {
            this.dragOverHeartbeat.run();
        }
        return true;
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetListener[] getDropListeners() {
        Listener[] listenerArray = this.getListeners(2002);
        int n = listenerArray.length;
        DropTargetListener[] dropTargetListenerArray = new DropTargetListener[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Listener listener = listenerArray[i];
            if (!(listener instanceof DNDListener)) continue;
            dropTargetListenerArray[n2] = (DropTargetListener)((DNDListener)listener).getEventListener();
            ++n2;
        }
        if (n2 == n) {
            return dropTargetListenerArray;
        }
        DropTargetListener[] dropTargetListenerArray2 = new DropTargetListener[n2];
        System.arraycopy(dropTargetListenerArray, 0, dropTargetListenerArray2, 0, n2);
        return dropTargetListenerArray2;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState() {
        int n;
        int n2;
        int[] nArray = new int[1];
        if (OS.GTK3) {
            n2 = OS.gdk_get_default_root_window();
            n = OS.gdk_display_get_device_manager(OS.gdk_window_get_display(n2));
            int n3 = OS.gdk_device_manager_get_client_pointer(n);
            OS.gdk_window_get_device_position(n2, n3, null, null, nArray);
        } else {
            OS.gdk_window_get_pointer(0, null, null, nArray);
        }
        n2 = (nArray[0] & 4) != 0 ? 1 : 0;
        int n4 = n = (nArray[0] & 1) != 0 ? 1 : 0;
        if (n2 != 0 && n != 0) {
            return 4;
        }
        if (n2 != 0) {
            return 1;
        }
        if (n != 0) {
            return 2;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_motion_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_leave_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_data_received_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_drop_handler);
        if (this.transferAgents.length != 0) {
            OS.gtk_drag_dest_unset(this.control.handle);
        }
        this.transferAgents = null;
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.control.setData("DropTarget", null);
        this.control = null;
        this.controlListener = null;
    }

    int opToOsOp(int n) {
        int n2 = 0;
        if ((n & 1) == 1) {
            n2 |= 2;
        }
        if ((n & 2) == 2) {
            n2 |= 4;
        }
        if ((n & 4) == 4) {
            n2 |= 8;
        }
        return n2;
    }

    int osOpToOp(int n) {
        int n2 = 0;
        if ((n & 2) == 2) {
            n2 |= 1;
        }
        if ((n & 4) == 4) {
            n2 |= 2;
        }
        if ((n & 8) == 8) {
            n2 |= 4;
        }
        return n2;
    }

    public void removeDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        this.removeListener(2002, dropTargetListener);
        this.removeListener(2003, dropTargetListener);
        this.removeListener(2004, dropTargetListener);
        this.removeListener(2005, dropTargetListener);
        this.removeListener(2006, dropTargetListener);
        this.removeListener(2007, dropTargetListener);
    }

    public void setTransfer(Transfer[] transferArray) {
        int n;
        int n2;
        int n3;
        if (transferArray == null) {
            DND.error(4);
        }
        if (this.transferAgents.length != 0) {
            OS.gtk_drag_dest_unset(this.control.handle);
        }
        this.transferAgents = transferArray;
        GtkTargetEntry[] gtkTargetEntryArray = new GtkTargetEntry[]{};
        for (n3 = 0; n3 < transferArray.length; ++n3) {
            Transfer transfer = transferArray[n3];
            if (transfer == null) continue;
            int[] nArray = transfer.getTypeIds();
            String[] stringArray = transfer.getTypeNames();
            for (int i = 0; i < nArray.length; ++i) {
                GtkTargetEntry gtkTargetEntry = new GtkTargetEntry();
                byte[] byArray = Converter.wcsToMbcs(null, stringArray[i], true);
                gtkTargetEntry.target = OS.g_malloc(byArray.length);
                OS.memmove(gtkTargetEntry.target, byArray, byArray.length);
                gtkTargetEntry.info = nArray[i];
                GtkTargetEntry[] gtkTargetEntryArray2 = new GtkTargetEntry[gtkTargetEntryArray.length + 1];
                System.arraycopy(gtkTargetEntryArray, 0, gtkTargetEntryArray2, 0, gtkTargetEntryArray.length);
                gtkTargetEntryArray2[gtkTargetEntryArray.length] = gtkTargetEntry;
                gtkTargetEntryArray = gtkTargetEntryArray2;
            }
        }
        n3 = OS.g_malloc(gtkTargetEntryArray.length * GtkTargetEntry.sizeof);
        for (n2 = 0; n2 < gtkTargetEntryArray.length; ++n2) {
            OS.memmove(n3 + n2 * GtkTargetEntry.sizeof, gtkTargetEntryArray[n2], GtkTargetEntry.sizeof);
        }
        n2 = this.opToOsOp(this.getStyle());
        if (this.control instanceof Combo && (this.control.getStyle() & 8) == 0 && (n = OS.gtk_bin_get_child(this.control.handle)) != 0) {
            OS.gtk_drag_dest_unset(n);
        }
        OS.gtk_drag_dest_set(this.control.handle, 0, n3, gtkTargetEntryArray.length, n2);
        for (int i = 0; i < gtkTargetEntryArray.length; ++i) {
            OS.g_free(gtkTargetEntryArray[i].target);
        }
    }

    public void setDropTargetEffect(DropTargetEffect dropTargetEffect) {
        this.dropEffect = dropTargetEffect;
    }

    boolean setEventData(int n, int n2, int n3, int n4, DNDEvent dNDEvent) {
        Object object;
        Object object2;
        int n5;
        int n6;
        if (n == 0) {
            return false;
        }
        int n7 = 0;
        int n8 = 0;
        if (OS.GTK3) {
            n7 = OS.gdk_drag_context_list_targets(n);
            n8 = OS.gdk_drag_context_get_actions(n);
        } else {
            GdkDragContext gdkDragContext = new GdkDragContext();
            OS.memmove(gdkDragContext, n, GdkDragContext.sizeof);
            n7 = gdkDragContext.targets;
            n8 = gdkDragContext.actions;
        }
        if (n7 == 0) {
            return false;
        }
        int n9 = this.getStyle();
        int n10 = this.osOpToOp(n8) & n9;
        if (n10 == 0) {
            return false;
        }
        this.keyOperation = n6 = this.getOperationFromKeyState();
        if (n6 == 16) {
            if ((n9 & 0x10) == 0) {
                n6 = (n10 & 2) != 0 ? 2 : 0;
            }
        } else if ((n6 & n10) == 0) {
            n6 = 0;
        }
        TransferData[] transferDataArray = new TransferData[]{};
        while (n7 != 0) {
            n5 = OS.g_list_data(n7);
            object2 = new TransferData();
            ((TransferData)object2).type = n5;
            for (int i = 0; i < this.transferAgents.length; ++i) {
                object = this.transferAgents[i];
                if (object == null || !((Transfer)object).isSupportedType((TransferData)object2)) continue;
                TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + 1];
                System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
                transferDataArray2[transferDataArray.length] = object2;
                transferDataArray = transferDataArray2;
                break;
            }
            n7 = OS.g_list_next(n7);
        }
        if (transferDataArray.length == 0) {
            return false;
        }
        n5 = OS.gtk_widget_get_window(this.control.handle);
        object2 = new int[1];
        int[] nArray = new int[1];
        OS.gdk_window_get_origin(n5, (int[])object2, nArray);
        object = new Point((int)(object2[0] + n2), nArray[0] + n3);
        dNDEvent.widget = this;
        dNDEvent.x = ((Point)object).x;
        dNDEvent.y = ((Point)object).y;
        dNDEvent.time = n4;
        dNDEvent.feedback = 1;
        dNDEvent.dataTypes = transferDataArray;
        dNDEvent.dataType = transferDataArray[0];
        dNDEvent.operations = n10;
        dNDEvent.detail = n6;
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(((Point)object).x, ((Point)object).y);
        }
        return true;
    }

    void updateDragOverHover(long l, DNDEvent dNDEvent) {
        if (l == 0L) {
            this.dragOverStart = 0L;
            this.dragOverEvent = null;
            return;
        }
        this.dragOverStart = System.currentTimeMillis() + l;
        if (this.dragOverEvent == null) {
            this.dragOverEvent = new DNDEvent();
        }
        this.dragOverEvent.x = dNDEvent.x;
        this.dragOverEvent.y = dNDEvent.y;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        this.dragOverEvent.dataTypes = transferDataArray;
        this.dragOverEvent.operations = dNDEvent.operations;
        this.dragOverEvent.time = dNDEvent.time;
    }

    static {
        if (Drag_Motion.getAddress() == 0) {
            SWT.error(3);
        }
        if ((Drag_Leave = new Callback(DropTarget.class, "Drag_Leave", 3)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((Drag_Data_Received = new Callback(DropTarget.class, "Drag_Data_Received", 7)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((Drag_Drop = new Callback(DropTarget.class, "Drag_Drop", 5)).getAddress() == 0) {
            SWT.error(3);
        }
    }
}

