-- EFL LuaJIT bindings: evas_3d_mesh.eo (class Evas_3D_Mesh)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.evas_3d_mesh_class_get()
    eo.class_register("Evas_3D_Mesh", "Evas_3D_Object", __body, __class)
    eo.class_mixin("Evas_3D_Mesh", "Evas_Common_Interface")
    eo.class_mixin("Evas_3D_Mesh", "Efl_File")
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *evas_3d_mesh_class_get(void);
    void evas_3d_mesh_shade_mode_set(Evas_3D_Shade_Mode mode);
    Evas_3D_Shade_Mode evas_3d_mesh_shade_mode_get(void);
    void evas_3d_mesh_blending_enable_set(Eina_Bool blending);
    Eina_Bool evas_3d_mesh_blending_enable_get(void);
    void evas_3d_mesh_frame_material_set(int frame, Evas_3D_Material * material);
    Evas_3D_Material *evas_3d_mesh_frame_material_get(int frame);
    void evas_3d_mesh_vertex_assembly_set(Evas_3D_Vertex_Assembly assembly);
    Evas_3D_Vertex_Assembly evas_3d_mesh_vertex_assembly_get(void);
    void evas_3d_mesh_mmap_set(Eina_File * file, const char * key);
    void evas_3d_mesh_frame_vertex_data_set(int frame, Evas_3D_Vertex_Attrib attrib, int stride, const void * data);
    void evas_3d_mesh_frame_vertex_data_copy_set(int frame, Evas_3D_Vertex_Attrib attrib, int stride, const void * data);
    void *evas_3d_mesh_frame_vertex_data_map(int frame, Evas_3D_Vertex_Attrib attrib);
    void evas_3d_mesh_frame_vertex_data_unmap(int frame, Evas_3D_Vertex_Attrib attrib);
    int evas_3d_mesh_frame_vertex_stride_get(int frame, Evas_3D_Vertex_Attrib attrib);
    void evas_3d_mesh_index_data_set(Evas_3D_Index_Format format, int count, const void * indices);
    void evas_3d_mesh_index_data_copy_set(Evas_3D_Index_Format format, int count, const void * indices);
    Evas_3D_Index_Format evas_3d_mesh_index_format_get(void);
    int evas_3d_mesh_index_count_get(void);
    void *evas_3d_mesh_index_data_map(void);
    void evas_3d_mesh_index_data_unmap(void);
    void evas_3d_mesh_frame_add(int frame);
    void evas_3d_mesh_frame_del(int frame);
    void evas_3d_mesh_vertex_count_set(unsigned int count);
    int evas_3d_mesh_vertex_count_get(void);
    void evas_3d_mesh_fog_color_set(Evas_Real r, Evas_Real g, Evas_Real b, Evas_Real a);
    void evas_3d_mesh_fog_color_get(Evas_Real *r, Evas_Real *g, Evas_Real *b, Evas_Real *a);
    void evas_3d_mesh_blending_func_set(Evas_3D_Blend_Func sfactor, Evas_3D_Blend_Func dfactor);
    void evas_3d_mesh_blending_func_get(Evas_3D_Blend_Func *sfactor, Evas_3D_Blend_Func *dfactor);
    void evas_3d_mesh_fog_enable_set(Eina_Bool enabled);
    Eina_Bool evas_3d_mesh_fog_enable_get(void);
]]

__body = {
    __eo_ctor = function(self, __func)
        if __func then __func() end
    end,

    shade_mode_set = function(self, mode)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_shade_mode_set(mode)
        eo.__do_end()
    end,

    shade_mode_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.evas_3d_mesh_shade_mode_get()
        eo.__do_end()
        return v
    end,

    blending_enable_set = function(self, blending)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_blending_enable_set(blending)
        eo.__do_end()
    end,

    blending_enable_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.evas_3d_mesh_blending_enable_get()
        eo.__do_end()
        return v
    end,

    frame_material_set = function(self, frame, material)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_frame_material_set(frame, material)
        eo.__do_end()
    end,

    frame_material_get = function(self, frame)
        eo.__do_start(self, __class)
        local v = __lib.evas_3d_mesh_frame_material_get(frame)
        eo.__do_end()
        return v
    end,

    vertex_assembly_set = function(self, assembly)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_vertex_assembly_set(assembly)
        eo.__do_end()
    end,

    vertex_assembly_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.evas_3d_mesh_vertex_assembly_get()
        eo.__do_end()
        return v
    end,

    mmap_set = function(self, file, key)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_mmap_set(file, key)
        eo.__do_end()
    end,

    frame_vertex_data_set = function(self, frame, attrib, stride, data)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_frame_vertex_data_set(frame, attrib, stride, data)
        eo.__do_end()
    end,

    frame_vertex_data_copy_set = function(self, frame, attrib, stride, data)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_frame_vertex_data_copy_set(frame, attrib, stride, data)
        eo.__do_end()
    end,

    frame_vertex_data_map = function(self, frame, attrib)
        eo.__do_start(self, __class)
        local v = __lib.evas_3d_mesh_frame_vertex_data_map(frame, attrib)
        eo.__do_end()
        return v
    end,

    frame_vertex_data_unmap = function(self, frame, attrib)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_frame_vertex_data_unmap(frame, attrib)
        eo.__do_end()
    end,

    frame_vertex_stride_get = function(self, frame, attrib)
        eo.__do_start(self, __class)
        local v = __lib.evas_3d_mesh_frame_vertex_stride_get(frame, attrib)
        eo.__do_end()
        return tonumber(v)
    end,

    index_data_set = function(self, format, count, indices)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_index_data_set(format, count, indices)
        eo.__do_end()
    end,

    index_data_copy_set = function(self, format, count, indices)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_index_data_copy_set(format, count, indices)
        eo.__do_end()
    end,

    index_format_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.evas_3d_mesh_index_format_get()
        eo.__do_end()
        return v
    end,

    index_count_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.evas_3d_mesh_index_count_get()
        eo.__do_end()
        return tonumber(v)
    end,

    index_data_map = function(self)
        eo.__do_start(self, __class)
        local v = __lib.evas_3d_mesh_index_data_map()
        eo.__do_end()
        return v
    end,

    index_data_unmap = function(self)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_index_data_unmap()
        eo.__do_end()
    end,

    frame_add = function(self, frame)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_frame_add(frame)
        eo.__do_end()
    end,

    frame_del = function(self, frame)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_frame_del(frame)
        eo.__do_end()
    end,

    vertex_count_set = function(self, count)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_vertex_count_set(count)
        eo.__do_end()
    end,

    vertex_count_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.evas_3d_mesh_vertex_count_get()
        eo.__do_end()
        return tonumber(v)
    end,

    fog_color_set = function(self, r, g, b, a)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_fog_color_set(r, g, b, a)
        eo.__do_end()
    end,

    fog_color_get = function(self)
        eo.__do_start(self, __class)
        local r = ffi.new("Evas_Real[1]")
        local g = ffi.new("Evas_Real[1]")
        local b = ffi.new("Evas_Real[1]")
        local a = ffi.new("Evas_Real[1]")
        __lib.evas_3d_mesh_fog_color_get(r, g, b, a)
        eo.__do_end()
        return r[0], g[0], b[0], a[0]
    end,

    blending_func_set = function(self, sfactor, dfactor)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_blending_func_set(sfactor, dfactor)
        eo.__do_end()
    end,

    blending_func_get = function(self)
        eo.__do_start(self, __class)
        local sfactor = ffi.new("Evas_3D_Blend_Func[1]")
        local dfactor = ffi.new("Evas_3D_Blend_Func[1]")
        __lib.evas_3d_mesh_blending_func_get(sfactor, dfactor)
        eo.__do_end()
        return sfactor[0], dfactor[0]
    end,

    fog_enable_set = function(self, enabled)
        eo.__do_start(self, __class)
        __lib.evas_3d_mesh_fog_enable_set(enabled)
        eo.__do_end()
    end,

    fog_enable_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.evas_3d_mesh_fog_enable_get()
        eo.__do_end()
        return ((v) ~= 0)
    end,

    __properties = {
        ["shade_mode"] = { 0, 1, true, true },
        ["blending_enable"] = { 0, 1, true, true },
        ["vertex_assembly"] = { 0, 1, true, true },
        ["frame_material"] = { 1, 1, true, true }
    }
}

M.Evas_3D_Mesh = function(parent, ...)
    return eo.__ctor_common(__class, parent, eo.class_get("Evas_3D_Mesh").__eo_ctor,
                            1, ...)
end

return M
