/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp;

import java.io.File;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.ecpinfo.xml.BaseInformationType;
import org.tizen.ecp.ecpinfo.xml.CliTypes;
import org.tizen.ecp.ecpinfo.xml.ContentsType;
import org.tizen.ecp.ecpinfo.xml.ContentsTypes;
import org.tizen.ecp.ecpinfo.xml.ECPConfiguration;
import org.tizen.ecp.ecpinfo.xml.ListItemType;
import org.tizen.ecp.ecpinfo.xml.ListItemTypes;
import org.tizen.ecp.utils.JaxbUtil;

public class ECPInfo {
    private static ECPInfo instance = new ECPInfo();
    ECPConfiguration configuration = null;

    public static ECPInfo getInstance() {
        return instance;
    }

    public void initialize(String ecpInfoPath) throws JAXBException {
        JAXBElement<?> element = JaxbUtil.unmarshal(ecpInfoPath, ECPConfiguration.class);
        this.configuration = (ECPConfiguration)element.getValue();
    }

    public ECPConfiguration getConfiguration() {
        return this.configuration;
    }

    public BaseInformationType getBaseInfo() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.getBaseInformation();
    }

    public List<ListItemType> getListInfo() {
        if (this.configuration == null) {
            return null;
        }
        ListItemTypes listInfo = this.configuration.getListInformation();
        if (listInfo == null) {
            return null;
        }
        return listInfo.getListItem();
    }

    public boolean isInDeviceList(String name) {
        List<ListItemType> list = this.getListInfo();
        if (list == null) {
            return false;
        }
        for (ListItemType type : list) {
            if (!type.getDevice().equals(name)) continue;
            return true;
        }
        return false;
    }

    public List<String> getMonitorInfo() {
        if (this.configuration == null) {
            return null;
        }
        ListItemTypes listInfo = this.configuration.getListInformation();
        if (listInfo == null) {
            return null;
        }
        if (listInfo.getMonitorItem() == null) {
            return null;
        }
        return listInfo.getMonitorItem().getMonitor();
    }

    public List<String> getAppManagerInfo() {
        if (this.configuration == null) {
            return null;
        }
        ListItemTypes listInfo = this.configuration.getListInformation();
        if (listInfo == null) {
            return null;
        }
        if (listInfo.getAppItem() == null) {
            return null;
        }
        return listInfo.getAppItem().getApp();
    }

    public List<ContentsType> getContentsInfo() {
        if (this.configuration == null) {
            return null;
        }
        ContentsTypes content = this.configuration.getContentsInformation();
        if (content == null) {
            return null;
        }
        return content.getContentsItem();
    }

    public String getVersion() {
        BaseInformationType base = this.getBaseInfo();
        if (base == null) {
            return null;
        }
        return base.getECPVersion();
    }

    public List<CliTypes.Device> getCLIInfo() {
        if (this.configuration == null || this.configuration.getCLIInformation() == null) {
            return null;
        }
        return this.configuration.getCLIInformation().getDevice();
    }

    public String getJarPath() {
        String path = VMInfo.getInstance().getPluginPath() + File.separator + "ecp" + "-" + "plugin" + ".jar";
        return path;
    }
}

