/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sdb;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.sdb.IShellOutputReceiver;
import org.tizen.ecp.sdb.MultiLineReceiver;
import org.tizen.ecp.sdb.SDBCommandRejectedException;
import org.tizen.ecp.sdb.SDBNotExistException;
import org.tizen.ecp.sdb.ShellCommandUnresponsiveException;
import org.tizen.ecp.utils.FilePath;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.utils.OSUtil;

public class SDBHelperUtil {
    public static final byte[] ID_OKAY = "OKAY".getBytes();
    private static final int SDB_SERVER_PORT = 26099;
    private static final int TIMEOUT = 5000;
    private static final String SDB_HOST = "127.0.0.1";
    private static final String DEVICES = "devices";
    private static InetAddress sdbHostAddr;
    private static InetSocketAddress sdbSocketAddr;
    private static SDBHelperUtil instance;
    private static Logger logger;
    private static String PUSH;
    private static int portSdb;
    private static String serialNumber;
    private static String sdbPath;
    private static String sdbMacPath;
    private static String ansiconPath;
    private static boolean isInitialized;
    static final int WAIT_TIME = 5;
    static final String DEFAULT_ENCODING = "ISO-8859-1";
    public static final String UTF_DECODING = "UTF-8";
    public static final String OUTPUT_DECODING = "UTF-8";
    public static final Charset UTF_CHARSET;

    public static SDBHelperUtil getInstance() {
        return instance;
    }

    public static int getMaxTimeToRespond() {
        return 5000;
    }

    public static byte[] string2bytes(String str) throws UnsupportedEncodingException {
        return str.getBytes(UTF_CHARSET);
    }

    public static String bytes2string(byte[] bytes) {
        return new String(bytes, UTF_CHARSET);
    }

    public static byte[] formSdbRequest(String req) {
        try {
            byte[] reqByte = SDBHelperUtil.string2bytes(req);
            byte[] lengthByte = String.format("%04X", reqByte.length).getBytes();
            byte[] result = new byte[reqByte.length + 4];
            System.arraycopy(lengthByte, 0, result, 0, 4);
            System.arraycopy(reqByte, 0, result, 4, reqByte.length);
            return result;
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            return null;
        }
    }

    public static boolean check(byte[] bytes1, int start1, byte[] bytes2, int start2, int length) {
        if (null == bytes1 || start1 < 0 || bytes1.length < start1 + length) {
            return false;
        }
        if (null == bytes2 || start2 < 0 || bytes2.length < start2 + length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (bytes1[start1++] == bytes2[start2++]) continue;
            return false;
        }
        return true;
    }

    static SdbResponse readSdbResponse(SocketChannel chan) throws TimeoutException, IOException {
        int len;
        SdbResponse resp = new SdbResponse();
        byte[] reply = new byte[4];
        SDBHelperUtil.read(chan, reply);
        if (SDBHelperUtil.check(ID_OKAY, 0, reply, 0, 4)) {
            resp.okay = true;
            return resp;
        }
        resp.okay = false;
        byte[] lenBuf = new byte[4];
        SDBHelperUtil.read(chan, lenBuf);
        String lenStr = SDBHelperUtil.replyToString(lenBuf);
        try {
            len = Integer.parseInt(lenStr, 16);
        }
        catch (NumberFormatException nfe) {
            logger.warning("Expected digits, got '" + lenStr + "': " + lenBuf[0] + " " + lenBuf[1] + " " + lenBuf[2] + " " + lenBuf[3]);
            logger.warning("reply was " + SDBHelperUtil.replyToString(reply));
            return resp;
        }
        byte[] msg = new byte[len];
        SDBHelperUtil.read(chan, msg);
        resp.message = SDBHelperUtil.replyToString(msg);
        logger.info("Got reply '" + SDBHelperUtil.replyToString(reply) + "', diag='" + resp.message + "'");
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createForward(int localPort, int remotePort) throws TimeoutException, SDBCommandRejectedException, IOException {
        try (SocketChannel sdbChan = null;){
            sdbChan = SocketChannel.open(sdbSocketAddr);
            byte[] request = SDBHelperUtil.formSdbRequest(String.format("host-serial:%1$s:forward:tcp:%2$d;tcp:%3$d", SDBHelperUtil.getSerialNumber(), localPort, remotePort));
            SDBHelperUtil.write(sdbChan, request);
            SdbResponse resp = SDBHelperUtil.readSdbResponse(sdbChan);
            if (!resp.okay) {
                logger.severe("Error creating forward: " + resp.message);
                throw new SDBCommandRejectedException(resp.message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeForward(int localPort, int remotePort) throws TimeoutException, SDBCommandRejectedException, IOException {
        try (SocketChannel sdbChan = null;){
            sdbChan = SocketChannel.open(sdbSocketAddr);
            byte[] request = SDBHelperUtil.formSdbRequest(String.format("host-serial:%1$s:killforward:tcp:%2$d;tcp:%3$d", SDBHelperUtil.getSerialNumber(), localPort, remotePort));
            SDBHelperUtil.write(sdbChan, request);
            SdbResponse resp = SDBHelperUtil.readSdbResponse(sdbChan);
            if (!resp.okay) {
                logger.severe("Error creating forward: " + resp.message);
                throw new SDBCommandRejectedException(resp.message);
            }
        }
    }

    static void setDevice(SocketChannel sdbChan, String serialNumber) throws TimeoutException, IOException {
        String msg = "host:transport:" + serialNumber;
        byte[] device_query = SDBHelperUtil.formSdbRequest(msg);
        SDBHelperUtil.write(sdbChan, device_query);
        SdbResponse resp = SDBHelperUtil.readSdbResponse(sdbChan);
        if (!resp.okay) {
            throw new SDBCommandRejectedException(resp.message);
        }
    }

    public static void tryClose(Closeable obj) {
        if (null == obj) {
            return;
        }
        try {
            obj.close();
        }
        catch (IOException e) {
            logger.severe("failed to close :" + e);
        }
    }

    public static void notNull(Object obj) {
        SDBHelperUtil.notNull(obj, "Object must NOT be null");
    }

    public static void notNull(Object obj, String msg) {
        SDBHelperUtil.isFalse(null == obj, msg);
    }

    public static void isFalse(boolean exp, String msg) {
        if (!exp) {
            return;
        }
        SDBHelperUtil.fail(msg);
    }

    public static void fail(Object msg) {
        if (msg instanceof String) {
            throw new IllegalArgumentException((String)msg);
        }
        if (null != msg) {
            throw new IllegalArgumentException(msg.toString());
        }
    }

    protected void sendRequest(SocketChannel channel, String command) throws IOException, TimeoutException {
        SDBHelperUtil.setDevice(channel, SDBHelperUtil.getSerialNumber());
        byte[] request = SDBHelperUtil.formSdbRequest("shell:" + command);
        SDBHelperUtil.write(channel, request);
        SdbResponse resp = SDBHelperUtil.readSdbResponse(channel);
        if (!resp.okay) {
            logger.severe("sdb rejected shell command (" + command + "): " + resp.message);
            throw new SDBCommandRejectedException(resp.message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeRemoteCommand(InetSocketAddress sdbSockAddr, String command, IShellOutputReceiver receiver) throws TimeoutException, IOException, SDBCommandRejectedException {
        SocketChannel channel;
        SDBHelperUtil.notNull(receiver);
        try {
            channel = SocketChannel.open(sdbSockAddr);
        }
        catch (IOException e) {
            isInitialized = false;
            this.initServer();
            channel = SocketChannel.open(sdbSockAddr);
        }
        try {
            channel.configureBlocking(false);
            channel.configureBlocking(SDBHelperUtil.getMaxTimeToRespond() <= 0);
            this.sendRequest(channel, command);
            byte[] data = new byte[16384];
            ByteBuffer buf = ByteBuffer.wrap(data);
            int timeToResponseCount = 0;
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            while (true) {
                if (receiver != null && receiver.isCancelled()) {
                    logger.info("execute: cancelled");
                    break;
                }
                int count = channel.read(buf);
                if (count < 0) {
                    if (receiver != null) {
                        receiver.flush();
                    }
                    break;
                }
                if (count == 0) {
                    try {
                        int wait = 25;
                        int maxTimeToRespond = SDBHelperUtil.getMaxTimeToRespond();
                        if (maxTimeToRespond > 0 && (timeToResponseCount += wait) > maxTimeToRespond) {
                            throw new ShellCommandUnresponsiveException();
                        }
                        Thread.sleep(wait);
                    }
                    catch (InterruptedException ie) {}
                    continue;
                }
                timeToResponseCount = 0;
                if (receiver != null) {
                    byteOut.write(buf.array(), buf.arrayOffset(), buf.position());
                    try {
                        receiver.append(SDBHelperUtil.bytes2string(byteOut.toByteArray()));
                    }
                    catch (Exception e) {
                        receiver.append(new String(byteOut.toByteArray()));
                    }
                    byteOut.reset();
                }
                buf.rewind();
            }
        }
        catch (ClosedChannelException e) {
            logger.warning(e.getMessage());
        }
        finally {
            SDBHelperUtil.tryClose(channel);
            SDBHelperUtil.tryClose(receiver);
        }
    }

    static boolean isOkay(byte[] reply) {
        return reply[0] == 79 && reply[1] == 75 && reply[2] == 65 && reply[3] == 89;
    }

    static String replyToString(byte[] reply) {
        String result;
        try {
            result = new String(reply, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            result = "";
        }
        return result;
    }

    static void read(SocketChannel chan, byte[] data) throws IOException, TimeoutException {
        SDBHelperUtil.read(chan, data, -1, SDBHelperUtil.getMaxTimeToRespond());
    }

    static void read(SocketChannel chan, byte[] data, int length, int timeout) throws IOException, TimeoutException {
        ByteBuffer buf = ByteBuffer.wrap(data, 0, 0 <= length ? length : data.length);
        long startTime = System.currentTimeMillis();
        while (buf.position() != buf.limit()) {
            int count = chan.read(buf);
            if (count < 0) {
                throw new EOFException();
            }
            if (count == 0) {
                if (0 < timeout && System.currentTimeMillis() - startTime > (long)timeout) {
                    logger.severe("read: timeout");
                    throw new TimeoutException();
                }
                SDBHelperUtil.trySleep(5L);
                continue;
            }
            startTime = System.currentTimeMillis();
        }
    }

    static void write(SocketChannel chan, byte[] data) throws TimeoutException, IOException {
        SDBHelperUtil.write(chan, data, -1, SDBHelperUtil.getMaxTimeToRespond());
    }

    static void write(SocketChannel chan, byte[] data, int length, int timeout) throws TimeoutException, IOException {
        ByteBuffer buf = ByteBuffer.wrap(data, 0, length != -1 ? length : data.length);
        int numWaits = 0;
        while (buf.position() != buf.limit()) {
            int count = chan.write(buf);
            if (count < 0) {
                throw new IOException("channel EOF");
            }
            if (count == 0) {
                if (timeout != 0 && numWaits * 5 > timeout) {
                    throw new TimeoutException();
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                ++numWaits;
                continue;
            }
            numWaits = 0;
        }
    }

    public boolean checkFile() {
        File sdbFile = OSUtil.isMacPlatform() ? new File(sdbMacPath) : new File(sdbPath);
        if (!sdbFile.exists()) {
            logger.log(Level.INFO, "SDB file does not exist : " + sdbFile.getAbsolutePath());
            logger.info("check file: false");
            return false;
        }
        logger.info("check file: true");
        return true;
    }

    public void rootOn() {
        ProcessBuilder procSdb = new ProcessBuilder(new String[0]);
        logger.info("sdb root on");
        if (OSUtil.isMacPlatform()) {
            procSdb.command(sdbMacPath, "-s", serialNumber, "root", "on");
        } else {
            procSdb.command(sdbPath, "-s", serialNumber, "root", "on");
        }
        logger.log(Level.INFO, procSdb.command().toString());
        try {
            Process p = procSdb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                logger.info(line);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void initServer() throws SDBNotExistException {
        if (isInitialized) {
            return;
        }
        if (this.checkFile()) {
            try {
                sdbHostAddr = InetAddress.getByName(SDB_HOST);
                sdbSocketAddr = new InetSocketAddress(sdbHostAddr, 26099);
            }
            catch (UnknownHostException e1) {
                System.out.println("init socket failed" + e1);
            }
            ProcessBuilder procSdb = new ProcessBuilder(new String[0]);
            if (OSUtil.isMacPlatform()) {
                procSdb.command(sdbMacPath, DEVICES);
            } else {
                procSdb.command(sdbPath, DEVICES);
            }
            logger.log(Level.INFO, procSdb.command().toString());
            try {
                Process p = procSdb.start();
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    logger.info(line);
                    if (line.contains(serialNumber) && line.contains("device")) {
                        isInitialized = true;
                        logger.info("find " + serialNumber + " is running!");
                        logger.info("sdb is initialized.");
                        return;
                    }
                    logger.info("sdb is not initialized.");
                    isInitialized = false;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                isInitialized = false;
            }
            return;
        }
        throw new SDBNotExistException("SDB is not exist!");
    }

    public boolean launch() throws IOException {
        ProcessBuilder procSdb = new ProcessBuilder(new String[0]);
        if (OSUtil.isLinuxPlatform()) {
            procSdb.command("/usr/bin/gnome-terminal", "--disable-factory", "--title=" + serialNumber, "-x", sdbPath, "-s", serialNumber, "shell");
        } else if (OSUtil.isWindowsPlatform()) {
            procSdb.command("cmd.exe", "/c", "start", ansiconPath, "sdb", "-s", serialNumber, "shell");
        } else if (OSUtil.isMacPlatform()) {
            procSdb.command(sdbPath, serialNumber);
        } else {
            logger.log(Level.SEVERE, "not a supported OS.");
            return false;
        }
        logger.log(Level.INFO, procSdb.command().toString());
        procSdb.start();
        return true;
    }

    public static void trySleep(long milliseconds) {
        if (milliseconds <= 0L) {
            return;
        }
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void executeShellCommand(String cmd, IShellOutputReceiver receiver) throws SDBCommandRejectedException, IOException, TimeoutException {
        logger.info("execute: running " + cmd);
        this.initServer();
        this.executeRemoteCommand(sdbSocketAddr, cmd, receiver);
    }

    public void executeShellRootCommand(String cmd, IShellOutputReceiver receiver) throws SDBCommandRejectedException, IOException, TimeoutException {
        logger.info("execute: running " + cmd);
        this.initServer();
        this.rootOn();
        this.executeRemoteCommand(sdbSocketAddr, cmd, receiver);
    }

    public void closeMultiLineReceiver(MultiLineReceiver receiver) {
        if (receiver != null) {
            try {
                receiver.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            receiver = null;
        }
    }

    public static boolean push(String source, String destination) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(sdbPath);
        command.add(PUSH);
        command.add(source);
        command.add(destination);
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder(command);
            logger.info("push args: " + pb.command());
            Process process = pb.start();
            BufferedReader output = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = output.readLine()) != null) {
                logger.info("process output: " + line);
            }
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                return false;
            }
        }
        catch (IOException e) {
            logger.info("IOException" + e.getMessage() + StringResources.NEW_LINE);
            return false;
        }
        catch (InterruptedException e) {
            logger.info("InterruptedException" + e.getMessage() + StringResources.NEW_LINE);
            return false;
        }
        catch (Exception e) {
            logger.info("Exception" + e.getMessage() + StringResources.NEW_LINE);
            return false;
        }
        return true;
    }

    public InetSocketAddress getSocketAddress() {
        return sdbSocketAddr;
    }

    public static String getSerialNumber() {
        return serialNumber;
    }

    static {
        instance = new SDBHelperUtil();
        logger = LogUtil.getECPLogger(SDBHelperUtil.class).getLogger();
        PUSH = "push";
        portSdb = VMInfo.getInstance().getSdbPort();
        serialNumber = "emulator-" + (portSdb + 1);
        sdbPath = FilePath.getInstance().getSdbFilePath();
        sdbMacPath = FilePath.getInstance().getSdbMacFilePath();
        ansiconPath = FilePath.getInstance().getAnsiconFilePath();
        isInitialized = false;
        UTF_CHARSET = Charset.forName("UTF-8");
    }

    static class SdbResponse {
        public boolean okay;
        public String message = "";
    }
}

