/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class CLIPath {
    private static String ecpPath;
    private static String etcPath;
    private static String sdkPath;
    private static String sdkDataPath;
    private static String emulatorRootPath;
    private static String VERSION_SUFFIX;
    private static final String etc_suffix;
    private static final String FILE_PARENT;
    private static final String sdkinfo_suffix;
    public static final String VM_NAME = "vmname";
    static CLIPath instance;

    private static String findSDKDataPath() {
        String dataPath = null;
        File sdkInfoFile = new File(ecpPath + FILE_PARENT + FILE_PARENT + FILE_PARENT + sdkinfo_suffix);
        if (sdkInfoFile.exists()) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(sdkInfoFile));
            }
            catch (FileNotFoundException e) {
                System.out.println(e.getMessage());
            }
            String s = null;
            try {
                while ((s = in.readLine()) != null) {
                    int i = s.indexOf("=");
                    if (i == -1) continue;
                    String s1 = s.substring(0, i);
                    String s2 = s.substring(i + 1, s.length());
                    if (s1.equals("TIZEN_SDK_INSTALLED_PATH")) {
                        sdkPath = s2;
                        continue;
                    }
                    if (!s1.equals("TIZEN_SDK_DATA_PATH")) continue;
                    dataPath = s2;
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            try {
                in.close();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return dataPath;
    }

    public static CLIPath getInstance() {
        return instance;
    }

    public String getEcpPath() {
        return ecpPath;
    }

    public String getEtcPath() {
        return etcPath;
    }

    public String getSDKPath() {
        return sdkPath;
    }

    public String getSDKDataPath() {
        return sdkDataPath;
    }

    public String getVersionPath() {
        return etcPath + VERSION_SUFFIX;
    }

    public String getEmulatorRootPath() {
        return emulatorRootPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        VERSION_SUFFIX = File.separator + "version";
        etc_suffix = File.separator + "etc";
        FILE_PARENT = File.separator + "..";
        sdkinfo_suffix = File.separator + "sdk.info";
        File jar = null;
        String BinPath = null;
        BinPath = CLIPath.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (BinPath != null) {
            jar = new File(BinPath);
            ecpPath = jar.getParent();
            sdkDataPath = CLIPath.findSDKDataPath();
            emulatorRootPath = ecpPath + FILE_PARENT;
            try {
                etcPath = new File(ecpPath + FILE_PARENT).getCanonicalPath().toString() + etc_suffix;
            }
            catch (IOException e) {
                etcPath = ecpPath + FILE_PARENT + etc_suffix;
            }
        } else {
            System.out.println("bin path is null.");
        }
        Class<CLIPath> clazz = CLIPath.class;
        synchronized (CLIPath.class) {
            instance = new CLIPath();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

