/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli.commands;

import java.lang.annotation.Annotation;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.args4j.spi.SubCommand;
import org.kohsuke.args4j.spi.SubCommands;
import org.tizen.cli.CLIManager;
import org.tizen.cli.monitor.KeyCodeCLI;
import org.tizen.cli.monitor.TizenEmulatorHMP;
import org.tizen.cli.monitor.TizenEmulatorHelp;
import org.tizen.cli.monitor.TizenEmulatorQMP;
import org.tizen.cli.monitor.hds.HDSCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.ecpinfo.xml.CliTypes;

public class EmulatorCommandsHandler
extends OptionHandler<Object> {
    private final SubCommands commands = this.getCommands();
    private static final int MAX_COMMANDS = 50;

    public EmulatorCommandsHandler(CmdLineParser parser, OptionDef option, Setter<Object> setter) {
        super(parser, option, setter);
        if (this.commands == null) {
            throw new IllegalStateException("SubCommandHandler must be used with @SubCommands annotation");
        }
    }

    private static SubCommand createCommand(final String name, final Class<?> impl) {
        SubCommand cmd = new SubCommand(){

            public Class<? extends Annotation> annotationType() {
                return SubCommand.class;
            }

            public String name() {
                return name;
            }

            public Class<?> impl() {
                return impl;
            }
        };
        return cmd;
    }

    private SubCommands getCommands() {
        SubCommands subCmds = new SubCommands(){
            private int index = 0;

            public Class<? extends Annotation> annotationType() {
                return SubCommand.class;
            }

            public SubCommand[] value() {
                SubCommand sHdsCmd;
                SubCommand sKeyCmd;
                SubCommand sHMPCmd;
                SubCommand sQMPCmd;
                SubCommand sHelpCmd;
                int size = 0;
                final List deviceList = ECPInfo.getInstance().getCLIInfo();
                size = deviceList == null ? 0 : deviceList.size();
                SubCommand[] sCmdArray = new SubCommand[size + 6];
                while (this.index < size && this.index < 50) {
                    SubCommand sCmd;
                    sCmdArray[this.index] = sCmd = new SubCommand(){
                        int i;
                        {
                            this.i = index;
                        }

                        public Class<? extends Annotation> annotationType() {
                            return SubCommand.class;
                        }

                        public String name() {
                            String name = null;
                            if (deviceList != null && deviceList.get(this.i) != null) {
                                name = ((CliTypes.Device)deviceList.get(this.i)).getName();
                            }
                            return name;
                        }

                        public Class<?> impl() {
                            Class<?> dClass = null;
                            if (deviceList != null && deviceList.get(this.i) != null) {
                                dClass = CLIManager.getInstance().getClass(((CliTypes.Device)deviceList.get(this.i)).getImpl());
                            }
                            return dClass;
                        }
                    };
                    ++this.index;
                }
                sCmdArray[this.index] = sHelpCmd = EmulatorCommandsHandler.createCommand("help", TizenEmulatorHelp.class);
                ++this.index;
                sCmdArray[this.index] = sQMPCmd = EmulatorCommandsHandler.createCommand("qmp", TizenEmulatorQMP.class);
                ++this.index;
                sCmdArray[this.index] = sHMPCmd = EmulatorCommandsHandler.createCommand("hmp", TizenEmulatorHMP.class);
                ++this.index;
                sCmdArray[this.index] = sKeyCmd = EmulatorCommandsHandler.createCommand("keycode", KeyCodeCLI.class);
                ++this.index;
                sCmdArray[this.index] = sHdsCmd = EmulatorCommandsHandler.createCommand("hds", HDSCLI.class);
                return sCmdArray;
            }
        };
        return subCmds;
    }

    public String getDefaultMetaVariable() {
        return "CMD ARGS...";
    }

    public int parseArguments(Parameters params) throws CmdLineException {
        String subCmd = params.getParameter(0);
        for (SubCommand c : this.commands.value()) {
            if (c.name() == null) {
                OutputUtil.debug("parseArguments: c.name() is null");
                continue;
            }
            if (!c.name().equals(subCmd)) continue;
            this.setter.addValue(this.subCommand(c, params));
            return params.size();
        }
        return this.fallback(subCmd);
    }

    protected int fallback(String subCmd) throws CmdLineException {
        throw new CmdLineException(this.owner, subCmd);
    }

    protected Object subCommand(SubCommand c, final Parameters params) throws CmdLineException {
        Object subCmd = this.instantiate(c);
        CmdLineParser p = this.configureParser(subCmd, c);
        p.parseArgument((Collection)new AbstractList<String>(){

            @Override
            public String get(int index) {
                try {
                    return params.getParameter(index + 1);
                }
                catch (CmdLineException e) {
                    throw new IndexOutOfBoundsException();
                }
            }

            @Override
            public int size() {
                return params.size() - 1;
            }
        });
        return subCmd;
    }

    protected CmdLineParser configureParser(Object subCmd, SubCommand c) {
        CmdLineParser parser = new CmdLineParser(subCmd);
        parser.stopOptionParsing();
        return new CmdLineParser(subCmd);
    }

    protected Object instantiate(SubCommand c) {
        if (c == null || c.impl() == null) {
            return null;
        }
        try {
            return CLIManager.getInstance().getInstantiateClass(c.impl().getCanonicalName());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Failed to instantiate " + c, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to instantiate " + c, e);
        }
    }
}

