/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tizen.ecp.utils.LogUtil;

public class About {
    private static About instance = new About();
    private static Logger logger = LogUtil.getECPLogger(About.class).getLogger();
    private String ecpVersion = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private About() {
        ClassLoader loader = null;
        try {
            loader = this.getClass().getClassLoader();
        }
        catch (NoClassDefFoundError e) {
            logger.log(Level.INFO, "class not found", e);
            return;
        }
        if (loader == null) {
            return;
        }
        InputStream in = loader.getResourceAsStream("about.properties");
        Properties properties = new Properties();
        if (in != null) {
            try {
                properties.load(in);
                this.ecpVersion = properties.getProperty("ecp-version");
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.getMessage());
                }
            }
        }
    }

    public static About getInstance() {
        return instance;
    }

    public String getECPVersion() {
        return this.ecpVersion;
    }
}

