/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.exception.ArgumentException;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.sock.SocketClient;
import org.tizen.ecp.socket.SocketMessage;
import org.tizen.ecp.utils.About;
import org.tizen.ecp.utils.CocoaUtil;
import org.tizen.ecp.utils.FilePath;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.utils.MacUtil;
import org.tizen.ecp.utils.SwtUtil;
import org.tizen.ecp.views.ECPMainView;

public class EmulatorControlPanel {
    private static Logger logger;
    public static int svrPort;
    private static Display display;
    private static Shell shell;
    private static RandomAccessFile randomAccessFile;
    private static final String FILE_NAME = "emulator-control-panel.log";

    private static Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            logger.info("arg[" + i + "] " + arg);
            String[] split = arg.split("=");
            if (1 < split.length) {
                String argKey = split[0].trim();
                String argValue = split[1].trim();
                map.put(argKey, argValue);
                continue;
            }
            logger.info("sinlge argv:" + arg);
        }
        logger.info("================= argsMap =====================");
        logger.info(((Object)map).toString());
        logger.info("===============================================");
        return map;
    }

    public static void validateArgs(Map<String, String> args) throws ArgumentException {
        if (null == args) {
            return;
        }
        if (args.containsKey("vmname")) {
            String name = args.get("vmname");
            if (name == null) {
                throw new ArgumentException("vmnamehas no argument");
            }
        } else {
            String msg = "vmname is required.\n";
            throw new ArgumentException(msg);
        }
        if (args.containsKey("base.port")) {
            String strPort = args.get("base.port");
            try {
                int intPort = Integer.parseInt(strPort);
                if (intPort == 0) {
                    throw new ArgumentException("base.porthas no argument");
                }
                svrPort = intPort + 3;
                logger.info("svrPort: " + svrPort + ", basePort: " + strPort);
            }
            catch (NumberFormatException e) {
                String msg = "base.port argument is not numeric. : " + strPort;
                throw new ArgumentException(msg);
            }
        } else {
            String msg = "base.port is required.\n";
            throw new ArgumentException(msg);
        }
    }

    private void setVMInfo(Map<String, String> argsMap) {
        int basePort = 0;
        String vmName = null;
        if (argsMap.containsKey("vmname")) {
            vmName = argsMap.get("vmname");
        }
        if (argsMap.containsKey("base.port")) {
            basePort = Integer.parseInt(argsMap.get("base.port"));
        }
        try {
            VMInfo.getInstance().initialize(vmName, basePort);
        }
        catch (JAXBException e) {
            String path = FilePath.getInstance().getVmsPath() + File.separator + vmName + File.separator + "vm_config.xml";
            EmulatorControlPanel.openDialog("device xml loading is failed.\nplease check " + path + " for xml configuration.");
            logger.warning("Can not load xml file( " + path + ")\n" + e.getMessage());
            EmulatorControlPanel.exit(-1);
        }
    }

    private static String getVmName(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            String[] split = arg.split("=");
            if (1 >= split.length || !"vmname".equals(split[0].trim())) continue;
            return split[1].trim();
        }
        return null;
    }

    private static void openDialog(String msg) {
        MessageDialog dialog = new MessageDialog(shell);
        dialog.openInfoDialog(msg);
    }

    public static void exit(int status) {
        System.exit(status);
    }

    public static void main(String[] args) {
        int ret = 0;
        display = new Display();
        shell = new Shell(display);
        Display.setAppName((String)"Emulator Control Panel");
        EmulatorControlPanel ecp = new EmulatorControlPanel();
        ret = ecp.run(args);
        EmulatorControlPanel.exit(ret);
    }

    public int run(String[] args) {
        String vmName;
        MacUtil.setProperty();
        if (SwtUtil.isMacPlatform()) {
            Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    new CocoaUtil().removeTopMenuItems();
                }
            });
        }
        if (StringResources.isEmpty(vmName = EmulatorControlPanel.getVmName(args))) {
            EmulatorControlPanel.openDialog("Reqired arguments are missing.\nPlease run ecp with vmname and base.port arguments.");
            return -1;
        }
        try {
            LogUtil.init(LogUtil.ECPLogLevel.DEBUG, vmName, FILE_NAME, false);
        }
        catch (IOException e) {
            String logPath = FilePath.getInstance().getDataLogPath(vmName) + File.separator + FILE_NAME;
            EmulatorControlPanel.openDialog("Can not launch Emulator Control Panel.\n" + e.getMessage() + "\n sdk log path:" + logPath);
            return -1;
        }
        logger = LogUtil.getECPLogger(EmulatorControlPanel.class).getLogger();
        logger.info("!!! Start Emulator Control Panel !!!");
        logger.info("ECP version : " + About.getInstance().getECPVersion());
        String lockPath = FilePath.getInstance().getVmsPath() + File.separator + vmName + File.separator + System.getProperty("user.name") + ".lock";
        try {
            randomAccessFile = new RandomAccessFile(new File(lockPath), "rw");
            FileLock lock = randomAccessFile.getChannel().tryLock();
            if (lock == null) {
                EmulatorControlPanel.openDialog("Can not launch Emulator Control Panel." + StringResources.NEW_LINE + "Another one with the same user name is running now.");
                return -1;
            }
        }
        catch (FileNotFoundException e) {
            logger.severe("Throw exception: " + e.getMessage());
            return -1;
        }
        catch (IOException e) {
            EmulatorControlPanel.openDialog("Can not launch Emulator Control Panel." + StringResources.NEW_LINE + e.getMessage());
            logger.severe("IOException: " + e.getMessage() + "\n" + lockPath);
            return -1;
        }
        Map<String, String> argsMap = EmulatorControlPanel.parseArgs(args);
        try {
            EmulatorControlPanel.validateArgs(argsMap);
        }
        catch (Throwable e) {
            EmulatorControlPanel.openDialog("Option parameter is not proper. Aborting..." + StringResources.NEW_LINE + e.getMessage() + StringResources.NEW_LINE + "See right examples below." + StringResources.NEW_LINE + "[ " + "vmname" + "=name " + "base.port" + "=26100 ]" + StringResources.NEW_LINE);
            return -1;
        }
        this.setVMInfo(argsMap);
        String ecpInfoPath = VMInfo.getInstance().getPluginPath() + File.separator + "ecp" + "-" + "plugin" + ".xml";
        logger.info("ecpInfoPath: " + ecpInfoPath);
        try {
            ECPInfo.getInstance().initialize(ecpInfoPath);
        }
        catch (JAXBException e) {
            EmulatorControlPanel.openDialog("device xml loading is failed.\nplease check " + ecpInfoPath + " for xml configuration.");
            logger.severe("Can not load xml file( " + ecpInfoPath + ")\n" + e.getMessage());
            return -1;
        }
        if (!SocketClient.getInstance().connect(svrPort)) {
            EmulatorControlPanel.openDialog("Connection to Emulator is failed. Please check " + svrPort + " port." + StringResources.NEW_LINE);
            return -1;
        }
        new Thread(null, new SocketMessage(), "Socket Message Thread").start();
        try {
            new ECPMainView().openMainWindow(display);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Internal error occured.", e);
            EmulatorControlPanel.openDialog("Internal error occured.\nPlease run ECP again.");
            EmulatorControlPanel.exit(-1);
            return -1;
        }
        return 0;
    }

    static {
        svrPort = 0;
    }

    public static interface ArgsConstants {
        public static final String BASEPORT = "base.port";
        public static final String VMNAME = "vmname";
    }
}

