/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.device;

import com.google.protobuf.GeneratedMessage;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.json.simple.JSONObject;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.FontResources;
import org.tizen.ecp.resources.ImageResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.utils.JsonUtil;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPSubView;
import org.tizen.ecp.views.VMView;
import org.tizen.ecp.widgets.ECPButton;

public class NetworkDisplay
extends ECPSubView
implements ILsn {
    private static Logger logger = LogUtil.getECPLogger(NetworkDisplay.class).getLogger();
    private final String CMD_NETWORK = "info network";
    private final String CMD_USERNET = "info usernet";
    private Table deviceTable = null;
    private Table networkTable = null;
    private Font font = FontResources.FONT_9.getFont();
    private Font addrFont = FontResources.FONT_8.getFont();
    private Font labelFont = FontResources.FONT_11.getFont();
    private Composite uComp = null;
    private Composite fComp = null;
    private boolean portForwardOn = false;
    private ECPButton addNetworkDeviceBtn;
    private Combo net = null;
    private Text dIPAddr = null;
    private Text dIPPort = null;
    private Text sIPPort = null;
    private KeyAdapter portKeyAdapter = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            if (NetworkDisplay.this.isPortsFilled()) {
                NetworkDisplay.this.addNetworkDeviceBtn.setText("Apply port-forwarding");
            } else {
                NetworkDisplay.this.addNetworkDeviceBtn.setText("Cancel port-forwarding");
            }
        }
    };
    private Image tipImg = ImageResources.BALLOON_TIP.getImage();
    private PaintListener forwardPaintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            Composite bg = (Composite)e.widget;
            Rectangle rect = bg.getClientArea();
            rect.y += 4;
            --rect.width;
            rect.height -= 6;
            e.gc.setBackground(ColorResources.NETWORK_FORWARD.getColor());
            e.gc.fillRectangle(rect);
            e.gc.setForeground(ColorResources.BUTTON_BG_LINE.getColor());
            e.gc.drawRectangle(rect);
            e.gc.drawImage(NetworkDisplay.this.tipImg, rect.width - 100, 0);
        }
    };
    private SelectionAdapter addPortForwardListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            GridData gd = (GridData)NetworkDisplay.this.fComp.getLayoutData();
            if (NetworkDisplay.this.portForwardOn) {
                if (!NetworkDisplay.this.sIPPort.getText().isEmpty() && !NetworkDisplay.this.dIPPort.getText().isEmpty()) {
                    NetworkDisplay.this.handleForward();
                    NetworkDisplay.this.cleartextBoxes();
                }
                gd.heightHint = 0;
                NetworkDisplay.this.portForwardOn = false;
                NetworkDisplay.this.addNetworkDeviceBtn.setText("Add port-forwarding");
            } else {
                gd.heightHint = 41;
                NetworkDisplay.this.portForwardOn = true;
                NetworkDisplay.this.addNetworkDeviceBtn.setText("Cancel port-forwarding");
                NetworkDisplay.this.cleartextBoxes();
            }
            NetworkDisplay.this.fComp.setLayoutData((Object)gd);
            NetworkDisplay.this.fComp.getParent().getParent().layout();
        }
    };
    private SelectionAdapter addRefreshNetworkListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MessageSender.getInstance().sendMonitorReq(NetworkDisplay.this.createUsernetMsg());
        }
    };
    private final String HUB_INDICATOR = "hub ";
    private final String VLAN_INDICATOR = "VLAN ";
    private final String PROTOCOL_INDICATOR = "Protocol[State]";

    public NetworkDisplay() {
        this.title = "Network";
        this.pageHeight = 510;
    }

    @Override
    public void createView(Composite composite) {
        Composite comp = new Composite(composite, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginBottom = 5;
        gl.marginWidth = 12;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(1808));
        Composite tComp = new Composite(comp, 0);
        GridLayout listGl = new GridLayout(1, false);
        listGl.marginWidth = 0;
        tComp.setLayout((Layout)listGl);
        tComp.setLayoutData((Object)new GridData(768));
        Label label = new Label(tComp, 0);
        label.setText("Device List");
        GridData gLabel = new GridData(1);
        gLabel.verticalAlignment = 0x1000000;
        gLabel.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gLabel);
        label.setFont(this.labelFont);
        label.setForeground(ColorResources.TEXT_GREEN.getColor());
        this.deviceTable = new Table(comp, 2304);
        this.deviceTable.setFont(this.font);
        GridData dtGd = new GridData(768);
        dtGd.heightHint = 163;
        dtGd.widthHint = 479;
        this.deviceTable.setLayoutData((Object)dtGd);
        for (deviceHList list : deviceHList.values()) {
            TableColumn column = new TableColumn(this.deviceTable, 16384);
            column.setWidth(list.size);
            column.setText(list.name);
        }
        this.deviceTable.setHeaderVisible(true);
        Composite bComp = new Composite(comp, 0);
        GridLayout bGl = new GridLayout(1, true);
        bGl.marginWidth = 0;
        bGl.marginHeight = 0;
        bGl.marginTop = 0;
        bGl.verticalSpacing = 0;
        bComp.setLayout((Layout)bGl);
        bComp.setLayoutData((Object)new GridData(768));
        this.uComp = new Composite(bComp, 0);
        GridLayout unGl = new GridLayout(3, false);
        unGl.marginWidth = 0;
        unGl.marginHeight = 0;
        this.uComp.setLayout((Layout)unGl);
        GridData unGD = new GridData(768);
        unGD.verticalIndent = 10;
        unGD.heightHint = 22;
        this.uComp.setLayoutData((Object)unGD);
        Label unlabel = new Label(this.uComp, 0);
        unlabel.setText("User Network Information");
        GridData unLabel = new GridData(1);
        unLabel.verticalAlignment = 0x1000000;
        unLabel.grabExcessHorizontalSpace = true;
        unlabel.setLayoutData((Object)unLabel);
        unlabel.setFont(this.labelFont);
        unlabel.setForeground(ColorResources.TEXT_GREEN.getColor());
        this.addNetworkDeviceBtn = new ECPButton(this.uComp, 0);
        this.addNetworkDeviceBtn.setText("Add port-forwarding");
        this.addNetworkDeviceBtn.setFont(this.font);
        GridData andGd = new GridData(3);
        andGd.widthHint = 152;
        this.addNetworkDeviceBtn.setLayoutData(andGd);
        this.addNetworkDeviceBtn.addSelectionListener((SelectionListener)this.addPortForwardListener);
        ECPButton refreshNetworkDeviceBtn = new ECPButton(this.uComp, 8);
        Image HoverBtn = ImageResources.REFRESH_HOVER.getImage();
        Image PushBtn = ImageResources.REFRESH_PUSH.getImage();
        Image NmlBtn = ImageResources.REFRESH_NML.getImage();
        Image DisBtn = ImageResources.REFRESH_DISABLE.getImage();
        refreshNetworkDeviceBtn.setImages(NmlBtn, HoverBtn, PushBtn, PushBtn, DisBtn, HoverBtn);
        GridData refreshGd = new GridData(3);
        refreshGd.widthHint = 18;
        refreshGd.verticalIndent = 3;
        refreshNetworkDeviceBtn.setLayoutData(refreshGd);
        refreshNetworkDeviceBtn.addSelectionListener((SelectionListener)this.addRefreshNetworkListener);
        this.fComp = new Composite(bComp, 0);
        GridLayout fGl = new GridLayout(7, false);
        fGl.marginWidth = 0;
        fGl.marginHeight = 0;
        fGl.marginTop = 0;
        fGl.marginRight = 5;
        fGl.horizontalSpacing = 2;
        this.fComp.setLayout((Layout)fGl);
        GridData fgd = new GridData(768);
        fgd.heightHint = 0;
        this.fComp.setLayoutData((Object)fgd);
        this.fComp.addPaintListener(this.forwardPaintListener);
        this.createForwardComposite(this.fComp);
        this.networkTable = new Table(comp, 2304);
        this.networkTable.setFont(this.font);
        GridData unGd = new GridData(768);
        unGd.heightHint = 163;
        unGd.widthHint = 479;
        this.networkTable.setLayoutData((Object)dtGd);
        for (networkHList list : networkHList.values()) {
            TableColumn column = new TableColumn(this.networkTable, 16384);
            column.setWidth(list.size);
            column.setText(list.name);
        }
        this.networkTable.setHeaderVisible(true);
    }

    private void createForwardComposite(Composite comp) {
        this.net = new Combo(comp, 8);
        GridData cgd = new GridData(768, 1);
        this.net.add("tcp");
        this.net.add("udp");
        this.net.select(0);
        cgd.horizontalIndent = 5;
        cgd.widthHint = 80;
        cgd.heightHint = 18;
        this.net.setLayoutData((Object)cgd);
        this.net.setFont(this.addrFont);
        Label sAddrlabel = new Label(comp, 0);
        sAddrlabel.setText("Source\nAddress");
        sAddrlabel.setFont(this.addrFont);
        sAddrlabel.setBackground(ColorResources.NETWORK_FORWARD.getColor());
        GridData sagd = new GridData(768);
        sagd.verticalIndent = 9;
        sagd.horizontalAlignment = 0x1000000;
        sAddrlabel.setLayoutData((Object)sagd);
        Text sIPAddr = new Text(comp, 2056);
        sIPAddr.setText("localhost");
        sIPAddr.setTextLimit(16);
        sIPAddr.setFont(this.font);
        GridData sIPgd = new GridData(768);
        sIPgd.verticalIndent = 8;
        sIPgd.widthHint = 80;
        sIPgd.heightHint = 18;
        sIPAddr.setLayoutData((Object)sIPgd);
        this.sIPPort = new Text(comp, 2048);
        this.sIPPort.setMessage("Port");
        this.sIPPort.setTextLimit(5);
        this.sIPPort.setFont(this.font);
        GridData sPgd = new GridData(768);
        sPgd.verticalIndent = 8;
        sPgd.widthHint = 38;
        sPgd.heightHint = 18;
        this.sIPPort.setLayoutData((Object)sPgd);
        this.sIPPort.addKeyListener((KeyListener)this.portKeyAdapter);
        Label dAddrlabel = new Label(comp, 0);
        dAddrlabel.setText("Dest.\nAddress");
        dAddrlabel.setFont(this.addrFont);
        dAddrlabel.setBackground(ColorResources.NETWORK_FORWARD.getColor());
        GridData dagd = new GridData(768);
        dagd.verticalIndent = 9;
        dagd.horizontalAlignment = 0x1000000;
        dAddrlabel.setLayoutData((Object)dagd);
        this.dIPAddr = new Text(comp, 2056);
        this.dIPAddr.setText("10.0.2.16");
        this.dIPAddr.setTextLimit(16);
        this.dIPAddr.setFont(this.font);
        GridData dIPgd = new GridData(768);
        dIPgd.verticalIndent = 8;
        dIPgd.widthHint = 80;
        dIPgd.heightHint = 18;
        this.dIPAddr.setLayoutData((Object)dIPgd);
        this.dIPPort = new Text(comp, 2048);
        this.dIPPort.setMessage("Port");
        this.dIPPort.setTextLimit(5);
        this.dIPPort.setFont(this.font);
        GridData dPgd = new GridData(768);
        dPgd.verticalIndent = 8;
        dPgd.widthHint = 38;
        dPgd.heightHint = 18;
        this.dIPPort.setLayoutData((Object)dPgd);
        this.dIPPort.addKeyListener((KeyListener)this.portKeyAdapter);
    }

    private boolean isPortsFilled() {
        return !this.sIPPort.getText().isEmpty() && !this.dIPPort.getText().isEmpty();
    }

    private void cleartextBoxes() {
        this.sIPPort.setText("");
        this.dIPPort.setText("");
    }

    private void handleForward() {
        String data = this.net.getText() + ":" + this.sIPPort.getText() + ":" + this.dIPAddr.getText() + ":" + this.dIPPort.getText();
        MessageSender.getInstance().sendDeviceReq("Network", 0, 0, data);
        MessageSender.getInstance().sendMonitorReq(this.createUsernetMsg());
    }

    @Override
    protected void initializeWidget() {
    }

    public void displayContents(VMView instance) {
        super.showComposite();
    }

    private void parseDeviceMsg(String message) {
        String[] lineSplit = message.split("\r\n");
        String hub = null;
        for (String line : lineSplit) {
            String[] valueSplit;
            if (line.startsWith("hub ")) {
                hub = line.substring(0, line.length());
                continue;
            }
            String[] nameSplit = line.split(": ");
            String[] contents = new String[deviceHList.values().length];
            if (hub != null) {
                contents[0] = hub;
                hub = null;
            } else {
                contents[0] = "";
            }
            contents[1] = nameSplit[0].startsWith(" \\") ? nameSplit[0].substring(3) : nameSplit[0];
            for (String value : valueSplit = nameSplit[1].split(",")) {
                String[] keySplit = value.split("=");
                if (keySplit[0].equals("index")) {
                    contents[2] = keySplit[1];
                    continue;
                }
                if (keySplit[0].equals("type")) {
                    contents[3] = keySplit[1];
                    continue;
                }
                if (keySplit[0].equals("net")) {
                    contents[4] = keySplit[1];
                    continue;
                }
                if (keySplit[0].equals("model")) {
                    contents[5] = keySplit[1];
                    continue;
                }
                if (keySplit[0].equals("macaddr")) {
                    contents[6] = keySplit[1];
                    continue;
                }
                if (!keySplit[0].equals("restrict")) continue;
                contents[7] = keySplit[1];
            }
            for (int i = 1; i < contents.length; ++i) {
                if (contents[i] != null) continue;
                contents[i] = "-";
            }
            TableItem tablelist = new TableItem(this.deviceTable, 0);
            tablelist.setText(contents);
        }
    }

    private void parseNetworkMsg(String message) {
        String[] lineSplit = message.split("\r\n");
        String lan = null;
        for (String line : lineSplit) {
            if (line.length() < 72) continue;
            if (line.startsWith("VLAN ")) {
                lan = line.substring(0, line.length() - 1);
                continue;
            }
            if ((line = line.substring(2, line.length())).startsWith("Protocol[State]")) continue;
            String[] vlanContents = new String[networkHList.values().length];
            if (lan != null) {
                vlanContents[0] = lan;
                lan = null;
            } else {
                vlanContents[0] = "";
            }
            vlanContents[1] = line.substring(0, 18).trim();
            vlanContents[2] = line.substring(18, 22).trim();
            vlanContents[3] = line.substring(22, 38).trim();
            vlanContents[4] = line.substring(38, 44).trim();
            vlanContents[5] = line.substring(44, 60).trim();
            vlanContents[6] = line.substring(60, 66).trim();
            vlanContents[7] = line.substring(66, 72).trim();
            vlanContents[8] = line.substring(72, line.length()).trim();
            TableItem tablelist = new TableItem(this.networkTable, 0);
            tablelist.setText(vlanContents);
        }
    }

    @Override
    public void OnEventProc(String eventname, JSONObject jsParam) {
        String message = (String)jsParam.get((Object)"return");
        logger.info(message);
        if (message.startsWith("VLAN")) {
            this.networkTable.removeAll();
            this.parseNetworkMsg(message);
        } else {
            this.deviceTable.removeAll();
            this.parseDeviceMsg(message);
        }
    }

    @Override
    public void OnEventProcPB(String eventname, GeneratedMessage param) {
        Ecs.DeviceNtf ntf;
        long action;
        if (param instanceof Ecs.DeviceNtf && 123L == (action = (long)(ntf = (Ecs.DeviceNtf)param).getAction()) && ntf.getData().toStringUtf8().equals("1")) {
            new MessageDialog().openErrorDialog("Failed to add port forwarding.\nPlease try to choose different port.");
        }
    }

    private String createNetworkMsg() {
        String msg = JsonUtil.encodeMonitorString("execute", "human-monitor-command", "arguments", JsonUtil.encodeObject("command-line", "info network"), "Network");
        return msg;
    }

    private String createUsernetMsg() {
        String msg = JsonUtil.encodeMonitorString("execute", "human-monitor-command", "arguments", JsonUtil.encodeObject("command-line", "info usernet"), "Network");
        return msg;
    }

    private void send() {
        MessageSender.getInstance().sendMonitorReq(this.createNetworkMsg());
        MessageSender.getInstance().sendMonitorReq(this.createUsernetMsg());
    }

    @Override
    public boolean Create() {
        this.createPage();
        EventMgr.getInstance().AddLsnSet("Network");
        EventMgr.getInstance().AddLsn("Network", this);
        this.send();
        return true;
    }

    @Override
    public void OnActivate() {
    }

    @Override
    public void OnDeactivate() {
    }

    private static enum networkHList {
        INTERFACE(65, "Interface"),
        PROTOCOL(70, "Protocol"),
        FD(28, "FD"),
        SADDR(110, "Source Address"),
        SPORT(45, "Port"),
        DADDR(110, "Dest. Address"),
        DPORT(45, "Port"),
        RECVQ(50, "RecvQ"),
        SENDQ(50, "SendQ");

        int size;
        String name;

        private networkHList(int size, String name) {
            this.size = size;
            this.name = name;
        }
    }

    private static enum deviceHList {
        HUB(50, "Hub"),
        NAME(100, "Name"),
        INDEX(50, "index"),
        TYPE(50, "Type"),
        NET(50, "Net"),
        MODEL(80, "Model"),
        MAC(90, "Mac address"),
        RESTRICT(50, "Restrict");

        int size;
        String name;

        private deviceHList(int size, String name) {
            this.size = size;
            this.name = name;
        }
    }
}

