/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.info;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.tizen.ecp.category.ECPListCtrl;
import org.tizen.ecp.info.ContentImageButton;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.FontResources;
import org.tizen.ecp.utils.FormUtil;

public class ContentButton {
    private String deviceName;
    private ContentImageButton imageButton;
    private Label textButton;
    private SelectionAdapter contentSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ECPListCtrl.getInstance().setSelect(ContentButton.this.deviceName);
        }
    };
    private MouseAdapter contentMouseAdapter = new MouseAdapter(){

        public void mouseUp(MouseEvent e) {
            ECPListCtrl.getInstance().setSelect(ContentButton.this.deviceName);
        }
    };
    private MouseTrackAdapter contentMouseTrackAdapter = new MouseTrackAdapter(){

        public void mouseEnter(MouseEvent e) {
            ContentButton.this.textButton.setForeground(ColorResources.TEXT_SELECT_DARK.getColor());
            ContentButton.this.imageButton.notifyListeners(6, new Event());
        }

        public void mouseExit(MouseEvent e) {
            ContentButton.this.textButton.setForeground(ColorResources.TEXT_NORMAL.getColor());
            ContentButton.this.imageButton.notifyListeners(7, new Event());
        }
    };

    public ContentButton(Composite parent, String deviceName, Image nml, Image hover, String text) {
        this.deviceName = deviceName;
        this.imageButton = new ContentImageButton(parent, 8);
        this.imageButton.setImages(nml, hover, nml, hover, nml, nml);
        GridData gd = FormUtil.createGD(nml.getImageData().width, nml.getImageData().height, 0, 0);
        this.imageButton.setLayoutData(gd);
        this.textButton = FormUtil.createLabel(parent, text, FontResources.FONT_11.getFont(), ColorResources.TEXT_NORMAL.getColor());
        this.imageButton.setConnectedLabel(this.textButton);
        this.addListeners();
    }

    private void addListeners() {
        this.imageButton.addSelectionListener((SelectionListener)this.contentSelectionAdapter);
        this.textButton.addMouseListener((MouseListener)this.contentMouseAdapter);
        this.textButton.addMouseTrackListener((MouseTrackListener)this.contentMouseTrackAdapter);
    }

    public String getDeviceName() {
        return this.deviceName;
    }
}

