/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.resources;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.FontResources;
import org.tizen.ecp.resources.ImageResources;

public class PatchImageResources {
    public static Image getPatchImage(Image left, Image middle, Image right, int width, int height, Color bgColor) {
        Image image = new Image((Device)Display.getCurrent(), width, height);
        if (left == null || middle == null || right == null) {
            return null;
        }
        int leftWidth = left.getBounds().width;
        int rightWidth = right.getBounds().width;
        GC gc = new GC((Drawable)image);
        gc.setAntialias(1);
        gc.setInterpolation(0);
        gc.setBackground(bgColor);
        gc.fillRectangle(image.getBounds());
        gc.drawImage(left, 0, 0);
        Rectangle rect = middle.getBounds();
        gc.drawImage(middle, rect.x, rect.y, rect.width, rect.height, leftWidth, 0, width - (leftWidth + rightWidth), height);
        gc.drawImage(right, width - rightWidth, 0);
        gc.dispose();
        return image;
    }

    public static Image getPatchImage(Image left, Image middle, Image right, int width, int height) {
        return PatchImageResources.getPatchImage(left, middle, right, width, height, ColorResources.OVERALL_BG.getColor());
    }

    public static Image getInputBoxOff(int width, int height, String name) {
        Image image = new Image((Device)Display.getCurrent(), width, height);
        GC gc = new GC((Drawable)image);
        Image patchImage = PatchImageResources.getPatchImage(ImageResources.INPUTBOX_OFF_LEFT.getImage(), ImageResources.INPUTBOX_OFF_MIDDLE.getImage(), ImageResources.INPUTBOX_OFF_RIGHT.getImage(), width, height, ColorResources.TAB_BG.getColor());
        gc.drawImage(patchImage, 0, 0);
        gc.setInterpolation(0);
        gc.setFont(FontResources.FONT_8.getFont());
        gc.setForeground(ColorResources.DETAIL_VALUE_FONT.getColor());
        int x = 6;
        gc.drawText(name, x, 3, true);
        gc.dispose();
        return image;
    }

    public static Image getSelectTabFolder(int width, int height) {
        Image left = ImageResources.TAB_SELECTED_LEFT.getImage();
        Image middle = ImageResources.TAB_SELECTED_MIDDLE.getImage();
        Image right = ImageResources.TAB_SELECTED_RIGHT.getImage();
        return PatchImageResources.getPatchImage(left, middle, right, width, height, ColorResources.TAB_BG.getColor());
    }

    public static Image getUnselectedTabFolder(int width, int height) {
        Image left = ImageResources.TAB_UNSELECTED_LEFT.getImage();
        Image middle = ImageResources.TAB_UNSELECTED_MIDDLE.getImage();
        Image right = ImageResources.TAB_UNSELECTED_RIGHT.getImage();
        return PatchImageResources.getPatchImage(left, middle, right, width, height, ColorResources.TAB_BG.getColor());
    }

    public static Image getHoverTabFolder(int width, int height) {
        Image left = ImageResources.TAB_UNSELECTED_LEFT_HOVER.getImage();
        Image middle = ImageResources.TAB_UNSELECTED_MIDDLE_HOVER.getImage();
        Image right = ImageResources.TAB_UNSELECTED_RIGHT_HOVER.getImage();
        return PatchImageResources.getPatchImage(left, middle, right, width, height, ColorResources.TAB_BG.getColor());
    }

    public static Image getSelTabImage(int width, int height) {
        Image left = ImageResources.TAB_NML_LEFT.getImage();
        Image middle = ImageResources.TAB_NML_MID.getImage();
        Image right = ImageResources.TAB_NML_RIGHT.getImage();
        return PatchImageResources.getPatchImage(left, middle, right, width, height);
    }

    public static Image getNotSelTabImage(int width, int height) {
        Image left = ImageResources.TAB_NSEL_LEFT.getImage();
        Image middle = ImageResources.TAB_NSEL_MID.getImage();
        Image right = ImageResources.TAB_NSEL_RIGHT.getImage();
        return PatchImageResources.getPatchImage(left, middle, right, width, height);
    }

    public static Image getSelectedList(int width, int height) {
        Image left = ImageResources.LIST_SELECTED_LEFT.getImage();
        Image middle = ImageResources.LIST_SELECTED_MIDDLE.getImage();
        Image right = ImageResources.LIST_SELECTED_RIGHT.getImage();
        return PatchImageResources.getPatchImage(left, middle, right, width, height);
    }

    public static Image getUnselectedList(int width, int height) {
        Image left = ImageResources.LIST_NML_LEFT.getImage();
        Image middle = ImageResources.LIST_NML_MIDDLE.getImage();
        Image right = ImageResources.LIST_NML_RIGHT.getImage();
        return PatchImageResources.getPatchImage(left, middle, right, width, height);
    }

    public static Image getUnselectedList2(int width, int height) {
        Image left = ImageResources.LIST_NML2_LEFT.getImage();
        Image middle = ImageResources.LIST_NML2_MIDDLE.getImage();
        Image right = ImageResources.LIST_NML2_RIGHT.getImage();
        return PatchImageResources.getPatchImage(left, middle, right, width, height);
    }

    public static Image getToggledListCategory(int width, int height) {
        return PatchImageResources.getPatchImage(ImageResources.LIST_CATEGORY.getImage(), ImageResources.LIST_CATEGORY.getImage(), ImageResources.LIST_CATEGORY.getImage(), width, height, ColorResources.OVERALL_BG.getColor());
    }

    public static Image getUntoggledListCategory(int width, int height) {
        Image left = ImageResources.LIST_CATEGORY.getImage();
        Image middle = ImageResources.LIST_CATEGORY.getImage();
        Image right = ImageResources.LIST_CATEGORY.getImage();
        return PatchImageResources.getPatchImage(left, middle, right, width, height);
    }
}

