/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.FontResources;
import org.tizen.ecp.resources.ImageResources;
import org.tizen.ecp.views.VMView;
import org.tizen.ecp.widgets.ECPButton;

public class PropertyView {
    private Composite comp;
    private ECPButton openBtn;
    private ECPButton refresh;
    private SelectionListener refreshListener = null;
    private Tree tree;
    public int propertyHeight = 150;
    private SelectionAdapter openSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PropertyView.this.toggleLayout();
        }
    };
    private ControlAdapter controlAdapter = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            PropertyView.this.propertyHeight = ((Composite)e.widget).getClientArea().height;
            if (PropertyView.this.propertyHeight < 22) {
                PropertyView.this.propertyHeight = 22;
                PropertyView.this.sashSetWeight(PropertyView.this.propertyHeight);
            }
        }
    };
    private MouseAdapter mouseSelection = new MouseAdapter(){
        private boolean clicked = false;

        public void mouseDown(MouseEvent e) {
            Label label = (Label)e.widget;
            Rectangle rect = label.getBounds();
            if (rect.contains(e.x, e.y)) {
                this.clicked = true;
            }
        }

        public void mouseUp(MouseEvent e) {
            Label label = (Label)e.widget;
            Rectangle rect = label.getBounds();
            if (rect.contains(e.x, e.y) && this.clicked) {
                if (PropertyView.this.openBtn.getSelection()) {
                    PropertyView.this.openBtn.setSelection(false);
                } else {
                    PropertyView.this.openBtn.setSelection(true);
                }
                PropertyView.this.toggleLayout();
            }
            this.clicked = false;
        }
    };

    public boolean isVisible() {
        return this.comp.isVisible();
    }

    public void createView(Composite composite) {
        this.comp = composite;
        this.comp.addControlListener((ControlListener)this.controlAdapter);
        Composite titleComp = new Composite(composite, 0);
        titleComp.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(0, 22);
        data.right = new FormAttachment(100, 0);
        titleComp.setLayoutData((Object)data);
        titleComp.setBackground(ColorResources.PROPERTY_BG.getColor());
        Image open = ImageResources.LIST_ARROW_OPEN2.getImage();
        Image close = ImageResources.LIST_ARROW_CLOSE.getImage();
        this.openBtn = new ECPButton(titleComp, 2);
        this.openBtn.setImages(open, open, close, close, open, close);
        this.openBtn.setSelection(true);
        data = new FormData();
        data.left = new FormAttachment(0, 6);
        data.top = new FormAttachment(0, 7);
        data.width = 7;
        data.height = 7;
        this.openBtn.setLayoutData(data);
        this.openBtn.addSelectionListener((SelectionListener)this.openSelection);
        Label label = new Label(titleComp, 0);
        label.setText("Status Monitoring");
        label.setFont(FontResources.FONT_9.getFont());
        label.setForeground(ColorResources.WHITE.getColor());
        data = new FormData();
        data.left = new FormAttachment((Control)this.openBtn, 4);
        data.top = new FormAttachment(0, 3);
        data.right = new FormAttachment(100, -20);
        data.bottom = new FormAttachment(100, 0);
        label.setLayoutData((Object)data);
        label.addMouseListener((MouseListener)this.mouseSelection);
        Image NmlBtn = ImageResources.REFRESH_NML.getImage();
        Image HoverBtn = ImageResources.REFRESH_HOVER.getImage();
        Image PushBtn = ImageResources.REFRESH_PUSH.getImage();
        this.refresh = new ECPButton(titleComp, 8);
        this.refresh.setImages(NmlBtn, HoverBtn, PushBtn, PushBtn, NmlBtn, HoverBtn);
        data = new FormData();
        data.left = new FormAttachment((Control)label, 0);
        data.top = new FormAttachment(0, 3);
        data.width = 16;
        data.height = 16;
        this.refresh.setLayoutData(data);
        Composite treeComp = new Composite(composite, 0);
        treeComp.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)titleComp, 0);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(100, 0);
        treeComp.setLayoutData((Object)data);
        this.tree = new Tree(treeComp, 2048);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.right = new FormAttachment(100, 0);
        this.tree.setLayoutData((Object)data);
        this.tree.setFont(FontResources.FONT_9.getFont());
        this.tree.setHeaderVisible(true);
        TreeColumn column1 = new TreeColumn(this.tree, 16384);
        column1.setText("Property");
        column1.setWidth(153);
        TreeColumn column2 = new TreeColumn(this.tree, 0x1000000);
        column2.setText("Value");
        column2.setWidth(160);
    }

    private void toggleLayout() {
        this.propertyHeight = this.openBtn.getSelection() ? 150 : 22;
        this.sashSetWeight(this.propertyHeight);
    }

    public void sashSetWeight(int height) {
        SashForm sash = VMView.getInstance().getPropertySash();
        int[] weights = new int[2];
        Rectangle rect = sash.getBounds();
        weights[0] = rect.height - height;
        weights[1] = height;
        sash.setWeights(weights);
        this.comp.layout(true);
    }

    public Tree getTree() {
        return this.tree;
    }

    public TreeItem setTreeItem(Tree parent, String[] item) {
        TreeItem treeItem = new TreeItem(parent, 0);
        treeItem.setText(item);
        return treeItem;
    }

    public TreeItem setTreeItem(TreeItem parent, String[] item) {
        TreeItem treeItem = new TreeItem(parent, 0);
        treeItem.setText(item);
        return treeItem;
    }

    public void setRefreshListener(SelectionListener listener) {
        if (this.refreshListener != null) {
            this.refresh.removeSelectionListener(this.refreshListener);
        }
        this.refresh.addSelectionListener(listener);
        this.refreshListener = listener;
    }

    public void refresh() {
        this.comp.layout(true, true);
    }
}

