/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.category.ECPListCtrl;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.utils.ECPProperty;
import org.tizen.ecp.views.ECPLeftView;
import org.tizen.ecp.views.PropertyView;
import org.tizen.ecp.views.ViewMgr;

public class VMView {
    private static VMView instance = new VMView();
    private Composite composite;
    private Composite detailComposite;
    private SashForm sComp;
    private Composite propComp;
    private PropertyView pView;
    private SashForm sashForm;
    private StackLayout stacklayout;
    private ECPProperty ecpProperty;

    public Composite getComposite() {
        return this.detailComposite;
    }

    public Composite getVMComposite() {
        return this.composite;
    }

    public StackLayout getStackLayout() {
        return this.stacklayout;
    }

    public void setProperty(ECPProperty prop) {
        this.ecpProperty = prop;
    }

    public void compose(Composite middleComposite) {
        this.sashForm = new SashForm(middleComposite, 0);
        this.sashForm.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment(100, -1);
        this.sashForm.setLayoutData((Object)data);
        this.sashForm.SASH_WIDTH = 1;
        this.sashForm.setBackground(ColorResources.BORDER_BG.getColor());
        ECPLeftView m_leftView = new ECPLeftView();
        m_leftView.create(this.sashForm);
        this.sComp = new SashForm((Composite)this.sashForm, 512);
        this.sComp.setLayout((Layout)new FillLayout());
        this.sComp.setBackground(ColorResources.OVERALL_BG.getColor());
        this.detailComposite = new Composite((Composite)this.sComp, 0);
        this.detailComposite.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, -150);
        data.right = new FormAttachment(100, 0);
        this.detailComposite.setLayoutData((Object)data);
        this.propComp = new Composite((Composite)this.sComp, 0);
        this.propComp.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.detailComposite, 0);
        data.height = 150;
        data.right = new FormAttachment(100, 0);
        this.propComp.setLayoutData((Object)data);
        this.pView = new PropertyView();
        this.pView.createView(this.propComp);
        this.propComp.setVisible(false);
        this.sComp.setWeights(new int[]{300, 150});
        this.sashForm.setWeights(new int[]{200, 506});
        this.stacklayout = new StackLayout();
        this.detailComposite.setLayout((Layout)this.stacklayout);
        ViewMgr.getInstance().initialize();
        String view = this.ecpProperty.getPropertyString("view.last");
        if (view == null || !ECPInfo.getInstance().isInDeviceList(view)) {
            view = "Event Injector";
        }
        ECPListCtrl.getInstance().setSelect(view);
    }

    public static VMView getInstance() {
        return instance;
    }

    public SashForm getPropertySash() {
        return this.sComp;
    }

    public Composite getPropertyComposite() {
        return this.propComp;
    }

    public PropertyView getPropertyView() {
        return this.pView;
    }

    public void showPropertyView(boolean show) {
        this.propComp.setVisible(show);
        this.propComp.getParent().layout();
    }
}

