/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.NullCompletor;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.CLIManager;
import org.tizen.cli.ConnectionManager;
import org.tizen.cli.commands.EmulatorCommandsHandler;
import org.tizen.cli.session.ArgCompletor;
import org.tizen.cli.session.CommandCompletor;
import org.tizen.cli.session.DeviceCompletor;
import org.tizen.cli.utils.ArgsUtil;
import org.tizen.cli.utils.EmulatorDevice;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.ecpinfo.xml.CliTypes;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.sock.IConnection;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.sock.SocketClient;
import org.tizen.ecp.sock.SocketMessage;
import org.tizen.ecp.utils.About;
import org.tizen.ecp.utils.LogUtil;

public class TizenEmulatorCli
implements IConnection {
    private static Logger logger = null;
    private static String help = null;
    private ConsoleReader reader = null;
    @Argument(index=0, required=true, handler=EmulatorCommandsHandler.class)
    private AbstractEmulatorCLI tizenCLI;

    public static void exit(int status) {
        System.exit(status);
    }

    public static void main(String[] args) {
        int ret = 0;
        TizenEmulatorCli emulatorCli = new TizenEmulatorCli();
        ret = emulatorCli.run(args);
        TizenEmulatorCli.exit(-ret);
    }

    private void finished() {
        Collection<Object> objs = CLIManager.getInstance().getClassInstances();
        for (Object obj : objs) {
            if (!(obj instanceof AbstractEmulatorCLI)) continue;
            ((AbstractEmulatorCLI)obj).finished();
        }
    }

    private int sessionMode(EmulatorDevice device) throws IOException {
        String line;
        int ret = 0;
        OutputUtil.println("Start Emulator control panel CLI.");
        CLIManager.getInstance().setSessionMode(true);
        help = this.makeHelpString();
        if (help == null) {
            logger.severe("Failed to create help message: check xml.");
            return 22;
        }
        if (!SocketClient.getInstance().connect(device.getPort())) {
            OutputUtil.printError("Failed to connect the emulator.");
            logger.severe("Failed to connect the emulator : " + device.getVmName());
            return 24;
        }
        SocketClient.getInstance().registerDisconnectListener((IConnection)this);
        new Thread(null, (Runnable)new SocketMessage(), "Socket Message Thread").start();
        MessageSender.getInstance().sendInjectorReq("guest", 15, 0);
        this.reader = new ConsoleReader();
        this.reader.setBellEnabled(false);
        LinkedList<Object> completors = new LinkedList<Object>();
        DeviceCompletor dCompletor = new DeviceCompletor();
        completors.add(dCompletor);
        CommandCompletor cCompletor = new CommandCompletor(dCompletor);
        completors.add(cCompletor);
        completors.add(new ArgCompletor(cCompletor));
        completors.add(new NullCompletor());
        this.reader.addCompletor((Completor)new ArgumentCompletor(completors));
        while ((line = this.reader.readLine(">> ")) != null) {
            String[] args = line.split(" ");
            if (args[0] != null && args[0].toLowerCase().equals("exit")) {
                this.finished();
                break;
            }
            ret = this.shellMode(args = ArgsUtil.checkArgs(args));
            if (ret < 0) {
                logger.warning("session mode launch failed with " + ret);
            }
            this.tizenCLI = null;
        }
        return 0;
    }

    private String makeHelpString() {
        String helpString = "";
        List devices = ECPInfo.getInstance().getCLIInfo();
        if (devices == null) {
            return null;
        }
        String HELP_USAGE = "Usage: " + (CLIManager.getInstance().getSessionMode() ? "" : "ecp-cli ") + (CLIManager.getInstance().getSessionMode() ? "" : "[--target <VM name | serial>] ") + "[devices] [cmds] [args]" + StringResources.NEW_LINE + StringResources.NEW_LINE;
        String HELP_DEVICE_INFO = "See '" + (CLIManager.getInstance().getSessionMode() ? "" : "ecp-cli ") + "help [device]' for more information on a specific command";
        helpString = OutputUtil.appendComplete(helpString, HELP_USAGE);
        helpString = OutputUtil.appendComplete(helpString, "Supported devices are :\n");
        for (CliTypes.Device dev : devices) {
            helpString = OutputUtil.appendComplete(helpString, OutputUtil.getFormatList(dev.getName(), dev.getDescription()));
        }
        helpString = OutputUtil.appendComplete(helpString, OutputUtil.getFormatList("keycode", "Send keycode for input"));
        helpString = OutputUtil.appendComplete(helpString, OutputUtil.getFormatList("hmp", "send human monitor commands"));
        helpString = OutputUtil.appendComplete(helpString, OutputUtil.getFormatList("qmp", "send qemu monitor protocol commands (\\\" instead \" in shell mode)."));
        helpString = OutputUtil.appendComplete(helpString, OutputUtil.getFormatList("hds", "enable/disable host directory sharing"));
        helpString = OutputUtil.appendComplete(helpString, StringResources.NEW_LINE);
        helpString = OutputUtil.appendComplete(helpString, HELP_DEVICE_INFO);
        return helpString;
    }

    private boolean connected() {
        if (CLIManager.getInstance().getSessionMode()) {
            return true;
        }
        EmulatorDevice device = CLIManager.getInstance().getSelectedDevice();
        if (device == null) {
            return false;
        }
        if (!SocketClient.getInstance().connect(device.getPort())) {
            return false;
        }
        SocketClient.getInstance().registerDisconnectListener((IConnection)this);
        new Thread(null, (Runnable)new SocketMessage(), "Socket Message Thread").start();
        MessageSender.getInstance().sendInjectorReq("guest", 15, 0);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void disconnect() {
        if (CLIManager.getInstance().getSessionMode()) {
            return;
        }
        SocketClient.getInstance().disconnect();
    }

    private int shellMode(String[] args) {
        logger.info(Arrays.toString(args));
        CmdLineParser cmdParser = null;
        if (args == null || args.length <= 0 || args[0] == null || args[0].isEmpty()) {
            logger.severe("shellMode args[0] is null.");
            return 1;
        }
        if (args[0].toLowerCase().trim().equals("qmp") || args[0].toLowerCase().trim().equals("hmp")) {
            args = ArgsUtil.getRemainArgs(args);
        }
        cmdParser = new CmdLineParser((Object)this);
        cmdParser.stopOptionParsing();
        try {
            cmdParser.parseArgument(args);
            cmdParser.setUsageWidth(Integer.MAX_VALUE);
        }
        catch (CmdLineException e) {
            logger.log(Level.WARNING, "cmd paring error", e);
            OutputUtil.printError("Not supported commands.");
            OutputUtil.println(help);
            return 25;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "cmd paring exception", e);
            OutputUtil.printError("Not supported commands.");
            OutputUtil.println(help);
            return 25;
        }
        if (null != this.tizenCLI) {
            this.tizenCLI.help = help;
            if (!this.connected()) {
                OutputUtil.printError("Failed to connect the emulator.");
                return 24;
            }
            int ret = this.tizenCLI.execute();
            this.disconnect();
            return ret;
        }
        return 0;
    }

    private void logInit(String name) throws IOException {
        LogUtil.init((LogUtil.ECPLogLevel)LogUtil.ECPLogLevel.DEBUG, (String)name, (String)"emulator-cli.log", (boolean)true);
        logger = LogUtil.getECPLogger(TizenEmulatorCli.class).getLogger();
    }

    private void initializeECPInfo(String name, int port) throws IOException, JAXBException {
        VMInfo.getInstance().initialize(name, port);
        String ecpInfoPath = VMInfo.getInstance().getPluginPath() + File.separator + "ecp-plugin.xml";
        logger.info("xml path: " + ecpInfoPath);
        ECPInfo.getInstance().initialize(ecpInfoPath);
    }

    private int checkTarget(String[] args) {
        List<EmulatorDevice> devices = CLIManager.getInstance().getDevices();
        if (devices == null || devices.size() <= 0) {
            OutputUtil.printError("No emulator device is found.");
            return 17;
        }
        if (ArgsUtil.isTargetSpecified(args)) {
            String targetSpecified = ArgsUtil.getTargetSpecified(args);
            OutputUtil.debug("targetSpecified : " + targetSpecified);
            for (EmulatorDevice dev : devices) {
                String name = dev.getVmName();
                String target = dev.getTarget();
                OutputUtil.debug("comparing name : " + name + ", target : " + target);
                if ((name == null || !name.equals(targetSpecified)) && (target == null || !target.equals(targetSpecified))) continue;
                CLIManager.getInstance().setSelectedDevice(dev);
            }
            if (CLIManager.getInstance().getSelectedDevice() == null) {
                OutputUtil.printError("The Specified target is not exist.");
                return 18;
            }
        } else if (devices.size() == 1) {
            CLIManager.getInstance().setSelectedDevice(devices.get(0));
        } else {
            OutputUtil.debug("getDevice: " + devices.size());
            OutputUtil.printError("Specify the target with --target option.");
            return 19;
        }
        return 0;
    }

    private int run(String[] args) {
        int ret = 0;
        ConnectionManager.getInstance().checkServer();
        OutputUtil.debug("check server");
        ret = this.checkTarget(args);
        if (ret != 0) {
            return ret;
        }
        EmulatorDevice device = CLIManager.getInstance().getSelectedDevice();
        if (device == null) {
            OutputUtil.printError("Unexpected error occured.");
            return 1;
        }
        String vmname = device.getVmName();
        int port = device.getPort();
        OutputUtil.debug("vmname is " + vmname + ", port is " + port);
        if (ArgsUtil.isTargetOptionSpecified(args) && !ArgsUtil.isTargetSpecified(args)) {
            OutputUtil.printError("--target option is given, but no target specified.");
            return 20;
        }
        if (ArgsUtil.isTargetSpecified(args)) {
            args = ArgsUtil.removeTargetSpecified(args);
        }
        try {
            this.logInit(vmname);
        }
        catch (IOException e) {
            OutputUtil.printError("Log file creation is failed.", e);
            return 21;
        }
        logger.info("!!! Start Emulator Control Panel CLI!!!");
        logger.info("ECP version : " + About.getInstance().getECPVersion());
        logger.info("device name is " + vmname + " and port is " + port);
        try {
            this.initializeECPInfo(vmname, port - 3);
        }
        catch (IOException e) {
            logger.severe("IOException: " + e.getMessage());
            OutputUtil.printError("Failed to get the emulator profile.", e);
            return 22;
        }
        catch (JAXBException e) {
            logger.severe("JAXBException: " + e.getMessage());
            OutputUtil.printError("Failed to get the emulator profile.", (Exception)((Object)e));
            return 22;
        }
        CLIManager.getInstance().loadClass();
        try {
            if (args == null || args.length == 0) {
                ret = this.sessionMode(device);
            } else {
                help = this.makeHelpString();
                if (help == null) {
                    logger.severe("Failed to create help message: check xml.");
                    return 22;
                }
                ret = this.shellMode(args);
            }
        }
        catch (IOException e) {
            OutputUtil.printError("Failed to get into session mode.", e);
            return 23;
        }
        return ret;
    }

    public void disconnected() {
        if (CLIManager.getInstance().getSessionMode()) {
            OutputUtil.print("\n");
            OutputUtil.printError("Connection Lost.");
            TizenEmulatorCli.exit(-27);
        }
    }

    public void guestOn() {
    }

    public void guestOff() {
    }

    public void guestOffMessage() {
    }
}

