/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sock;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.msg.genmsg.ecs.EcsIds;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.IMsgProc;
import org.tizen.ecp.sock.MsgProc_Device;
import org.tizen.ecp.sock.MsgProc_Injector;
import org.tizen.ecp.sock.MsgProc_KeepAliveReq;
import org.tizen.ecp.sock.MsgProc_MonitorNtf;
import org.tizen.ecp.utils.JsonUtil;
import org.tizen.ecp.utils.LogUtil;

public class MsgMgr {
    private Logger logger = LogUtil.getECPLogger(MsgMgr.class).getLogger();
    private Map<EcsIds.Master_Type, IMsgProc> _msg_map = new HashMap<EcsIds.Master_Type, IMsgProc>();
    private byte[] contents = null;
    private static MsgMgr _inst;

    MsgMgr() {
        this.AddMsgProc(EcsIds.Master_Type.INJECTOR_NTF, new MsgProc_Injector());
        this.AddMsgProc(EcsIds.Master_Type.INJECTOR_ANS, new MsgProc_Injector());
        this.AddMsgProc(EcsIds.Master_Type.MONITOR_NTF, new MsgProc_MonitorNtf());
        this.AddMsgProc(EcsIds.Master_Type.DEVICE_NTF, new MsgProc_Device());
        this.AddMsgProc(EcsIds.Master_Type.DEVICE_ANS, new MsgProc_Device());
        this.AddMsgProc(EcsIds.Master_Type.KEEPALIVE_REQ, new MsgProc_KeepAliveReq());
    }

    public static MsgMgr getInstance() {
        if (null == _inst) {
            _inst = new MsgMgr();
        }
        return _inst;
    }

    public void AddMsgProc(EcsIds.Master_Type type, IMsgProc proc) {
        if (this.FindMsgProc(type) == null) {
            this._msg_map.put(type, proc);
        }
    }

    public IMsgProc FindMsgProc(EcsIds.Master_Type type) {
        IMsgProc proc = this._msg_map.get((Object)type);
        if (proc == null) {
            return null;
        }
        return proc;
    }

    private byte[] copyByte(byte[] src) {
        if (src.length == 0) {
            return null;
        }
        byte[] dest = new byte[src.length];
        for (int i = 0; i < src.length; ++i) {
            dest[i] = src[i];
        }
        return dest;
    }

    private byte[] copyByte(byte[] a, byte[] b) {
        byte[] temp = new byte[a.length + b.length];
        int tmp = 0;
        for (int i = 0; i < temp.length; ++i) {
            if (i < a.length) {
                temp[i] = a[i];
                continue;
            }
            if (i == a.length) {
                tmp = i;
                temp[i] = b[i - tmp];
                continue;
            }
            temp[i] = b[i - tmp];
        }
        return temp;
    }

    public void ProcBufMsg(Ecs.Master msg) {
        EcsIds.Master_Type subtype = msg.getType();
        IMsgProc proc = this.FindMsgProc(subtype);
        if (proc == null) {
            this.logger.info("invalid message type - " + subtype.toString());
            return;
        }
        if (msg.getType() == EcsIds.Master_Type.MONITOR_NTF) {
            try {
                JSONObject obj;
                this.logger.info("serial size: " + msg.getMonitorNtf().getSerializedSize());
                this.logger.info("message size: " + msg.getMonitorNtf().getCommand().length());
                this.logger.info("message: " + msg.getMonitorNtf().getCommand());
                byte[] message = msg.getMonitorNtf().getCommand().getBytes();
                if (this.contents == null) {
                    this.logger.info("message is starting with length: " + message.length);
                    this.contents = this.copyByte(message);
                } else {
                    this.contents = this.copyByte(this.contents, message);
                }
                if (JsonUtil.messageComplete(this.contents)) {
                    int lastBrace = 0;
                    for (int i = this.contents.length - 1; i >= 0; --i) {
                        if (this.contents[i] != 125) continue;
                        lastBrace = i;
                        if (i + 1 < this.contents.length) {
                            this.contents[i + 1] = 0;
                        }
                        this.logger.info("last Brace location : " + lastBrace);
                        break;
                    }
                    String decodeString = new String(this.contents, 0, lastBrace + 1);
                    this.logger.info("encodeObject: " + decodeString);
                    obj = JsonUtil.decodeObject(decodeString);
                    if (obj == null) {
                        this.logger.info("json decode is failed.");
                        this.contents = null;
                        return;
                    }
                } else {
                    if (this.contents == null) {
                        this.logger.info("message is not completed. contents == null ");
                    } else {
                        this.logger.info("message is not completed. length: " + this.contents.length);
                    }
                    return;
                }
                EventMgr.getInstance().Invoke((String)obj.get((Object)"type"), obj);
                this.contents = null;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "exception occur", e);
                this.contents = null;
                return;
            }
        } else {
            proc.Proc(msg);
        }
    }
}

