/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.dialogs.MessageDialog;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.resources.FontResources;
import org.tizen.ecp.resources.ImageResources;
import org.tizen.ecp.sock.IConnection;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.sock.SocketClient;
import org.tizen.ecp.utils.ECPProperty;
import org.tizen.ecp.utils.FilePath;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.VMView;
import org.tizen.ecp.views.ViewMgr;

public class ECPMainView
implements IConnection {
    private static Logger logger = LogUtil.getECPLogger(ECPMainView.class).getLogger();
    private boolean running = true;
    private Shell shell = null;
    private Composite mainComposite;
    private Composite middleComposite;
    private Canvas statusCanvas;
    private VMStatus vmStatus = VMStatus.RUNNING;
    protected ECPProperty ecpProperty;
    private Image icon = null;
    ShellAdapter shellAdapter = new ShellAdapter(){

        public void shellClosed(ShellEvent e) {
            logger.info("Main Window is closed");
            ViewMgr.getInstance().close();
            SocketClient.getInstance().disconnect();
            ECPMainView.this.removeShellListeners();
            ECPMainView.this.ecpProperty.setProperty("window.x", ((ECPMainView)ECPMainView.this).shell.getLocation().x);
            ECPMainView.this.ecpProperty.setProperty("window.y", ((ECPMainView)ECPMainView.this).shell.getLocation().y);
            ECPMainView.this.ecpProperty.setProperty("window.width", ((ECPMainView)ECPMainView.this).shell.getSize().x);
            ECPMainView.this.ecpProperty.setProperty("window.height", ((ECPMainView)ECPMainView.this).shell.getSize().y);
            String lastView = ViewMgr.getInstance().getActivate();
            if (lastView == null) {
                lastView = "Event Injector";
            }
            ECPMainView.this.ecpProperty.setProperty("view.last", lastView);
            ECPMainView.this.ecpProperty.storeProperty();
            logger.info("close: x position: " + ((ECPMainView)ECPMainView.this).shell.getLocation().x + ", y position: " + ((ECPMainView)ECPMainView.this).shell.getLocation().y + ", width: " + ((ECPMainView)ECPMainView.this).shell.getSize().x + ", height: " + ((ECPMainView)ECPMainView.this).shell.getSize().y);
            ECPMainView.this.stopRunning();
        }
    };

    private void ui_running(Display display) {
        logger.info("UI runs");
        this.shell = new Shell(display);
        this.composeShell(this.shell);
        this.shell.addShellListener((ShellListener)this.shellAdapter);
        this.createMainContent();
        logger.info("shell opening starts");
        this.shell.open();
        while (this.running && !this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.dispose();
    }

    public void openMainWindow(final Display display) throws Exception {
        logger.info("openMainWindows()");
        this.initialize();
        logger.info("initialize() done");
        Thread currentThread = Thread.currentThread();
        Thread UIThread = display.getThread();
        logger.info("currentThread: " + currentThread + ", UIThread: " + UIThread);
        if (currentThread == UIThread) {
            logger.info("calling from UI thread.");
            this.ui_running(display);
        } else {
            logger.info("calling from non UI thread.");
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ECPMainView.this.ui_running(display);
                }
            });
        }
    }

    private void initialize() throws Exception {
        String propPath = FilePath.getInstance().getVmsPath() + File.separator + VMInfo.getInstance().getVMName() + File.separator + "ecp.property";
        logger.info("property path: " + propPath);
        this.ecpProperty = new ECPProperty(propPath);
        VMView.getInstance().setProperty(this.ecpProperty);
        SocketClient.getInstance().registerDisconnectListener(this);
        MessageSender.getInstance().sendInjectorReq("guest", 15, 0);
    }

    public void stopRunning() {
        this.running = false;
    }

    public void dispose() {
        if (this.icon != null) {
            this.icon.dispose();
        }
        LogUtil.end();
    }

    private void composeShell(Shell shell) {
        int height;
        int width;
        int y;
        int x;
        try {
            x = this.ecpProperty.getPropertyInt("window.x");
            y = this.ecpProperty.getPropertyInt("window.y");
            width = this.ecpProperty.getPropertyInt("window.width");
            height = this.ecpProperty.getPropertyInt("window.height");
        }
        catch (Exception e) {
            x = 100;
            y = 100;
            width = 706;
            height = 580;
        }
        if (width <= 0) {
            width = 706;
        }
        if (height <= 0) {
            height = 580;
        }
        logger.info("x position: " + x + ",y position: " + y);
        logger.info("width: " + width + ",height: " + height);
        shell.setBounds(x, y, width, height);
        shell.setBackgroundMode(1);
        shell.setText("Emulator Control Panel");
        shell.setLayout((Layout)new FillLayout());
        shell.setMinimumSize(200, 200);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("ecp.ico");
        if (is != null) {
            this.icon = new Image((Device)Display.getCurrent(), is);
            shell.setImage(this.icon);
            try {
                is.close();
            }
            catch (IOException e) {
                logger.info("icon inputstream failed to close.");
            }
        } else {
            logger.info("failed to set icon file");
        }
    }

    private void createMainContent() {
        this.mainComposite = new Composite((Composite)this.shell, 0);
        this.mainComposite.setLayout((Layout)new FormLayout());
        this.mainComposite.setBackground(ColorResources.TAB_BG.getColor());
        this.composeStatusBar();
        this.middleComposite = new Composite(this.mainComposite, 0);
        this.middleComposite.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 30);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.middleComposite.setLayoutData((Object)data);
        this.middleComposite.setBackground(ColorResources.TAB_BG.getColor());
        VMView.getInstance().compose(this.middleComposite);
    }

    private void removeShellListeners() {
        if (null != this.shellAdapter) {
            this.shell.removeShellListener((ShellListener)this.shellAdapter);
        }
    }

    private void composeStatusBar() {
        Composite upComposite = new Composite(this.mainComposite, 0);
        upComposite.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 1);
        data.right = new FormAttachment(100, -1);
        data.height = 29;
        upComposite.setLayoutData((Object)data);
        upComposite.setBackground(ColorResources.STATUS_BAR_BG.getColor());
        this.statusCanvas = new Canvas(upComposite, 0);
        FormData canvasData = new FormData();
        canvasData.top = new FormAttachment(0, 5);
        canvasData.left = new FormAttachment(0, 6);
        canvasData.width = 19;
        canvasData.height = 19;
        this.statusCanvas.setLayoutData((Object)canvasData);
        this.statusCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ECPMainView.this.vmStatus == VMStatus.RUNNING) {
                    e.gc.drawImage(ImageResources.CONDITION_RUNNING.getImage(), 0, 0);
                    ECPMainView.this.statusCanvas.setToolTipText("VM status: Running");
                }
                if (ECPMainView.this.vmStatus == VMStatus.DISCONNECT) {
                    e.gc.drawImage(ImageResources.CONDITION_STOP.getImage(), 0, 0);
                    ECPMainView.this.statusCanvas.setToolTipText("VM status: Stop");
                }
                if (ECPMainView.this.vmStatus == VMStatus.SUSPEND) {
                    e.gc.drawImage(ImageResources.CONDITION_SLEEP.getImage(), 0, 0);
                    ECPMainView.this.statusCanvas.setToolTipText("VM status: Sleep");
                }
            }
        });
        Label lblVmName = new Label(upComposite, 0);
        FormData lblVmNameData = new FormData();
        lblVmNameData.left = new FormAttachment(0, 30);
        lblVmNameData.top = new FormAttachment(0, 5);
        lblVmName.setLayoutData((Object)lblVmNameData);
        lblVmName.setText(VMInfo.getInstance().getVMName());
        lblVmName.setFont(FontResources.FONT_12.getFont());
        lblVmName.setForeground(ColorResources.BLACK.getColor());
    }

    public void setVMStatus(VMStatus status) {
        this.vmStatus = status;
        this.statusCanvas.redraw();
    }

    @Override
    public void disconnected() {
        this.stopRunning();
    }

    @Override
    public void guestOn() {
        if (this.vmStatus != VMStatus.RUNNING) {
            this.setVMStatus(VMStatus.RUNNING);
        }
    }

    @Override
    public void guestOff() {
        if (this.vmStatus != VMStatus.DISCONNECT) {
            this.setVMStatus(VMStatus.DISCONNECT);
        }
    }

    @Override
    public void guestOffMessage() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                new MessageDialog(ECPMainView.this.shell).openNotReadyDialog();
            }
        });
    }

    public static enum VMStatus {
        RUNNING,
        SUSPEND,
        DISCONNECT;

    }
}

