/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.category.ECPListCtrl;
import org.tizen.ecp.category.ECPListItem;
import org.tizen.ecp.ecpinfo.xml.ListItemType;
import org.tizen.ecp.resources.ColorResources;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.utils.SwtUtil;

public class ECPLeftView {
    private static Logger logger = LogUtil.getECPLogger(ECPLeftView.class).getLogger();
    private Composite m_composite;
    private ScrolledComposite sc;
    ECPListCtrl m_ctrl = ECPListCtrl.getInstance();
    ECPListItem dmitem;
    ECPListItem appitem;
    ECPListItem ijitem;

    public void create(SashForm parent) {
        this.sc = new ScrolledComposite((Composite)parent, 768);
        this.sc.setLayout((Layout)new FormLayout());
        this.sc.setBackgroundMode(1);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(0, 200);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.sc.setLayoutData((Object)data);
        this.m_composite = new Composite((Composite)this.sc, 0);
        this.m_composite.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.left = new FormAttachment((Control)parent, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.m_composite.setLayoutData((Object)data);
        this.m_composite.setBackground(ColorResources.CATEGORY_BG.getColor());
        this.sc.setSize(200, 690);
        this.sc.setExpandVertical(true);
        this.sc.setExpandHorizontal(true);
        this.sc.setContent((Control)this.m_composite);
        ECPListCtrl.getInstance().create(this.m_composite, 0, 0);
        this.buildTree();
        this.sc.setMinWidth(10);
        this.sc.setMinHeight(this.m_ctrl.getListHeight());
    }

    private ECPListItem findListItem(String parent) {
        if ("null".equals(parent)) {
            return null;
        }
        ArrayList<ECPListItem> items = this.m_ctrl.getItems();
        for (ECPListItem item : items) {
            if (!item.getText().equals(parent)) continue;
            return item;
        }
        return null;
    }

    private void buildTree() {
        List<String> appList;
        String displayTitle = null;
        List<String> monList = ECPInfo.getInstance().getMonitorInfo();
        if (monList != null && monList.size() > 0) {
            this.dmitem = this.m_ctrl.insertItem(null, "Device Manager", null, null, null);
            for (String string : monList) {
                logger.info("monitor item:" + string);
                if (string.equals("Device Tree")) {
                    this.m_ctrl.insertItem(this.dmitem, string, null, null, "d");
                    continue;
                }
                if (string.equals("Network")) {
                    this.m_ctrl.insertItem(this.dmitem, string, null, null, "n");
                    continue;
                }
                if (string.equals("HDS")) {
                    this.m_ctrl.insertItem(this.dmitem, "Host Directory Sharing", null, null, "h");
                    continue;
                }
                logger.warning("wrong monitor item entered : " + string);
            }
        }
        if ((appList = ECPInfo.getInstance().getAppManagerInfo()) != null && appList.size() > 0) {
            this.appitem = this.m_ctrl.insertItem(null, "App Manager", null, null, null);
            for (String app : appList) {
                logger.info("app item:" + app);
                if (app.equals("Uninstaller")) {
                    this.m_ctrl.insertItem(this.appitem, app, null, null, "u");
                    continue;
                }
                logger.warning("wrong monitor item entered : " + app);
            }
        }
        this.ijitem = this.m_ctrl.insertItem(null, "Event Injector", null, null, null);
        List<ListItemType> list = ECPInfo.getInstance().getListInfo();
        if (list == null) {
            return;
        }
        String jarPath = ECPInfo.getInstance().getJarPath();
        for (int i = 0; i < list.size(); ++i) {
            ListItemType type = list.get(i);
            ECPListItem listItem = this.findListItem(type.getParent());
            String fileName = type.getDevice() + "/" + type.getIcon();
            Image dlImage = SwtUtil.dynamicLoadImage(jarPath, fileName);
            String menuName = type.getDevice();
            if (type.getTitle() != null && !type.getTitle().isEmpty()) {
                displayTitle = type.getTitle();
            }
            this.m_ctrl.insertItem(listItem, menuName, displayTitle, dlImage, type.getShortcut());
            if (displayTitle == null) continue;
            displayTitle = null;
        }
    }

    public Composite getComposite() {
        return this.m_composite;
    }
}

