/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import org.tizen.ecp.utils.OSUtil;

public class FilePath {
    public static final String FILE_PARENT = File.separator + "..";
    public static final String ECP_REL_PV_PATH = FILE_PARENT + FILE_PARENT + FILE_PARENT;
    public static final String ECP_REL_INFO_PATH = ECP_REL_PV_PATH + FILE_PARENT + FILE_PARENT;
    public static final String PATH_SDK_INFO = ECP_REL_INFO_PATH + File.separator + "sdk.info";
    public static final String BIN_REL_TOOLS_PATH = ECP_REL_INFO_PATH + File.separator + "tools";
    public static final String BIN_REL_PV_PATH = ECP_REL_INFO_PATH + File.separator + "tools";
    private static String binPath;
    private static String sdbFilePath;
    private static String sdbMacFilePath;
    private static String ansiconFilePath;
    private static String sdkDataPath;
    static FilePath instance;

    private static String findSDKDataPath() {
        String dataPath = null;
        File sdkInfoFile = new File(binPath + PATH_SDK_INFO);
        if (sdkInfoFile.exists()) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(sdkInfoFile));
            }
            catch (FileNotFoundException e) {
                System.out.println(e.getMessage());
                return null;
            }
            String s = null;
            try {
                while ((s = in.readLine()) != null) {
                    int i = s.indexOf("=");
                    if (i == -1) continue;
                    String s1 = s.substring(0, i);
                    String s2 = s.substring(i + 1, s.length());
                    if (!s1.equals("TIZEN_SDK_DATA_PATH")) continue;
                    dataPath = s2;
                }
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            try {
                in.close();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return dataPath;
    }

    public static FilePath getInstance() {
        return instance;
    }

    public String getBinPath() {
        return binPath;
    }

    public String getSdbFilePath() {
        return sdbFilePath;
    }

    public String getSdbMacFilePath() {
        return sdbMacFilePath;
    }

    public String getAnsiconFilePath() {
        return ansiconFilePath;
    }

    public String getPVPath() {
        return FilePath.getInstance().getBinPath() + ECP_REL_PV_PATH;
    }

    public String getVmsPath() {
        if (sdkDataPath == null) {
            sdkDataPath = ".";
        }
        return sdkDataPath + File.separator + "emulator" + File.separator + "vms";
    }

    public String getDataLogPath(String vmname) {
        return sdkDataPath + File.separator + "emulator" + File.separator + "vms" + File.separator + vmname + File.separator + "logs";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File jar = null;
        String BinPath = null;
        String sdb_suffix = null;
        try {
            BinPath = FilePath.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (BinPath != null) {
            jar = new File(BinPath);
            binPath = jar.getParent();
            sdkDataPath = FilePath.findSDKDataPath();
            sdb_suffix = OSUtil.isMacPlatform() ? "sdbscript" : (OSUtil.isLinuxPlatform() ? "sdb" : "sdb.exe");
            try {
                if (OSUtil.isMacPlatform()) {
                    sdbFilePath = new File(binPath).getCanonicalPath().toString() + File.separator + sdb_suffix;
                    sdbMacFilePath = new File(binPath + BIN_REL_TOOLS_PATH).getCanonicalPath() + File.separator + "sdb";
                } else {
                    sdbFilePath = new File(binPath + BIN_REL_TOOLS_PATH).getCanonicalPath() + File.separator + sdb_suffix;
                    if (OSUtil.isWindowsPlatform()) {
                        ansiconFilePath = new File(binPath + FILE_PARENT + FILE_PARENT).getCanonicalPath() + File.separator + "ansicon.exe";
                    }
                }
            }
            catch (IOException e) {
                sdbFilePath = binPath + BIN_REL_TOOLS_PATH + File.separator + sdb_suffix;
            }
        }
        Class<FilePath> clazz = FilePath.class;
        synchronized (FilePath.class) {
            instance = new FilePath();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

