/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.resources;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.tizen.ecp.utils.LogUtil;

class ImageRegistry {
    private static Map<String, Image> map = new HashMap<String, Image>();
    private static Logger logger = LogUtil.getECPLogger(ImageRegistry.class).getLogger();

    ImageRegistry() {
    }

    public static void dispose() {
        for (Image i : map.values()) {
            i.dispose();
        }
    }

    public static Image getImage(String name) {
        Image i = map.get(name);
        if (i == null) {
            ClassLoader loader = ImageRegistry.class.getClassLoader();
            InputStream is = loader.getResourceAsStream(name);
            if (is != null) {
                i = new Image((Device)Display.getCurrent(), is);
                map.put(name, i);
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "IOEXception", e);
                }
            } else {
                logger.info("inputstream in getImage is failed.");
            }
        }
        return i;
    }
}

