/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli;

import com.google.protobuf.GeneratedMessage;
import java.util.Timer;
import java.util.TimerTask;
import org.json.simple.JSONObject;
import org.tizen.cli.AbstractCLI;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.SocketClient;

public class AbstractEmulatorCLI
extends AbstractCLI
implements ILsn {
    public boolean running = true;
    public String help = "";
    public String messageType = null;
    public int returnValue = 0;
    private Timer runTimer = null;
    private TimerTask timerTask = null;
    public boolean timerExpired = false;
    public long timerDelay = 2000L;

    public void startRunning() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            OutputUtil.printError("Interrupted", e);
        }
        if (this.running && this.runTimer == null) {
            this.runTimer = new Timer();
            this.timerTask = new task();
            this.runTimer.schedule(this.timerTask, this.timerDelay);
            while (this.running) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    OutputUtil.printError("Interrupted", e);
                }
            }
        }
    }

    public void stopRunning() {
        OutputUtil.debug("stopRunning called. with run timer: " + this.runTimer);
        this.running = false;
        if (this.runTimer != null) {
            this.runTimer.cancel();
            OutputUtil.debug("runTimer cancel called.");
            this.runTimer = null;
            this.timerTask = null;
        }
    }

    public void printHelp() {
        OutputUtil.println(this.help);
    }

    public void OnEventProc(String eventname, JSONObject jsParam) {
    }

    public void OnEventProcPB(String eventname, GeneratedMessage param) {
    }

    public int executeCLI() {
        int ret = 0;
        this.running = true;
        if (this.messageType != null) {
            EventMgr.getInstance().AddLsn(this.messageType, (ILsn)this);
        }
        if (!SocketClient.getInstance().getGuestStatus()) {
            OutputUtil.printError("Emulator is not ready. Please retry when the emulator is ready.");
            EventMgr.getInstance().RemoveLsn(this.messageType, (ILsn)this);
            return 28;
        }
        ret = this.execute();
        if (this.messageType != null) {
            EventMgr.getInstance().RemoveLsn(this.messageType, (ILsn)this);
        }
        if (this.timerExpired) {
            OutputUtil.printError("Emulator did not repond it. Please retry it.");
            return 129;
        }
        if (ret != 0) {
            return ret;
        }
        return this.returnValue;
    }

    @Override
    public int execute() {
        return this.returnValue;
    }

    public void finished() {
    }

    public void OnStatusEventProcPB(GeneratedMessage param) {
    }

    private class task
    extends TimerTask {
        private task() {
        }

        @Override
        public void run() {
            if (AbstractEmulatorCLI.this.running) {
                AbstractEmulatorCLI.this.running = false;
                AbstractEmulatorCLI.this.timerExpired = true;
            }
        }
    }
}

