/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.UnmodifiableLazyStringList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public class LazyStringArrayList
extends AbstractList<String>
implements LazyStringList,
RandomAccess {
    public static final LazyStringList EMPTY = new UnmodifiableLazyStringList(new LazyStringArrayList());
    private final List<Object> list;

    public LazyStringArrayList() {
        this.list = new ArrayList<Object>();
    }

    public LazyStringArrayList(LazyStringList lazyStringList) {
        this.list = new ArrayList<Object>(lazyStringList.size());
        this.addAll(lazyStringList);
    }

    public LazyStringArrayList(List<String> list) {
        this.list = new ArrayList<String>(list);
    }

    @Override
    public String get(int n) {
        Object object = this.list.get(n);
        if (object instanceof String) {
            return (String)object;
        }
        ByteString byteString = (ByteString)object;
        String string = byteString.toStringUtf8();
        if (byteString.isValidUtf8()) {
            this.list.set(n, string);
        }
        return string;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public String set(int n, String string) {
        Object object = this.list.set(n, string);
        return this.asString(object);
    }

    @Override
    public void add(int n, String string) {
        this.list.add(n, string);
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends String> collection) {
        Collection<? extends String> collection2 = collection instanceof LazyStringList ? ((LazyStringList)collection).getUnderlyingElements() : collection;
        boolean bl = this.list.addAll(n, collection2);
        ++this.modCount;
        return bl;
    }

    @Override
    public String remove(int n) {
        Object object = this.list.remove(n);
        ++this.modCount;
        return this.asString(object);
    }

    @Override
    public void clear() {
        this.list.clear();
        ++this.modCount;
    }

    @Override
    public void add(ByteString byteString) {
        this.list.add(byteString);
        ++this.modCount;
    }

    @Override
    public ByteString getByteString(int n) {
        Object object = this.list.get(n);
        if (object instanceof String) {
            ByteString byteString = ByteString.copyFromUtf8((String)object);
            this.list.set(n, byteString);
            return byteString;
        }
        return (ByteString)object;
    }

    private String asString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return ((ByteString)object).toStringUtf8();
    }

    @Override
    public List<?> getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }
}

