/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIInputStream;

class InputStream {
    XPCOMObject inputStream;
    int refCount = 0;
    byte[] buffer;
    int index = 0;

    InputStream(byte[] byArray) {
        this.buffer = byArray;
        this.index = 0;
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.inputStream = new XPCOMObject(new int[]{2, 0, 0, 0, 1, 3, 4, 1}){

            public int method0(int[] nArray) {
                return InputStream.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return InputStream.this.AddRef();
            }

            public int method2(int[] nArray) {
                return InputStream.this.Release();
            }

            public int method3(int[] nArray) {
                return InputStream.this.Close();
            }

            public int method4(int[] nArray) {
                return InputStream.this.Available(nArray[0]);
            }

            public int method5(int[] nArray) {
                return InputStream.this.Read(nArray[0], nArray[1], nArray[2]);
            }

            public int method6(int[] nArray) {
                return InputStream.this.ReadSegments(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            public int method7(int[] nArray) {
                return InputStream.this.IsNonBlocking(nArray[0]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.inputStream != null) {
            this.inputStream.dispose();
            this.inputStream = null;
        }
    }

    int getAddress() {
        return this.inputStream.getAddress();
    }

    int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147467262;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, n, 16);
        if (nsID2.Equals(XPCOM.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(n2, new int[]{this.inputStream.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (nsID2.Equals(IIDStore.GetIID(nsIInputStream.class))) {
            XPCOM.memmove(n2, new int[]{this.inputStream.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(n2, new int[]{0}, C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int Close() {
        this.buffer = null;
        this.index = 0;
        return 0;
    }

    int Available(int n) {
        int n2;
        int n3 = n2 = this.buffer == null ? 0 : this.buffer.length - this.index;
        if (MozillaVersion.CheckVersion(6)) {
            XPCOM.memmove(n, new long[]{n2}, 8);
        } else {
            XPCOM.memmove(n, new int[]{n2}, 4);
        }
        return 0;
    }

    int Read(int n, int n2, int n3) {
        int n4 = Math.min(n2, this.buffer == null ? 0 : this.buffer.length - this.index);
        if (n4 > 0) {
            byte[] byArray = new byte[n4];
            System.arraycopy(this.buffer, this.index, byArray, 0, n4);
            XPCOM.memmove(n, byArray, n4);
            this.index += n4;
        }
        XPCOM.memmove(n3, new int[]{n4}, 4);
        return 0;
    }

    int ReadSegments(int n, int n2, int n3, int n4) {
        int n5;
        int[] nArray;
        int n6;
        int n7 = n6 = this.buffer == null ? 0 : this.buffer.length - this.index;
        if (n3 != -1) {
            n6 = Math.min(n6, n3);
        }
        for (n5 = n6; n5 > 0; n5 -= nArray[0]) {
            nArray = new int[1];
            int n8 = XPCOM.Call(n, this.getAddress(), n2, this.buffer, this.index, n5, nArray);
            if (n8 != 0) break;
            this.index += nArray[0];
        }
        XPCOM.memmove(n4, new int[]{n6 - n5}, 4);
        return 0;
    }

    int IsNonBlocking(int n) {
        XPCOM.memmove(n, new boolean[]{false});
        return 0;
    }
}

