/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    boolean ignoreResize;
    boolean ignoreSelection;
    static final int TrackBarProc;
    static final TCHAR TrackBarClass;
    boolean createdAsRTL;

    public Scale(Composite composite, int n) {
        super(composite, Scale.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(TrackBarProc, n, n2, n3, n4);
    }

    static int checkStyle(int n) {
        return Scale.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = this.getBorderWidth();
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        RECT rECT = new RECT();
        OS.SendMessage(this.handle, 1049, 0, rECT);
        if ((this.style & 0x100) != 0) {
            n4 += OS.GetSystemMetrics(21) * 10;
            int n6 = OS.GetSystemMetrics(3);
            n5 += rECT.top * 2 + n6 + n6 / 3;
        } else {
            int n7 = OS.GetSystemMetrics(2);
            n4 += rECT.left * 2 + n7 + n7 / 3;
            n5 += OS.GetSystemMetrics(20) * 10;
        }
        if (n != -1) {
            n4 = n + n3 * 2;
        }
        if (n2 != -1) {
            n5 = n2 + n3 * 2;
        }
        return new Point(n4, n5);
    }

    void createHandle() {
        super.createHandle();
        this.state |= 0x300;
        OS.SendMessage(this.handle, 1032, 0, 100);
        OS.SendMessage(this.handle, 1045, 0, 10);
        OS.SendMessage(this.handle, 1044, 10, 0);
        this.createdAsRTL = (this.style & 0x4000000) != 0;
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_BTNFACE);
    }

    public int getIncrement() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1048, 0, 0);
    }

    public int getMaximum() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1026, 0, 0);
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1025, 0, 0);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1046, 0, 0);
    }

    public int getSelection() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1024, 0, 0);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void setBackgroundImage(int n) {
        super.setBackgroundImage(n);
        this.ignoreResize = true;
        OS.SendMessage(this.handle, 5, 0, 0);
        this.ignoreResize = false;
    }

    void setBackgroundPixel(int n) {
        super.setBackgroundPixel(n);
        this.ignoreResize = true;
        OS.SendMessage(this.handle, 5, 0, 0);
        this.ignoreResize = false;
    }

    void setBounds(int n, int n2, int n3, int n4, int n5, boolean bl) {
        super.setBounds(n, n2, n3, n4, n5 &= 0xFFFFFFDF, true);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 1025, 0, 0);
        int n3 = OS.SendMessage(this.handle, 1026, 0, 0);
        if (n > n3 - n2) {
            return;
        }
        OS.SendMessage(this.handle, 1047, 0, n);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 1025, 0, 0);
        if (0 <= n2 && n2 < n) {
            OS.SendMessage(this.handle, 1032, 1, n);
        }
    }

    public void setMinimum(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 1026, 0, 0);
        if (0 <= n && n < n2) {
            OS.SendMessage(this.handle, 1031, 1, n);
        }
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 1025, 0, 0);
        int n3 = OS.SendMessage(this.handle, 1026, 0, 0);
        if (n > n3 - n2) {
            return;
        }
        OS.SendMessage(this.handle, 1045, 0, n);
        OS.SendMessage(this.handle, 1044, n, 0);
    }

    public void setSelection(int n) {
        this.checkWidget();
        OS.SendMessage(this.handle, 1029, 1, n);
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x10000 | 8 | 1;
        if ((this.style & 0x100) != 0) {
            return n | 0 | 0x400;
        }
        return n | 2;
    }

    TCHAR windowClass() {
        return TrackBarClass;
    }

    int windowProc() {
        return TrackBarProc;
    }

    LRESULT WM_KEYDOWN(int n, int n2) {
        LRESULT lRESULT = super.WM_KEYDOWN(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n) {
            case 37: 
            case 39: {
                boolean bl;
                boolean bl2 = bl = (this.style & 0x4000000) != 0;
                if (bl == this.createdAsRTL) break;
                int n3 = this.callWindowProc(this.handle, 256, n == 39 ? 37 : 39, n2);
                return new LRESULT(n3);
            }
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEWHEEL(int n, int n2) {
        LRESULT lRESULT = super.WM_MOUSEWHEEL(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n3 = OS.SendMessage(this.handle, 1024, 0, 0);
        this.ignoreSelection = true;
        int n4 = this.callWindowProc(this.handle, 522, n, n2);
        this.ignoreSelection = false;
        int n5 = OS.SendMessage(this.handle, 1024, 0, 0);
        if (n3 != n5) {
            this.sendSelectionEvent(13, null, true);
        }
        return new LRESULT(n4);
    }

    LRESULT WM_PAINT(int n, int n2) {
        boolean bl;
        if ((this.state & 0x1000) != 0) {
            return LRESULT.ZERO;
        }
        boolean bl2 = bl = this.findBackgroundControl() != null;
        if (!bl && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            Control control = this.findThemeControl();
            boolean bl3 = bl = control != null;
        }
        if (bl) {
            boolean bl4;
            boolean bl5 = bl4 = this.getDrawing() && OS.IsWindowVisible(this.handle);
            if (bl4) {
                OS.SendMessage(this.handle, 11, 0, 0);
            }
            this.ignoreResize = true;
            OS.SendMessage(this.handle, 5, 0, 0);
            this.ignoreResize = false;
            if (bl4) {
                OS.SendMessage(this.handle, 11, 1, 0);
                OS.InvalidateRect(this.handle, null, false);
            }
        }
        return super.WM_PAINT(n, n2);
    }

    LRESULT WM_SIZE(int n, int n2) {
        if (this.ignoreResize) {
            return null;
        }
        return super.WM_SIZE(n, n2);
    }

    LRESULT wmScrollChild(int n, int n2) {
        int n3 = OS.LOWORD(n);
        switch (n3) {
            case 4: 
            case 8: {
                return null;
            }
        }
        if (!this.ignoreSelection) {
            Event event = new Event();
            this.sendSelectionEvent(13, event, true);
        }
        return null;
    }

    static {
        TrackBarClass = new TCHAR(0, "msctls_trackbar32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, TrackBarClass, wNDCLASS);
        TrackBarProc = wNDCLASS.lpfnWndProc;
        int n = OS.GetModuleHandle(null);
        int n2 = OS.GetProcessHeap();
        wNDCLASS.hInstance = n;
        wNDCLASS.style &= 0xFFFFBFFF;
        wNDCLASS.style |= 8;
        int n3 = TrackBarClass.length() * TCHAR.sizeof;
        int n4 = OS.HeapAlloc(n2, 8, n3);
        OS.MoveMemory(n4, TrackBarClass, n3);
        wNDCLASS.lpszClassName = n4;
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(n2, 0, n4);
    }
}

