#! /bin/bash

abspath="$(cd "${0%/*}" 2>/dev/null; echo $PWD/${0##*/})"
absdir=`dirname "$abspath"`

PWD=`pwd`


echo ${0}
echo ${0%/*}
echo ${0##*}
echo ${0##*/}
echo "${PWD}/${0}"
echo $(cd "${0%/*}")
echo $absdir
echo $CWD
echo $PWD
echo $abspath
echo $absdir

# variables for build
BINARY=efl-renderer
HOME=${absdir}
EFL_HOME=${HOME}/../efl-tools
EFL_BIN=${EFL_HOME}/bin
EFL_LIB=${EFL_HOME}/lib
LD_LIBRARY_PATH=${EFL_LIB}:/usr/lib

# add environment variables for EFL
export EVAS_FONT_DPI=72
export ECTOR_BACKEND=default

export FONTCONFIG_PATH=${HOME}/../efl-tools/etc/fonts

# for coredump file
ulimit -c unlimited

# execute binary
cd "${HOME}"
DYLD_LIBRARY_PATH=${LD_LIBRARY_PATH} ./${BINARY} "$@"

#valgrind-test-mode
#LD_LIBRARY_PATH=${LD_LIBRARY_PATH} valgrind --leak-check=full --log-file=valgrind-memcheck.txt ${HOME}/${BINARY} "$@"
