#!/bin/bash -xe

echo $INSTALLED_PATH > "/tmp/tizen_installed_path"
MODIFIED_INSTALLED_PATH=$(sed "s/\//\\\\\//g" "/tmp/tizen_installed_path")
rm -f "/tmp/tizen_installed_path"

echo "==========================================================================="
echo "Set prefix value of EFL pkg config files. INSTALLED_PATH is $INSTALLED_PATH"
echo "==========================================================================="

if [ -d "${INSTALLED_PATH}/platforms/tizen-2.4/common/efl-tool/efl-tools/lib/pkgconfig" ]; then
    cd "${INSTALLED_PATH}/platforms/tizen-2.4/common/efl-tool/efl-tools/lib/pkgconfig"
    for I in `ls *.pc`
    do
        sed -i /^"prefix="/d $I
        sed -i "s/^exec_prefix=/prefix=$MODIFIED_INSTALLED_PATH\/platforms\/tizen-2.4\/common\/efl-tool\/efl-tools\nexec_prefix=/" $I
        sed -i /^"prefix ="/d $I
        sed -i "s/^exec_prefix =/prefix = $MODIFIED_INSTALLED_PATH\/platforms\/tizen-2.4\/common\/efl-tool\/efl-tools\nexec_prefix =/" $I

        if [ ${I} = "elementary.pc" -o ${I} = "elementary-cxx.pc" ]; then
            sed -i /^"exec_prefix="/d $I
            sed -i "s/^libdir=/exec_prefix=\${prefix}\nlibdir=/" $I
            sed -i /^"exec_prefix ="/d $I
            sed -i "s/^libdir =/exec_prefix = \${prefix}\nlibdir =/" $I

            sed -i /^"libdir="/d $I
            sed -i "s/^includedir=/libdir=\${exec_prefix}\/lib\nincludedir=/" $I
            sed -i /^"libdir ="/d $I
            sed -i "s/^includedir =/libdir = \${exec_prefix}\/lib\nincludedir =/" $I

            sed -i /^"includedir="/d $I
            sed -i "s/^datarootdir=/includedir=\${prefix}\/include\ndatarootdir=/" $I
            sed -i /^"includedir ="/d $I
            sed -i "s/^datarootdir =/includedir = \${prefix}\/include\ndatarootdir =/" $I

            sed -i /^"datarootdir="/d $I
            sed -i "s/^datadir=/datarootdir=\${prefix}\/share\ndatadir=/" $I
            sed -i /^"datarootdir ="/d $I
            sed -i "s/^datadir =/datarootdir = \${prefix}\/share\ndatadir =/" $I

            sed -i /^"datadir="/d $I
            sed -i "s/^pkgdatadir=/datadir=\${datarootdir}\npkgdatadir=/" $I
            sed -i /^"datadir ="/d $I
            sed -i "s/^pkgdatadir =/datadir = \${datarootdir}\npkgdatadir =/" $I

            sed -i /^"pkgdatadir="/d $I
            sed -i "s/^themes=/pkgdatadir=\${datarootdir}\/elementary\nthemes=/" $I
            sed -i /^"pkgdatadir ="/d $I
            sed -i "s/^themes =/pkgdatadir = \${datarootdir}\/elementary\nthemes =/" $I
        fi
    done
fi

rm -rf "${HOME}/.elementary"


#Install libudev.so.0 link file based on bashell
OS_BIT=`uname -m`
LIB_UDEV_PATHS=`find "/lib" -name "libudev.so.*"`

for FILE_PATH in $LIB_UDEV_PATHS
do
    if [[ -e "${FILE_PATH}" ]]; then
        file_name=`basename ${FILE_PATH}`
        if [[ ${file_name} == "libudev.so.0" ]]; then
            if [[ ${OS_BIT} == "i386" || ${OS_BIT} == "i686" ]]; then
                if [[ ${FILE_PATH} == *"i386"* || ${FILE_PATH} == *"i686"* ]]; then
                    udev_so0_path=${FILE_PATH}
                fi
            else
                if [[ ${FILE_PATH} == *"x86_64"* ]]; then
                    udev_so0_path=${FILE_PATH}
                fi
            fi
        elif [[ ${file_name} == "libudev.so.1" ]]; then
            if [[ ${OS_BIT} == "i386" || ${OS_BIT} == "i686" ]]; then
                if [[ ${FILE_PATH} == *"i386"* || ${FILE_PATH} == *"i686"* ]]; then
                    udev_so1_path=${FILE_PATH}
                fi
            else
                if [[ ${FILE_PATH} == *"x86_64"* ]]; then
                    udev_so1_path=${FILE_PATH}
                fi
            fi
        else
            if [[ ${OS_BIT} == "i386" || ${OS_BIT} == "i686" ]]; then
                if [[ ${FILE_PATH} == *"i386"* || ${FILE_PATH} == *"i686"* ]]; then
                    udev_so_path=${FILE_PATH}
                fi
            else
                if [[ ${FILE_PATH} == *"x86_64"* ]]; then
                    udev_so_path=${FILE_PATH}
                fi
            fi
        fi
    fi
done

EFL_TOOLS_LIB_PATH="${INSTALLED_PATH}/platforms/tizen-2.4/common/efl-tool/efl-tools/lib"

if [ "${udev_so_path}" ] && [ ! "${udev_so0_path}" ]; then
    echo "Install libudev.so.0 link file"
    if [ -d "${EFL_TOOLS_LIB_PATH}" ] && ! [ -f "${EFL_TOOLS_LIB_PATH}/libudev.so.0" ]; then
        ln -s "${udev_so_path}" "${EFL_TOOLS_LIB_PATH}/libudev.so.0"
    fi
fi

if [ "${udev_so_path}" ] && [ ! "${udev_so1_path}" ]; then
    echo "Install libudev.so.1 link file"
    if [ -d "${EFL_TOOLS_LIB_PATH}" ] && ! [ -f "${EFL_TOOLS_LIB_PATH}/libudev.so.1" ]; then
        ln -s "${udev_so_path}" "${EFL_TOOLS_LIB_PATH}/libudev.so.1"
    fi
fi
