/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBundle;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSDirectoryEnumerator;
import org.eclipse.swt.internal.cocoa.NSEnumerator;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMutableSet;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.NSWorkspace;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Display;

public final class Program {
    String name;
    String fullPath;
    String identifier;
    static final String PREFIX_FILE = "file:/";
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";

    Program() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Program findProgram(String string) {
        long l;
        byte[] byArray;
        char[] cArray;
        NSAutoreleasePool nSAutoreleasePool;
        block8: {
            Program program;
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            try {
                if (string == null) {
                    SWT.error(4);
                }
                if (string.length() != 0) break block8;
                program = null;
                Object var11_4 = null;
            }
            catch (Throwable throwable) {
                Object var11_6 = null;
                nSAutoreleasePool.release();
                throw throwable;
            }
            nSAutoreleasePool.release();
            return program;
        }
        Object object = null;
        if (string.charAt(0) != '.') {
            cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
        } else {
            cArray = new char[string.length() - 1];
            string.getChars(1, string.length(), cArray, 0);
        }
        NSString nSString = NSString.stringWithCharacters(cArray, cArray.length);
        if (nSString != null && OS.LSGetApplicationForInfo(0, 0, nSString.id, -1, byArray = new byte[80], null) == 0L && (l = OS.CFURLCreateFromFSRef(OS.kCFAllocatorDefault(), byArray)) != 0L) {
            NSString nSString2 = new NSURL(l).path();
            NSBundle nSBundle = NSBundle.bundleWithPath(nSString2);
            if (nSBundle != null) {
                object = Program.getProgram(nSBundle);
            }
            OS.CFRelease(l);
        }
        byArray = object;
        Object var11_5 = null;
        nSAutoreleasePool.release();
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getExtensions() {
        Object object;
        NSAutoreleasePool nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            id id2;
            NSObject nSObject;
            Object object2;
            int n;
            NSMutableSet nSMutableSet = (NSMutableSet)NSMutableSet.set();
            NSWorkspace nSWorkspace = NSWorkspace.sharedWorkspace();
            NSString nSString = NSString.stringWith("CFBundleDocumentTypes");
            NSString nSString2 = NSString.stringWith("CFBundleTypeExtensions");
            NSArray nSArray = new NSArray(OS.NSSearchPathForDirectoriesInDomains(100L, 65535L, true));
            int n2 = (int)nSArray.count();
            for (n = 0; n < n2; ++n) {
                object2 = new NSString(nSArray.objectAtIndex(n));
                nSObject = NSFileManager.defaultManager();
                id2 = ((NSFileManager)nSObject).enumeratorAtPath((NSString)object2);
                if (id2 == null) continue;
                while ((object = ((NSEnumerator)id2).nextObject()) != null) {
                    NSBundle nSBundle;
                    ((NSDirectoryEnumerator)id2).skipDescendents();
                    NSString nSString3 = new NSString(((id)object).id);
                    NSString nSString4 = object2.stringByAppendingPathComponent(nSString3);
                    if (!nSWorkspace.isFilePackageAtPath(nSString4) || (object = (nSBundle = NSBundle.bundleWithPath(nSString4)) != null ? nSBundle.infoDictionary().objectForKey(nSString) : null) == null) continue;
                    NSDictionary nSDictionary = new NSDictionary(((id)object).id);
                    NSEnumerator nSEnumerator = nSDictionary.objectEnumerator();
                    while ((object = nSEnumerator.nextObject()) != null) {
                        NSDictionary nSDictionary2 = new NSDictionary(((id)object).id);
                        object = nSDictionary2.objectForKey(nSString2);
                        if (object == null) continue;
                        nSMutableSet.addObjectsFromArray(new NSArray(((id)object).id));
                    }
                }
            }
            n = 0;
            object2 = new String[(int)nSMutableSet.count()];
            nSObject = nSMutableSet.objectEnumerator();
            while ((id2 = ((NSEnumerator)nSObject).nextObject()) != null) {
                object = new NSString(id2.id).getString();
                if (((String)object).equals("*")) continue;
                object2[n++] = "." + (String)object;
            }
            if (n != ((String[])object2).length) {
                object = new String[n];
                System.arraycopy(object2, 0, object, 0, n);
                object2 = object;
            }
            object = object2;
            Object var19_18 = null;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
        return object;
    }

    static Program getProgram(NSBundle nSBundle) {
        NSString nSString = NSString.stringWith("CFBundleName");
        NSString nSString2 = NSString.stringWith("CFBundleDisplayName");
        NSString nSString3 = nSBundle.bundlePath();
        NSString nSString4 = nSBundle.bundleIdentifier();
        id id2 = nSBundle.objectForInfoDictionaryKey(nSString2);
        if (id2 == null) {
            id2 = nSBundle.objectForInfoDictionaryKey(nSString);
        }
        if (id2 == null) {
            if (nSString3 == null) {
                return null;
            }
            id2 = nSString3.lastPathComponent().stringByDeletingPathExtension();
        }
        NSString nSString5 = new NSString(id2.id);
        Program program = new Program();
        program.name = nSString5.getString();
        if (nSString3 != null) {
            program.fullPath = nSString3.getString();
        }
        program.identifier = nSString4 != null ? nSString4.getString() : "";
        return program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Program[] getPrograms() {
        Program[] programArray;
        NSAutoreleasePool nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            ArrayList<Program> arrayList = new ArrayList<Program>();
            NSWorkspace nSWorkspace = NSWorkspace.sharedWorkspace();
            NSArray nSArray = new NSArray(OS.NSSearchPathForDirectoriesInDomains(100L, 65535L, true));
            int n = (int)nSArray.count();
            for (int i = 0; i < n; ++i) {
                id id2;
                NSString nSString = new NSString(nSArray.objectAtIndex(i));
                NSFileManager nSFileManager = NSFileManager.defaultManager();
                NSDirectoryEnumerator nSDirectoryEnumerator = nSFileManager.enumeratorAtPath(nSString);
                if (nSDirectoryEnumerator == null) continue;
                while ((id2 = nSDirectoryEnumerator.nextObject()) != null) {
                    Program program;
                    NSBundle nSBundle;
                    nSDirectoryEnumerator.skipDescendents();
                    NSString nSString2 = nSString.stringByAppendingPathComponent(new NSString(id2.id));
                    if (!nSWorkspace.isFilePackageAtPath(nSString2) || (nSBundle = NSBundle.bundleWithPath(nSString2)) == null || (program = Program.getProgram(nSBundle)) == null) continue;
                    arrayList.add(program);
                }
            }
            programArray = arrayList.toArray(new Program[arrayList.size()]);
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
        return programArray;
    }

    static NSURL getURL(String string) {
        String string2 = string.toLowerCase();
        NSString nSString = string2.startsWith(PREFIX_HTTP) || string2.startsWith(PREFIX_HTTPS) || string2.startsWith(PREFIX_FILE) ? NSString.stringWith("%#") : NSString.stringWith("%");
        NSString nSString2 = NSString.stringWith(string);
        if (NSFileManager.defaultManager().fileExistsAtPath(nSString2)) {
            nSString2 = NSURL.fileURLWithPath(nSString2).absoluteString();
        }
        long l = OS.CFURLCreateStringByAddingPercentEscapes(0L, nSString2.id, nSString.id, 0L, 0x8000100);
        NSString nSString3 = new NSString(l);
        NSURL nSURL = NSURL.URLWithString(nSString3);
        OS.CFRelease(l);
        return nSURL;
    }

    static boolean isExecutable(String string) {
        long l = OS.malloc(1L);
        NSString nSString = NSString.stringWith(string);
        boolean bl = false;
        NSFileManager nSFileManager = NSFileManager.defaultManager();
        if (nSFileManager.fileExistsAtPath(nSString, l)) {
            byte[] byArray = new byte[1];
            OS.memmove(byArray, l, 1L);
            if (byArray[0] == 0 && nSFileManager.isExecutableFileAtPath(nSString)) {
                NSWorkspace nSWorkspace = NSWorkspace.sharedWorkspace();
                NSString nSString2 = nSWorkspace.typeOfFile(nSString, 0L);
                bl = nSString2 != null && (nSWorkspace.type(nSString2, NSString.stringWith("public.unix-executable")) || OS.UTTypeEqual(nSString2.id, NSString.stringWith((String)"public.shell-script").id));
            }
        }
        OS.free(l);
        return bl;
    }

    public static boolean launch(String string) {
        return Program.launch(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean launch(String string, String string2) {
        boolean bl;
        NSAutoreleasePool nSAutoreleasePool;
        block8: {
            boolean bl2;
            block7: {
                if (string == null) {
                    SWT.error(4);
                }
                nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
                try {
                    if (string2 != null && Program.isExecutable(string)) {
                        try {
                            Compatibility.exec(new String[]{string}, null, string2);
                            bl2 = true;
                        }
                        catch (IOException iOException) {
                            boolean bl3 = false;
                            Object var7_7 = null;
                            nSAutoreleasePool.release();
                            return bl3;
                        }
                        Object var7_6 = null;
                        break block7;
                    }
                    NSURL nSURL = Program.getURL(string);
                    NSWorkspace nSWorkspace = NSWorkspace.sharedWorkspace();
                    bl = nSWorkspace.openURL(nSURL);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    nSAutoreleasePool.release();
                    throw throwable;
                }
            }
            nSAutoreleasePool.release();
            return bl2;
        }
        Object var7_8 = null;
        nSAutoreleasePool.release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String string) {
        boolean bl;
        if (string == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        try {
            NSWorkspace nSWorkspace = NSWorkspace.sharedWorkspace();
            NSURL nSURL = Program.getURL(string);
            NSArray nSArray = NSArray.arrayWithObject(nSURL);
            bl = nSWorkspace.openURLs(nSArray, NSString.stringWith(this.identifier), 0L, null, 0L);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            nSAutoreleasePool.release();
            throw throwable;
        }
        nSAutoreleasePool.release();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageData getImageData() {
        NSImage nSImage;
        NSAutoreleasePool nSAutoreleasePool;
        block3: {
            ImageData imageData;
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
            try {
                NSWorkspace nSWorkspace = NSWorkspace.sharedWorkspace();
                NSString nSString = this.fullPath != null ? NSString.stringWith(this.fullPath) : nSWorkspace.fullPathForApplication(NSString.stringWith(this.name));
                if (nSString == null || (nSImage = nSWorkspace.iconForFile(nSString)) == null) break block3;
                NSSize nSSize = new NSSize();
                nSSize.height = 16.0;
                nSSize.width = 16.0;
                nSImage.setSize(nSSize);
                nSImage.retain();
                Image image = Image.cocoa_new(Display.getCurrent(), 0, nSImage);
                ImageData imageData2 = image.getImageData();
                image.dispose();
                imageData = imageData2;
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                nSAutoreleasePool.release();
                throw throwable;
            }
            nSAutoreleasePool.release();
            return imageData;
        }
        nSImage = null;
        Object var10_10 = null;
        nSAutoreleasePool.release();
        return nSImage;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Program) {
            Program program = (Program)object;
            return this.name.equals(program.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

