/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;

    Canvas() {
    }

    public Canvas(Composite composite, int n) {
        super(composite, Canvas.checkStyle(n));
    }

    public void drawBackground(GC gC, int n, int n2, int n3, int n4) {
        this.drawBackground(gC, n, n2, n3, n4, 0, 0);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    Point getIMCaretPos() {
        if (this.caret == null) {
            return super.getIMCaretPos();
        }
        return new Point(this.caret.x, this.caret.y);
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    int gtk_button_press_event(int n, int n2) {
        int n3;
        if (this.ime != null && (n3 = this.ime.gtk_button_press_event(n, n2)) != 0) {
            return n3;
        }
        return super.gtk_button_press_event(n, n2);
    }

    int gtk_commit(int n, int n2) {
        int n3;
        if (this.ime != null && (n3 = this.ime.gtk_commit(n, n2)) != 0) {
            return n3;
        }
        return super.gtk_commit(n, n2);
    }

    int gtk_draw(int n, int n2) {
        boolean bl;
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        boolean bl2 = bl = this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.killFocus();
        }
        int n3 = super.gtk_draw(n, n2);
        if (bl) {
            this.caret.setFocus();
        }
        return n3;
    }

    int gtk_expose_event(int n, int n2) {
        boolean bl;
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        boolean bl2 = bl = this.caret != null && this.caret.isFocusCaret();
        if (bl) {
            this.caret.killFocus();
        }
        int n3 = super.gtk_expose_event(n, n2);
        if (bl) {
            this.caret.setFocus();
        }
        return n3;
    }

    int gtk_focus_in_event(int n, int n2) {
        int n3 = super.gtk_focus_in_event(n, n2);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return n3;
    }

    int gtk_focus_out_event(int n, int n2) {
        int n3 = super.gtk_focus_out_event(n, n2);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return n3;
    }

    int gtk_preedit_changed(int n) {
        int n2;
        if (this.ime != null && (n2 = this.ime.gtk_preedit_changed(n)) != 0) {
            return n2;
        }
        return super.gtk_preedit_changed(n);
    }

    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5 = bl4 = this.caret != null && this.caret.isFocusCaret();
        if (bl4) {
            this.caret.killFocus();
        }
        super.redrawWidget(n, n2, n3, n4, bl, bl2, bl3);
        if (bl4) {
            this.caret.setFocus();
        }
    }

    void releaseChildren(boolean bl) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(bl);
    }

    void reskinChildren(int n) {
        if (this.caret != null) {
            this.caret.reskin(n);
        }
        if (this.ime != null) {
            this.ime.reskin(n);
        }
        super.reskinChildren(n);
    }

    public void scroll(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Control control;
        boolean bl2;
        int n7;
        this.checkWidget();
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        if ((this.style & 0x8000000) != 0) {
            n7 = this.getClientWidth();
            n3 = n7 - n5 - n3;
            n = n7 - n5 - n;
        }
        n7 = n - n3;
        int n8 = n2 - n4;
        if (n7 == 0 && n8 == 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl3 = bl2 = this.caret != null && this.caret.isFocusCaret();
        if (bl2) {
            this.caret.killFocus();
        }
        int n9 = this.paintWindow();
        int n10 = OS.GTK3 ? OS.gdk_window_get_visible_region(n9) : OS.gdk_drawable_get_visible_region(n9);
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n3;
        gdkRectangle.y = n4;
        gdkRectangle.width = n5;
        gdkRectangle.height = n6;
        int n11 = OS.gdk_region_rectangle(gdkRectangle);
        OS.gdk_region_intersect(n11, n10);
        int n12 = OS.gdk_region_rectangle(gdkRectangle);
        OS.gdk_region_subtract(n12, n10);
        OS.gdk_region_offset(n12, n7, n8);
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.gdk_region_get_clipbox(n11, gdkRectangle2);
        if (gdkRectangle2.width != 0 && gdkRectangle2.height != 0) {
            this.update();
        }
        if ((control = this.findBackgroundControl()) == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            this.redrawWidget(n3, n4, n5, n6, false, false, false);
            this.redrawWidget(n, n2, n5, n6, false, false, false);
        } else {
            Object object;
            int n13;
            if (OS.GTK3) {
                n13 = OS.gdk_cairo_create(n9);
                if (Cairo.cairo_version() < Cairo.CAIRO_VERSION_ENCODE(1, 12, 0)) {
                    OS.gdk_cairo_set_source_window(n13, n9, 0, 0);
                } else {
                    Cairo.cairo_push_group(n13);
                    OS.gdk_cairo_set_source_window(n13, n9, 0, 0);
                    Cairo.cairo_paint(n13);
                    Cairo.cairo_pop_group_to_source(n13);
                }
                object = new double[]{1.0, 0.0, 0.0, 1.0, -n7, -n8};
                Cairo.cairo_pattern_set_matrix(Cairo.cairo_get_source(n13), (double[])object);
                Cairo.cairo_rectangle(n13, gdkRectangle2.x + n7, gdkRectangle2.y + n8, gdkRectangle2.width, gdkRectangle2.height);
                Cairo.cairo_clip(n13);
                Cairo.cairo_paint(n13);
                Cairo.cairo_destroy(n13);
            } else {
                n13 = OS.gdk_gc_new(n9);
                OS.gdk_gc_set_exposures(n13, true);
                OS.gdk_draw_drawable(n9, n13, n9, gdkRectangle2.x, gdkRectangle2.y, gdkRectangle2.x + n7, gdkRectangle2.y + n8, gdkRectangle2.width, gdkRectangle2.height);
                OS.g_object_unref(n13);
            }
            int n14 = n13 = n + n5 < n3 || n3 + n5 < n || n2 + n6 < n4 || n4 + n6 < n2 ? 1 : 0;
            if (n13 != 0) {
                object = new GdkRectangle();
                ((GdkRectangle)object).x = n3;
                ((GdkRectangle)object).y = n4;
                ((GdkRectangle)object).width = n5;
                ((GdkRectangle)object).height = n6;
                OS.gdk_region_union_with_rect(n12, (GdkRectangle)object);
            } else {
                int n15;
                object = new GdkRectangle();
                if (n7 != 0) {
                    n15 = n - n7;
                    if (n7 < 0) {
                        n15 = n + n5;
                    }
                    ((GdkRectangle)object).x = n15;
                    ((GdkRectangle)object).y = n4;
                    ((GdkRectangle)object).width = Math.abs(n7);
                    ((GdkRectangle)object).height = n6;
                    OS.gdk_region_union_with_rect(n12, (GdkRectangle)object);
                }
                if (n8 != 0) {
                    n15 = n2 - n8;
                    if (n8 < 0) {
                        n15 = n2 + n6;
                    }
                    ((GdkRectangle)object).x = n3;
                    ((GdkRectangle)object).y = n15;
                    ((GdkRectangle)object).width = n5;
                    ((GdkRectangle)object).height = Math.abs(n8);
                    OS.gdk_region_union_with_rect(n12, (GdkRectangle)object);
                }
            }
            OS.gdk_window_invalidate_region(n9, n12, bl);
        }
        OS.gdk_region_destroy(n10);
        OS.gdk_region_destroy(n11);
        OS.gdk_region_destroy(n12);
        if (bl) {
            Control[] controlArray = this._getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                Control control2 = controlArray[i];
                Rectangle rectangle = control2.getBounds();
                if (Math.min(n3 + n5, rectangle.x + rectangle.width) < Math.max(n3, rectangle.x) || Math.min(n4 + n6, rectangle.y + rectangle.height) < Math.max(n4, rectangle.y)) continue;
                control2.setLocation(rectangle.x + n7, rectangle.y + n8);
            }
        }
        if (bl2) {
            this.caret.setFocus();
        }
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            this.redraw(false);
        }
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = this.caret != null && this.caret.isFocusCaret();
        if (bl3) {
            this.caret.killFocus();
        }
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3) {
            this.caret.setFocus();
        }
        return n5;
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret caret2 = caret;
        Caret caret3 = this.caret;
        this.caret = caret2;
        if (this.hasFocus()) {
            if (caret3 != null) {
                caret3.killFocus();
            }
            if (caret2 != null) {
                if (caret2.isDisposed()) {
                    this.error(5);
                }
                caret2.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    public void setIME(IME iME) {
        this.checkWidget();
        if (iME != null && iME.isDisposed()) {
            this.error(5);
        }
        this.ime = iME;
    }

    void updateCaret() {
        int n = this.imHandle();
        if (n == 0) {
            return;
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = this.caret.x;
        gdkRectangle.y = this.caret.y;
        gdkRectangle.width = this.caret.width;
        gdkRectangle.height = this.caret.height;
        OS.gtk_im_context_set_cursor_location(n, gdkRectangle);
    }
}

