/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TCHITTESTINFO;
import org.eclipse.swt.internal.win32.TCITEM;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    ImageList imageList;
    static final int TabFolderProc;
    static final TCHAR TabFolderClass;
    boolean createdAsRTL;
    static final int ID_UPDOWN = 1;

    public TabFolder(Composite composite, int n) {
        super(composite, TabFolder.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(TabFolderProc, n, n2, n3, n4);
    }

    static int checkStyle(int n) {
        if (OS.IsPPC && (n & 0x80) == 0) {
            n |= 0x400;
        }
        n = TabFolder.checkBits(n, 128, 1024, 0, 0, 0, 0);
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        Point point = super.computeSize(n, n2, bl);
        RECT rECT = new RECT();
        RECT rECT2 = new RECT();
        OS.SendMessage(this.handle, 4904, 0, rECT);
        int n3 = rECT.left - rECT.right;
        int n4 = OS.SendMessage(this.handle, 4868, 0, 0);
        if (n4 != 0) {
            OS.SendMessage(this.handle, 4874, n4 - 1, rECT2);
            n3 = Math.max(n3, rECT2.right - rECT.right);
        }
        RECT rECT3 = new RECT();
        OS.SetRect(rECT3, 0, 0, n3, point.y);
        OS.SendMessage(this.handle, 4904, 1, rECT3);
        int n5 = this.getBorderWidth();
        rECT3.left -= n5;
        rECT3.right += n5;
        n3 = rECT3.right - rECT3.left;
        point.x = Math.max(n3, point.x);
        return point;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
        OS.SendMessage(this.handle, 4904, 1, rECT);
        int n5 = this.getBorderWidth();
        rECT.left -= n5;
        rECT.right += n5;
        rECT.top -= n5;
        rECT.bottom += n5;
        int n6 = rECT.right - rECT.left;
        int n7 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n6, n7);
    }

    void createItem(TabItem tabItem, int n) {
        TabItem[] tabItemArray;
        int n2 = OS.SendMessage(this.handle, 4868, 0, 0);
        if (0 > n || n > n2) {
            this.error(6);
        }
        if (n2 == this.items.length) {
            tabItemArray = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, tabItemArray, 0, this.items.length);
            this.items = tabItemArray;
        }
        if (OS.SendMessage(this.handle, OS.TCM_INSERTITEM, n, (TCITEM)(tabItemArray = new TCITEM())) == -1) {
            this.error(14);
        }
        System.arraycopy(this.items, n, this.items, n + 1, n2 - n);
        this.items[n] = tabItem;
        if (n2 == 0) {
            Event event = new Event();
            event.item = this.items[0];
            this.sendSelectionEvent(13, event, true);
        }
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        if (OS.IsPPC) {
            OS.SendMessage(this.handle, 8199, 524, 0);
        }
        int n = OS.SendMessage(this.handle, 4909, 0, 0);
        OS.SendMessage(n, 1048, 0, Short.MAX_VALUE);
        this.createdAsRTL = (this.style & 0x4000000) != 0;
    }

    void createWidget() {
        super.createWidget();
        this.items = new TabItem[4];
    }

    void destroyItem(TabItem tabItem) {
        int n;
        int n2 = OS.SendMessage(this.handle, 4868, 0, 0);
        for (n = 0; n < n2 && this.items[n] != tabItem; ++n) {
        }
        if (n == n2) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 4875, 0, 0);
        if (OS.SendMessage(this.handle, 4872, n, 0) == 0) {
            this.error(15);
        }
        System.arraycopy(this.items, n + 1, this.items, n, --n2 - n);
        this.items[n2] = null;
        if (n2 == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 4867, 0, 0);
                this.display.releaseImageList(this.imageList);
            }
            this.imageList = null;
            this.items = new TabItem[4];
        }
        if (n2 > 0 && n == n3) {
            this.setSelection(Math.max(0, n3 - 1), true);
        }
    }

    void drawThemeBackground(int n, int n2, RECT rECT) {
        RECT rECT2 = new RECT();
        OS.GetClientRect(this.handle, rECT2);
        OS.MapWindowPoints(this.handle, n2, rECT2, 2);
        if (OS.IntersectRect(new RECT(), rECT2, rECT)) {
            OS.DrawThemeBackground(this.display.hTabTheme(), n, 10, 0, rECT2, null);
        }
    }

    Control findThemeControl() {
        return this;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        OS.SendMessage(this.handle, 4904, 0, rECT);
        int n = rECT.right - rECT.left;
        int n2 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n, n2);
    }

    public TabItem getItem(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4868, 0, 0);
        if (0 > n || n >= n2) {
            this.error(6);
        }
        return this.items[n];
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        TCHITTESTINFO tCHITTESTINFO = new TCHITTESTINFO();
        tCHITTESTINFO.x = point.x;
        tCHITTESTINFO.y = point.y;
        int n = OS.SendMessage(this.handle, 4877, 0, tCHITTESTINFO);
        if (n == -1) {
            return null;
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4868, 0, 0);
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 4868, 0, 0);
        TabItem[] tabItemArray = new TabItem[n];
        System.arraycopy(this.items, 0, tabItemArray, 0, n);
        return tabItemArray;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 4875, 0, 0);
        if (n == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[n]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4875, 0, 0);
    }

    int imageIndex(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.imageList == null) {
            Rectangle rectangle = image.getBounds();
            this.imageList = this.display.getImageList(this.style & 0x4000000, rectangle.width, rectangle.height);
            int n = this.imageList.add(image);
            int n2 = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4867, 0, n2);
            return n;
        }
        int n = this.imageList.indexOf(image);
        if (n == -1) {
            n = this.imageList.add(image);
        } else {
            this.imageList.put(n, image);
        }
        return n;
    }

    public int indexOf(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        int n = OS.SendMessage(this.handle, 4868, 0, 0);
        for (int i = 0; i < n; ++i) {
            if (this.items[i] != tabItem) continue;
            return i;
        }
        return -1;
    }

    Point minimumSize(int n, int n2, boolean bl) {
        Control[] controlArray = this._getChildren();
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < controlArray.length; ++i) {
            SerializableCompatibility serializableCompatibility;
            int n5;
            Control control = controlArray[i];
            int n6 = OS.SendMessage(this.handle, 4868, 0, 0);
            for (n5 = 0; n5 < n6 && this.items[n5].control != control; ++n5) {
            }
            if (n5 == n6) {
                serializableCompatibility = control.getBounds();
                n3 = Math.max(n3, serializableCompatibility.x + serializableCompatibility.width);
                n4 = Math.max(n4, serializableCompatibility.y + serializableCompatibility.height);
                continue;
            }
            serializableCompatibility = control.computeSize(n, n2, bl);
            n3 = Math.max(n3, ((Point)serializableCompatibility).x);
            n4 = Math.max(n4, ((Point)serializableCompatibility).y);
        }
        return new Point(n3, n4);
    }

    boolean mnemonicHit(char c) {
        for (int i = 0; i < this.items.length; ++i) {
            TabItem tabItem = this.items[i];
            if (tabItem == null) continue;
            char c2 = this.findMnemonic(tabItem.getText());
            if (Character.toUpperCase(c) != Character.toUpperCase(c2) || !this.forceFocus()) continue;
            if (i != this.getSelectionIndex()) {
                this.setSelection(i, true);
            }
            return true;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        for (int i = 0; i < this.items.length; ++i) {
            TabItem tabItem = this.items[i];
            if (tabItem == null) continue;
            char c2 = this.findMnemonic(tabItem.getText());
            if (Character.toUpperCase(c) != Character.toUpperCase(c2)) continue;
            return true;
        }
        return false;
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = OS.SendMessage(this.handle, 4868, 0, 0);
            for (int i = 0; i < n; ++i) {
                TabItem tabItem = this.items[i];
                if (tabItem == null || tabItem.isDisposed()) continue;
                tabItem.release(false);
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4867, 0, 0);
            this.display.releaseImageList(this.imageList);
        }
        this.imageList = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n = OS.SendMessage(this.handle, 4868, 0, 0);
        for (int i = 0; i < n; ++i) {
            TabItem tabItem = this.items[i];
            if (tabItem.control != control) continue;
            tabItem.setControl(null);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void reskinChildren(int n) {
        if (this.items != null) {
            int n2 = OS.SendMessage(this.handle, 4868, 0, 0);
            for (int i = 0; i < n2; ++i) {
                TabItem tabItem = this.items[i];
                if (tabItem == null) continue;
                tabItem.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    public void setSelection(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{tabItem});
    }

    public void setSelection(TabItem[] tabItemArray) {
        this.checkWidget();
        if (tabItemArray == null) {
            this.error(4);
        }
        if (tabItemArray.length == 0) {
            this.setSelection(-1, false);
        } else {
            for (int i = tabItemArray.length - 1; i >= 0; --i) {
                int n = this.indexOf(tabItemArray[i]);
                if (n == -1) continue;
                this.setSelection(n, false);
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        Rectangle rectangle = this.getClientArea();
        super.setFont(font);
        Rectangle rectangle2 = this.getClientArea();
        if (!rectangle.equals(rectangle2)) {
            this.sendResize();
            int n = OS.SendMessage(this.handle, 4875, 0, 0);
            if (n != -1) {
                TabItem tabItem = this.items[n];
                Control control = tabItem.control;
                if (control != null && !control.isDisposed()) {
                    control.setBounds(this.getClientArea());
                }
            }
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4868, 0, 0);
        if (0 > n || n >= n2) {
            return;
        }
        this.setSelection(n, false);
    }

    void setSelection(int n, boolean bl) {
        Widget widget;
        int n2 = OS.SendMessage(this.handle, 4875, 0, 0);
        if (n2 == n) {
            return;
        }
        if (n2 != -1) {
            TabItem tabItem = this.items[n2];
            widget = tabItem.control;
            if (widget != null && !widget.isDisposed()) {
                widget.setVisible(false);
            }
        }
        OS.SendMessage(this.handle, 4876, n, 0);
        int n3 = OS.SendMessage(this.handle, 4875, 0, 0);
        if (n3 != -1) {
            widget = this.items[n3];
            Control control = ((TabItem)widget).control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (bl) {
                Event event = new Event();
                event.item = widget;
                this.sendSelectionEvent(13, event, true);
            }
        }
    }

    boolean updateTextDirection(int n) {
        if (super.updateTextDirection(n)) {
            if (n != 0x6000000) {
                n = this.style & Integer.MIN_VALUE;
            }
            int n2 = this.items.length;
            for (int i = 0; i < n2 && this.items[i] != null; ++i) {
                this.items[i].updateTextDirection(n);
            }
            return true;
        }
        return false;
    }

    String toolTipText(NMTTDISPINFO nMTTDISPINFO) {
        if ((nMTTDISPINFO.uFlags & 1) != 0) {
            return null;
        }
        int n = nMTTDISPINFO.idFrom;
        int n2 = OS.SendMessage(this.handle, 4909, 0, 0);
        if (n2 == nMTTDISPINFO.hwndFrom) {
            TabItem tabItem;
            int n3 = -2080374784;
            nMTTDISPINFO.uFlags = (this.style & n3) != 0 && (this.style & n3) != n3 ? (nMTTDISPINFO.uFlags |= 4) : (nMTTDISPINFO.uFlags &= 0xFFFFFFFB);
            if (this.toolTipText != null) {
                return "";
            }
            if (0 <= n && n < this.items.length && (tabItem = this.items[n]) != null) {
                return tabItem.toolTipText;
            }
        }
        return super.toolTipText(nMTTDISPINFO);
    }

    boolean traversePage(boolean bl) {
        int n = this.getItemCount();
        if (n <= 1) {
            return false;
        }
        int n2 = this.getSelectionIndex();
        if (n2 == -1) {
            n2 = 0;
        } else {
            int n3 = bl ? 1 : -1;
            n2 = (n2 + n3 + n) % n;
        }
        this.setSelection(n2, true);
        if (n2 == this.getSelectionIndex()) {
            OS.SendMessage(this.handle, 295, 3, 0);
            return true;
        }
        return false;
    }

    void updateOrientation() {
        int n;
        Object object;
        super.updateOrientation();
        int n2 = OS.GetWindow(this.handle, 5);
        while (n2 != 0) {
            object = new TCHAR(0, 128);
            OS.GetClassName(n2, (TCHAR)object, ((TCHAR)object).length());
            String string = ((TCHAR)object).toString(0, ((TCHAR)object).strlen());
            if (string.equals("msctls_updown32")) {
                n = OS.GetWindowLong(n2, -20);
                n = (this.style & 0x4000000) != 0 ? (n |= 0x400000) : (n &= 0xFFBFFFFF);
                OS.SetWindowLong(n2, -20, n &= 0xFFFFDFFF);
                OS.InvalidateRect(n2, null, true);
                break;
            }
            n2 = OS.GetWindow(n2, 2);
        }
        object = new RECT();
        OS.GetWindowRect(this.handle, (RECT)object);
        int n3 = ((RECT)object).right - ((RECT)object).left;
        n = ((RECT)object).bottom - ((RECT)object).top;
        OS.SetWindowPos(this.handle, 0, 0, 0, n3 - 1, n - 1, 6);
        OS.SetWindowPos(this.handle, 0, 0, 0, n3, n, 6);
        if (this.imageList != null) {
            TabItem tabItem;
            Point point = this.imageList.getImageSize();
            this.display.releaseImageList(this.imageList);
            this.imageList = this.display.getImageList(this.style & 0x4000000, point.x, point.y);
            int n4 = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4867, 0, n4);
            TCITEM tCITEM = new TCITEM();
            tCITEM.mask = 2;
            for (int i = 0; i < this.items.length && (tabItem = this.items[i]) != null; ++i) {
                Image image = tabItem.image;
                if (image == null) continue;
                tCITEM.iImage = this.imageIndex(image);
                OS.SendMessage(this.handle, OS.TCM_SETITEM, i, tCITEM);
            }
        }
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x2000000;
        if ((this.style & 0x80000) != 0) {
            n |= 0x8000;
        }
        if ((this.style & 0x400) != 0) {
            n |= 2;
        }
        return n | 0 | 0x4000;
    }

    TCHAR windowClass() {
        return TabFolderClass;
    }

    int windowProc() {
        return TabFolderProc;
    }

    LRESULT WM_GETDLGCODE(int n, int n2) {
        LRESULT lRESULT = super.WM_GETDLGCODE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return new LRESULT(8193);
    }

    LRESULT WM_GETOBJECT(int n, int n2) {
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(n, n2);
    }

    LRESULT WM_KEYDOWN(int n, int n2) {
        LRESULT lRESULT = super.WM_KEYDOWN(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n) {
            case 37: 
            case 39: {
                boolean bl;
                boolean bl2 = bl = (this.style & 0x4000000) != 0;
                if (bl == this.createdAsRTL) break;
                int n3 = this.callWindowProc(this.handle, 256, n == 39 ? 37 : 39, n2);
                return new LRESULT(n3);
            }
        }
        return lRESULT;
    }

    LRESULT WM_MOUSELEAVE(int n, int n2) {
        LRESULT lRESULT = super.WM_MOUSELEAVE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            int n3 = OS.SendMessage(this.handle, 4909, 0, 0);
            if (OS.SendMessage(n3, OS.TTM_GETCURRENTTOOL, 0, tOOLINFO) != 0 && (tOOLINFO.uFlags & 1) == 0) {
                OS.SendMessage(n3, OS.TTM_DELTOOL, 0, tOOLINFO);
                OS.SendMessage(n3, OS.TTM_ADDTOOL, 0, tOOLINFO);
            }
        }
        return lRESULT;
    }

    LRESULT WM_NCHITTEST(int n, int n2) {
        LRESULT lRESULT = super.WM_NCHITTEST(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n3 = OS.DefWindowProc(this.handle, 132, n, n2);
        return new LRESULT(n3);
    }

    LRESULT WM_NOTIFY(int n, int n2) {
        LRESULT lRESULT = super.WM_NOTIFY(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PARENTNOTIFY(int n, int n2) {
        LRESULT lRESULT = super.WM_PARENTNOTIFY(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return lRESULT;
        }
        if ((this.style & 0x4000000) != 0) {
            int n3 = OS.LOWORD(n);
            switch (n3) {
                case 1: {
                    int n4 = OS.HIWORD(n);
                    int n5 = n2;
                    if (n4 != 1) break;
                    int n6 = OS.GetWindowLong(n5, -20);
                    OS.SetWindowLong(n5, -20, n6 | 0x400000);
                    break;
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n, int n2) {
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if (this.isDisposed()) {
            return lRESULT;
        }
        int n3 = OS.SendMessage(this.handle, 4875, 0, 0);
        if (n3 != -1) {
            TabItem tabItem = this.items[n3];
            Control control = tabItem.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
            }
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n, int n2) {
        int n3;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        WINDOWPOS wINDOWPOS = new WINDOWPOS();
        OS.MoveMemory(wINDOWPOS, n2, WINDOWPOS.sizeof);
        if ((wINDOWPOS.flags & 9) != 0) {
            return lRESULT;
        }
        int n4 = OS.GetWindowLong(this.handle, -16);
        if ((n4 & 0x200) != 0) {
            OS.InvalidateRect(this.handle, null, true);
            return lRESULT;
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, 0, 0, wINDOWPOS.cx, wINDOWPOS.cy);
        OS.SendMessage(this.handle, 131, 0, rECT);
        int n5 = rECT.right - rECT.left;
        int n6 = rECT.bottom - rECT.top;
        OS.GetClientRect(this.handle, rECT);
        int n7 = rECT.right - rECT.left;
        int n8 = rECT.bottom - rECT.top;
        if (n5 == n7 && n6 == n8) {
            return lRESULT;
        }
        RECT rECT2 = new RECT();
        OS.SendMessage(this.handle, 4904, 0, rECT2);
        int n9 = -rECT2.right;
        int n10 = -rECT2.bottom;
        if (n5 != n7) {
            n3 = n7;
            if (n5 < n7) {
                n3 = n5;
            }
            OS.SetRect(rECT, n3 - n9, 0, n5, n6);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        if (n6 != n8) {
            n3 = n8;
            if (n6 < n8) {
                n3 = n6;
            }
            if (n5 < n7) {
                n7 -= n9;
            }
            OS.SetRect(rECT, 0, n3 - n10, n7, n6);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        return lRESULT;
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, int n, int n2) {
        int n3 = nMHDR.code;
        switch (n3) {
            case -552: 
            case -551: {
                Object object;
                TabItem tabItem = null;
                int n4 = OS.SendMessage(this.handle, 4875, 0, 0);
                if (n4 != -1) {
                    tabItem = this.items[n4];
                }
                if (tabItem != null && (object = tabItem.control) != null && !((Widget)object).isDisposed()) {
                    if (n3 == -551) {
                        ((Control)object).setBounds(this.getClientArea());
                    }
                    ((Control)object).setVisible(n3 == -551);
                }
                if (n3 != -551) break;
                object = new Event();
                ((Event)object).item = tabItem;
                this.sendSelectionEvent(13, (Event)object, false);
            }
        }
        return super.wmNotifyChild(nMHDR, n, n2);
    }

    static {
        TabFolderClass = new TCHAR(0, "SysTabControl32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, TabFolderClass, wNDCLASS);
        TabFolderProc = wNDCLASS.lpfnWndProc;
        int n = OS.GetModuleHandle(null);
        int n2 = OS.GetProcessHeap();
        wNDCLASS.hInstance = n;
        wNDCLASS.style &= 0xFFFFBFFC;
        int n3 = TabFolderClass.length() * TCHAR.sizeof;
        int n4 = OS.HeapAlloc(n2, 8, n3);
        OS.MoveMemory(n4, TabFolderClass, n3);
        wNDCLASS.lpszClassName = n4;
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(n2, 0, n4);
    }
}

