/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class ClipboardProxy {
    Object[] clipboardData;
    Transfer[] clipboardDataTypes;
    Object[] primaryClipboardData;
    Transfer[] primaryClipboardDataTypes;
    int clipboardOwner = OS.gtk_window_new(0);
    Display display;
    Clipboard activeClipboard = null;
    Clipboard activePrimaryClipboard = null;
    Callback getFunc;
    Callback clearFunc;
    static String ID = "CLIPBOARD PROXY OBJECT";

    static ClipboardProxy _getInstance(final Display display) {
        ClipboardProxy clipboardProxy = (ClipboardProxy)display.getData(ID);
        if (clipboardProxy != null) {
            return clipboardProxy;
        }
        clipboardProxy = new ClipboardProxy(display);
        display.setData(ID, clipboardProxy);
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ClipboardProxy clipboardProxy = (ClipboardProxy)display.getData(ID);
                if (clipboardProxy == null) {
                    return;
                }
                display.setData(ID, null);
                clipboardProxy.dispose();
            }
        });
        return clipboardProxy;
    }

    ClipboardProxy(Display display) {
        this.display = display;
        this.getFunc = new Callback(this, "getFunc", 4);
        if (this.getFunc.getAddress() == 0) {
            SWT.error(3);
        }
        this.clearFunc = new Callback(this, "clearFunc", 2);
        if (this.clearFunc.getAddress() == 0) {
            SWT.error(3);
        }
    }

    void clear(Clipboard clipboard, int n) {
        if ((n & 1) != 0 && this.activeClipboard == clipboard) {
            OS.gtk_clipboard_clear(Clipboard.GTKCLIPBOARD);
        }
        if ((n & 2) != 0 && this.activePrimaryClipboard == clipboard) {
            OS.gtk_clipboard_clear(Clipboard.GTKPRIMARYCLIPBOARD);
        }
    }

    int clearFunc(int n, int n2) {
        if (n == Clipboard.GTKCLIPBOARD) {
            this.activeClipboard = null;
            this.clipboardData = null;
            this.clipboardDataTypes = null;
        }
        if (n == Clipboard.GTKPRIMARYCLIPBOARD) {
            this.activePrimaryClipboard = null;
            this.primaryClipboardData = null;
            this.primaryClipboardDataTypes = null;
        }
        return 1;
    }

    void dispose() {
        if (this.display == null) {
            return;
        }
        if (this.activeClipboard != null) {
            OS.gtk_clipboard_store(Clipboard.GTKCLIPBOARD);
        }
        if (this.activePrimaryClipboard != null) {
            OS.gtk_clipboard_store(Clipboard.GTKPRIMARYCLIPBOARD);
        }
        this.display = null;
        if (this.getFunc != null) {
            this.getFunc.dispose();
        }
        this.getFunc = null;
        if (this.clearFunc != null) {
            this.clearFunc.dispose();
        }
        this.clearFunc = null;
        this.clipboardData = null;
        this.clipboardDataTypes = null;
        this.primaryClipboardData = null;
        this.primaryClipboardDataTypes = null;
        if (this.clipboardOwner != 0) {
            OS.gtk_widget_destroy(this.clipboardOwner);
        }
        this.clipboardOwner = 0;
    }

    int getFunc(int n, int n2, int n3, int n4) {
        if (n2 == 0) {
            return 0;
        }
        int n5 = OS.gtk_selection_data_get_target(n2);
        TransferData transferData = new TransferData();
        transferData.type = n5;
        Transfer[] transferArray = n == Clipboard.GTKCLIPBOARD ? this.clipboardDataTypes : this.primaryClipboardDataTypes;
        int n6 = -1;
        for (int i = 0; i < transferArray.length; ++i) {
            if (!transferArray[i].isSupportedType(transferData)) continue;
            n6 = i;
            break;
        }
        if (n6 == -1) {
            return 0;
        }
        Object[] objectArray = n == Clipboard.GTKCLIPBOARD ? this.clipboardData : this.primaryClipboardData;
        transferArray[n6].javaToNative(objectArray[n6], transferData);
        if (transferData.format < 8 || transferData.format % 8 != 0) {
            return 0;
        }
        OS.gtk_selection_data_set(n2, transferData.type, transferData.format, transferData.pValue, transferData.length);
        OS.g_free(transferData.pValue);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean setData(Clipboard clipboard, Object[] objectArray, Transfer[] transferArray, int n) {
        int n2;
        int n3;
        GtkTargetEntry[] gtkTargetEntryArray;
        block19: {
            boolean bl;
            block18: {
                boolean bl2;
                block17: {
                    gtkTargetEntryArray = new GtkTargetEntry[]{};
                    n3 = 0;
                    try {
                        int n4;
                        for (n4 = 0; n4 < transferArray.length; ++n4) {
                            Transfer transfer = transferArray[n4];
                            int[] nArray = transfer.getTypeIds();
                            String[] stringArray = transfer.getTypeNames();
                            for (int i = 0; i < nArray.length; ++i) {
                                GtkTargetEntry gtkTargetEntry = new GtkTargetEntry();
                                gtkTargetEntry.info = nArray[i];
                                byte[] byArray = Converter.wcsToMbcs(null, stringArray[i], true);
                                int n5 = OS.g_malloc(byArray.length);
                                OS.memmove(n5, byArray, byArray.length);
                                gtkTargetEntry.target = n5;
                                GtkTargetEntry[] gtkTargetEntryArray2 = new GtkTargetEntry[gtkTargetEntryArray.length + 1];
                                System.arraycopy(gtkTargetEntryArray, 0, gtkTargetEntryArray2, 0, gtkTargetEntryArray.length);
                                gtkTargetEntryArray2[gtkTargetEntryArray.length] = gtkTargetEntry;
                                gtkTargetEntryArray = gtkTargetEntryArray2;
                            }
                        }
                        n3 = OS.g_malloc(GtkTargetEntry.sizeof * gtkTargetEntryArray.length);
                        n4 = 0;
                        for (n2 = 0; n2 < gtkTargetEntryArray.length; n4 += GtkTargetEntry.sizeof, ++n2) {
                            OS.memmove(n3 + n4, gtkTargetEntryArray[n2], GtkTargetEntry.sizeof);
                        }
                        if ((n & 1) != 0) {
                            int n6;
                            this.clipboardData = objectArray;
                            this.clipboardDataTypes = transferArray;
                            n2 = this.getFunc.getAddress();
                            if (!OS.gtk_clipboard_set_with_owner(Clipboard.GTKCLIPBOARD, n3, gtkTargetEntryArray.length, n2, n6 = this.clearFunc.getAddress(), this.clipboardOwner)) {
                                bl2 = false;
                                Object var17_21 = null;
                                break block17;
                            }
                            OS.gtk_clipboard_set_can_store(Clipboard.GTKCLIPBOARD, 0, 0);
                            this.activeClipboard = clipboard;
                        }
                        if ((n & 2) != 0) {
                            int n7;
                            this.primaryClipboardData = objectArray;
                            this.primaryClipboardDataTypes = transferArray;
                            n2 = this.getFunc.getAddress();
                            if (!OS.gtk_clipboard_set_with_owner(Clipboard.GTKPRIMARYCLIPBOARD, n3, gtkTargetEntryArray.length, n2, n7 = this.clearFunc.getAddress(), this.clipboardOwner)) {
                                bl = false;
                                break block18;
                            }
                            OS.gtk_clipboard_set_can_store(Clipboard.GTKPRIMARYCLIPBOARD, 0, 0);
                            this.activePrimaryClipboard = clipboard;
                        }
                        n2 = 1;
                        break block19;
                    }
                    catch (Throwable throwable) {
                        Object var17_24 = null;
                        int n8 = 0;
                        while (true) {
                            if (n8 >= gtkTargetEntryArray.length) {
                                if (n3 == 0) throw throwable;
                                OS.g_free(n3);
                                throw throwable;
                            }
                            GtkTargetEntry gtkTargetEntry = gtkTargetEntryArray[n8];
                            if (gtkTargetEntry.target != 0) {
                                OS.g_free(gtkTargetEntry.target);
                            }
                            ++n8;
                        }
                    }
                }
                for (int i = 0; i < gtkTargetEntryArray.length; ++i) {
                    GtkTargetEntry gtkTargetEntry = gtkTargetEntryArray[i];
                    if (gtkTargetEntry.target == 0) continue;
                    OS.g_free(gtkTargetEntry.target);
                }
                if (n3 == 0) return bl2;
                OS.g_free(n3);
                return bl2;
            }
            Object var17_22 = null;
            for (int i = 0; i < gtkTargetEntryArray.length; ++i) {
                GtkTargetEntry gtkTargetEntry = gtkTargetEntryArray[i];
                if (gtkTargetEntry.target == 0) continue;
                OS.g_free(gtkTargetEntry.target);
            }
            if (n3 == 0) return bl;
            OS.g_free(n3);
            return bl;
        }
        Object var17_23 = null;
        int n9 = 0;
        while (true) {
            if (n9 >= gtkTargetEntryArray.length) {
                if (n3 == 0) return n2 != 0;
                OS.g_free(n3);
                return n2 != 0;
            }
            GtkTargetEntry gtkTargetEntry = gtkTargetEntryArray[n9];
            if (gtkTargetEntry.target != 0) {
                OS.g_free(gtkTargetEntry.target);
            }
            ++n9;
        }
    }
}

