/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.history.LocalHistoryPage;
import org.eclipse.team.internal.ui.history.LocalHistoryPageSource;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class ShowLocalHistory
extends ActionDelegate
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPart targetPart;

    public void run(IAction action) {
        IFileState[] states = this.getLocalHistory();
        if (states == null || states.length == 0) {
            return;
        }
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    final IResource resource = (IResource)ShowLocalHistory.this.fSelection.getFirstElement();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            IHistoryView view = TeamUI.showHistoryFor(TeamUIPlugin.getActivePage(), resource, LocalHistoryPageSource.getInstance());
                            IHistoryPage page = view.getHistoryPage();
                            if (page instanceof LocalHistoryPage) {
                                LocalHistoryPage historyPage = (LocalHistoryPage)page;
                                historyPage.setClickAction(ShowLocalHistory.this.isCompare());
                            }
                        }
                    };
                    TeamUIPlugin.getStandardDisplay().asyncExec(r);
                }
            });
        }
        catch (InvocationTargetException exception) {
            ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)new Status(4, "org.eclipse.team.ui", 4, TeamUIMessages.ShowLocalHistory_1, exception.getTargetException()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void selectionChanged(IAction action, ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)sel;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    protected Shell getShell() {
        if (this.targetPart != null) {
            return this.targetPart.getSite().getShell();
        }
        return TeamUIPlugin.getActivePage().getActivePart().getSite().getShell();
    }

    protected boolean isCompare() {
        return false;
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }

    protected IFileState[] getLocalHistory() {
        IFileState[] states;
        IFile file = (IFile)this.getSelection().getFirstElement();
        try {
            states = file.getHistory(null);
        }
        catch (CoreException ex) {
            MessageDialog.openError((Shell)this.getShell(), (String)this.getPromptTitle(), (String)ex.getMessage());
            return null;
        }
        if (states == null || states.length <= 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getPromptTitle(), (String)TeamUIMessages.ShowLocalHistory_0);
            return states;
        }
        return states;
    }

    protected String getPromptTitle() {
        return TeamUIMessages.ShowLocalHistory_2;
    }
}

